/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class ReflectUtils {
    private final Class<?> type;
    private final Object object;

    private ReflectUtils(Class<?> clazz) {
        this(clazz, clazz);
    }

    private ReflectUtils(Class<?> clazz, Object object) {
        this.type = clazz;
        this.object = object;
    }

    public static ReflectUtils reflect(String string) {
        return ReflectUtils.reflect(ReflectUtils.forName(string));
    }

    public static ReflectUtils reflect(String string, ClassLoader classLoader) {
        return ReflectUtils.reflect(ReflectUtils.forName(string, classLoader));
    }

    public static ReflectUtils reflect(Class<?> clazz) {
        return new ReflectUtils(clazz);
    }

    public static ReflectUtils reflect(Object object) {
        return new ReflectUtils(object == null ? Object.class : object.getClass(), object);
    }

    private static Class<?> forName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectException(classNotFoundException);
        }
    }

    private static Class<?> forName(String string, ClassLoader classLoader) {
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectException(classNotFoundException);
        }
    }

    public ReflectUtils newInstance() {
        return this.newInstance(new Object[0]);
    }

    public ReflectUtils newInstance(Object ... objectArray) {
        Class<?>[] classArray = this.getArgsType(objectArray);
        try {
            Constructor<?> constructor = this.type().getDeclaredConstructor(classArray);
            return this.newInstance(constructor, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ArrayList arrayList = new ArrayList();
            for (Constructor<?> constructor : this.type().getDeclaredConstructors()) {
                if (!this.match(constructor.getParameterTypes(), classArray)) continue;
                arrayList.add(constructor);
            }
            if (arrayList.isEmpty()) {
                throw new ReflectException(noSuchMethodException);
            }
            this.sortConstructors(arrayList);
            return this.newInstance((Constructor)arrayList.get(0), objectArray);
        }
    }

    private Class<?>[] getArgsType(Object ... objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            classArray[i] = object == null ? NULL.class : object.getClass();
        }
        return classArray;
    }

    private void sortConstructors(List<Constructor<?>> list) {
        Collections.sort(list, new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> constructor, Constructor<?> constructor2) {
                Class<?>[] classArray = constructor.getParameterTypes();
                Class<?>[] classArray2 = constructor2.getParameterTypes();
                int n = classArray.length;
                for (int i = 0; i < n; ++i) {
                    if (classArray[i].equals(classArray2[i])) continue;
                    if (ReflectUtils.this.wrapper(classArray[i]).isAssignableFrom(ReflectUtils.this.wrapper(classArray2[i]))) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    private ReflectUtils newInstance(Constructor<?> constructor, Object ... objectArray) {
        try {
            return new ReflectUtils(constructor.getDeclaringClass(), this.accessible(constructor).newInstance(objectArray));
        }
        catch (Exception exception) {
            throw new ReflectException(exception);
        }
    }

    public ReflectUtils field(String string) {
        try {
            Field field = this.getField(string);
            return new ReflectUtils(field.getType(), field.get(this.object));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectException(illegalAccessException);
        }
    }

    public ReflectUtils field(String string, Object object) {
        try {
            Field field = this.getField(string);
            field.set(this.object, this.unwrap(object));
            return this;
        }
        catch (Exception exception) {
            throw new ReflectException(exception);
        }
    }

    private Field getField(String string) {
        Field field = this.getAccessibleField(string);
        if ((field.getModifiers() & 0x10) == 16) {
            try {
                Field field2 = Field.class.getDeclaredField("modifiers");
                field2.setAccessible(true);
                field2.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return field;
    }

    private Field getAccessibleField(String string) {
        Class<?> clazz = this.type();
        try {
            return this.accessible(clazz.getField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            while (true) {
                try {
                    return this.accessible(clazz.getDeclaredField(string));
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw new ReflectException(noSuchFieldException);
                }
                break;
            }
        }
    }

    private Object unwrap(Object object) {
        if (object instanceof ReflectUtils) {
            return ((ReflectUtils)object).get();
        }
        return object;
    }

    public ReflectUtils method(String string) {
        return this.method(string, new Object[0]);
    }

    public ReflectUtils method(String string, Object ... objectArray) {
        Class<?>[] classArray = this.getArgsType(objectArray);
        try {
            Method method = this.exactMethod(string, classArray);
            return this.method(method, this.object, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method method = this.similarMethod(string, classArray);
                return this.method(method, this.object, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new ReflectException(noSuchMethodException2);
            }
        }
    }

    private ReflectUtils method(Method method, Object object, Object ... objectArray) {
        try {
            this.accessible(method);
            if (method.getReturnType() == Void.TYPE) {
                method.invoke(object, objectArray);
                return ReflectUtils.reflect(object);
            }
            return ReflectUtils.reflect(method.invoke(object, objectArray));
        }
        catch (Exception exception) {
            throw new ReflectException(exception);
        }
    }

    private Method exactMethod(String string, Class<?>[] classArray) {
        Class<?> clazz = this.type();
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            while (true) {
                try {
                    return clazz.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw new NoSuchMethodException();
                }
                break;
            }
        }
    }

    private Method similarMethod(String string, Class<?>[] classArray) {
        Class<?> clazz = this.type();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!this.isSimilarSignature(method, string, classArray)) continue;
            arrayList.add(method);
        }
        if (!arrayList.isEmpty()) {
            this.sortMethods(arrayList);
            return (Method)arrayList.get(0);
        }
        do {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!this.isSimilarSignature(method, string, classArray)) continue;
                arrayList.add(method);
            }
            if (arrayList.isEmpty()) continue;
            this.sortMethods(arrayList);
            return (Method)arrayList.get(0);
        } while ((clazz = clazz.getSuperclass()) != null);
        throw new NoSuchMethodException("No similar method " + string + " with params " + Arrays.toString(classArray) + " could be found on type " + this.type() + ".");
    }

    private void sortMethods(List<Method> list) {
        Collections.sort(list, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                Class<?>[] classArray = method.getParameterTypes();
                Class<?>[] classArray2 = method2.getParameterTypes();
                int n = classArray.length;
                for (int i = 0; i < n; ++i) {
                    if (classArray[i].equals(classArray2[i])) continue;
                    if (ReflectUtils.this.wrapper(classArray[i]).isAssignableFrom(ReflectUtils.this.wrapper(classArray2[i]))) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    private boolean isSimilarSignature(Method method, String string, Class<?>[] classArray) {
        return method.getName().equals(string) && this.match(method.getParameterTypes(), classArray);
    }

    private boolean match(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray.length == classArray2.length) {
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i] == NULL.class || this.wrapper(classArray[i]).isAssignableFrom(this.wrapper(classArray2[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private <T extends AccessibleObject> T accessible(T t) {
        Member member;
        if (t == null) {
            return null;
        }
        if (t instanceof Member && Modifier.isPublic((member = (Member)((Object)t)).getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
            return t;
        }
        if (!t.isAccessible()) {
            t.setAccessible(true);
        }
        return t;
    }

    public <P> P proxy(Class<P> clazz) {
        final boolean bl = this.object instanceof Map;
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) {
                String string = method.getName();
                try {
                    return ReflectUtils.reflect(ReflectUtils.this.object).method(string, objectArray).get();
                }
                catch (ReflectException reflectException) {
                    if (bl) {
                        int n;
                        Map map = (Map)ReflectUtils.this.object;
                        int n2 = n = objectArray == null ? 0 : objectArray.length;
                        if (n == 0 && string.startsWith("get")) {
                            return map.get(ReflectUtils.property(string.substring(3)));
                        }
                        if (n == 0 && string.startsWith("is")) {
                            return map.get(ReflectUtils.property(string.substring(2)));
                        }
                        if (n == 1 && string.startsWith("set")) {
                            map.put(ReflectUtils.property(string.substring(3)), objectArray[0]);
                            return null;
                        }
                    }
                    throw reflectException;
                }
            }
        };
        return (P)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
    }

    private static String property(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private Class<?> type() {
        return this.type;
    }

    private Class<?> wrapper(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE == clazz) {
                return Boolean.class;
            }
            if (Integer.TYPE == clazz) {
                return Integer.class;
            }
            if (Long.TYPE == clazz) {
                return Long.class;
            }
            if (Short.TYPE == clazz) {
                return Short.class;
            }
            if (Byte.TYPE == clazz) {
                return Byte.class;
            }
            if (Double.TYPE == clazz) {
                return Double.class;
            }
            if (Float.TYPE == clazz) {
                return Float.class;
            }
            if (Character.TYPE == clazz) {
                return Character.class;
            }
            if (Void.TYPE == clazz) {
                return Void.class;
            }
        }
        return clazz;
    }

    public <T> T get() {
        return (T)this.object;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ReflectUtils && this.object.equals(((ReflectUtils)object).get());
    }

    public String toString() {
        return this.object.toString();
    }

    public static class ReflectException
    extends RuntimeException {
        private static final long serialVersionUID = 858774075258496016L;

        public ReflectException(String string) {
            super(string);
        }

        public ReflectException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ReflectException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class NULL {
        private NULL() {
        }
    }
}

