/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresPermission;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import com.blankj.utilcode.util.IntentUtils;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.Utils;
import java.util.ArrayList;

public final class PhoneUtils {
    private PhoneUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isPhone() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return telephonyManager != null && telephonyManager.getPhoneType() != 0;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getDeviceId() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getDeviceId() : "";
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMEI() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 26) {
            return telephonyManager != null ? telephonyManager.getImei() : "";
        }
        return telephonyManager != null ? telephonyManager.getDeviceId() : "";
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getMEID() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 26) {
            return telephonyManager != null ? telephonyManager.getMeid() : "";
        }
        return telephonyManager != null ? telephonyManager.getDeviceId() : "";
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMSI() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getSubscriberId() : "";
    }

    public static int getPhoneType() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getPhoneType() : -1;
    }

    public static boolean isSimCardReady() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return telephonyManager != null && telephonyManager.getSimState() == 5;
    }

    public static String getSimOperatorName() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getSimOperatorName() : "";
    }

    public static String getSimOperatorByMnc() {
        String string;
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        String string2 = string = telephonyManager != null ? telephonyManager.getSimOperator() : null;
        if (string == null) {
            return null;
        }
        switch (string) {
            case "46000": 
            case "46002": 
            case "46007": {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            case "46001": {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            case "46003": {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return string;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getPhoneStatus() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        String string = "";
        string = string + "DeviceId(IMEI) = " + telephonyManager.getDeviceId() + "\n";
        string = string + "DeviceSoftwareVersion = " + telephonyManager.getDeviceSoftwareVersion() + "\n";
        string = string + "Line1Number = " + telephonyManager.getLine1Number() + "\n";
        string = string + "NetworkCountryIso = " + telephonyManager.getNetworkCountryIso() + "\n";
        string = string + "NetworkOperator = " + telephonyManager.getNetworkOperator() + "\n";
        string = string + "NetworkOperatorName = " + telephonyManager.getNetworkOperatorName() + "\n";
        string = string + "NetworkType = " + telephonyManager.getNetworkType() + "\n";
        string = string + "PhoneType = " + telephonyManager.getPhoneType() + "\n";
        string = string + "SimCountryIso = " + telephonyManager.getSimCountryIso() + "\n";
        string = string + "SimOperator = " + telephonyManager.getSimOperator() + "\n";
        string = string + "SimOperatorName = " + telephonyManager.getSimOperatorName() + "\n";
        string = string + "SimSerialNumber = " + telephonyManager.getSimSerialNumber() + "\n";
        string = string + "SimState = " + telephonyManager.getSimState() + "\n";
        string = string + "SubscriberId(IMSI) = " + telephonyManager.getSubscriberId() + "\n";
        string = string + "VoiceMailNumber = " + telephonyManager.getVoiceMailNumber() + "\n";
        return string;
    }

    public static void dial(String string) {
        Utils.getApp().startActivity(IntentUtils.getDialIntent(string, true));
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static void call(String string) {
        Utils.getApp().startActivity(IntentUtils.getCallIntent(string, true));
    }

    public static void sendSms(String string, String string2) {
        Utils.getApp().startActivity(IntentUtils.getSendSmsIntent(string, string2, true));
    }

    @RequiresPermission(value="android.permission.SEND_SMS")
    public static void sendSmsSilent(String string, String string2) {
        if (StringUtils.isEmpty(string2)) {
            return;
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)Utils.getApp(), (int)0, (Intent)new Intent("send"), (int)0);
        SmsManager smsManager = SmsManager.getDefault();
        if (string2.length() >= 70) {
            ArrayList arrayList = smsManager.divideMessage(string2);
            for (String string3 : arrayList) {
                smsManager.sendTextMessage(string, null, string3, pendingIntent, null);
            }
        } else {
            smsManager.sendTextMessage(string, null, string2, pendingIntent, null);
        }
    }
}

