/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.MotionEvent;
import com.blankj.utilcode.constant.PermissionConstants;
import com.blankj.utilcode.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class PermissionUtils {
    private static final List<String> PERMISSIONS = PermissionUtils.getPermissions();
    private static PermissionUtils sInstance;
    private OnRationaleListener mOnRationaleListener;
    private SimpleCallback mSimpleCallback;
    private FullCallback mFullCallback;
    private ThemeCallback mThemeCallback;
    private Set<String> mPermissions = new LinkedHashSet<String>();
    private List<String> mPermissionsRequest;
    private List<String> mPermissionsGranted;
    private List<String> mPermissionsDenied;
    private List<String> mPermissionsDeniedForever;

    public static List<String> getPermissions() {
        return PermissionUtils.getPermissions(Utils.getApp().getPackageName());
    }

    public static List<String> getPermissions(String string) {
        PackageManager packageManager = Utils.getApp().getPackageManager();
        try {
            return Arrays.asList(packageManager.getPackageInfo((String)string, (int)4096).requestedPermissions);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static boolean isGranted(String ... stringArray) {
        for (String string : stringArray) {
            if (PermissionUtils.isGranted(string)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGranted(String string) {
        return Build.VERSION.SDK_INT < 23 || 0 == ContextCompat.checkSelfPermission((Context)Utils.getApp(), (String)string);
    }

    public static void launchAppDetailsSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    public static PermissionUtils permission(String ... stringArray) {
        return new PermissionUtils(stringArray);
    }

    private PermissionUtils(String ... stringArray) {
        for (String string : stringArray) {
            for (String string2 : PermissionConstants.getPermissions(string)) {
                if (!PERMISSIONS.contains(string2)) continue;
                this.mPermissions.add(string2);
            }
        }
        sInstance = this;
    }

    public PermissionUtils rationale(OnRationaleListener onRationaleListener) {
        this.mOnRationaleListener = onRationaleListener;
        return this;
    }

    public PermissionUtils callback(SimpleCallback simpleCallback) {
        this.mSimpleCallback = simpleCallback;
        return this;
    }

    public PermissionUtils callback(FullCallback fullCallback) {
        this.mFullCallback = fullCallback;
        return this;
    }

    public PermissionUtils theme(ThemeCallback themeCallback) {
        this.mThemeCallback = themeCallback;
        return this;
    }

    public void request() {
        this.mPermissionsGranted = new ArrayList<String>();
        this.mPermissionsRequest = new ArrayList<String>();
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionsGranted.addAll(this.mPermissions);
            this.requestCallback();
        } else {
            for (String string : this.mPermissions) {
                if (PermissionUtils.isGranted(string)) {
                    this.mPermissionsGranted.add(string);
                    continue;
                }
                this.mPermissionsRequest.add(string);
            }
            if (this.mPermissionsRequest.isEmpty()) {
                this.requestCallback();
            } else {
                this.startPermissionActivity();
            }
        }
    }

    @RequiresApi(api=23)
    private void startPermissionActivity() {
        this.mPermissionsDenied = new ArrayList<String>();
        this.mPermissionsDeniedForever = new ArrayList<String>();
        PermissionActivity.start((Context)Utils.getApp());
    }

    @RequiresApi(api=23)
    private boolean rationale(Activity activity) {
        boolean bl = false;
        if (this.mOnRationaleListener != null) {
            for (String string : this.mPermissionsRequest) {
                if (!activity.shouldShowRequestPermissionRationale(string)) continue;
                this.getPermissionsStatus(activity);
                this.mOnRationaleListener.rationale(new OnRationaleListener.ShouldRequest(){

                    @Override
                    public void again(boolean bl) {
                        if (bl) {
                            PermissionUtils.this.startPermissionActivity();
                        } else {
                            PermissionUtils.this.requestCallback();
                        }
                    }
                });
                bl = true;
                break;
            }
            this.mOnRationaleListener = null;
        }
        return bl;
    }

    private void getPermissionsStatus(Activity activity) {
        for (String string : this.mPermissionsRequest) {
            if (PermissionUtils.isGranted(string)) {
                this.mPermissionsGranted.add(string);
                continue;
            }
            this.mPermissionsDenied.add(string);
            if (activity.shouldShowRequestPermissionRationale(string)) continue;
            this.mPermissionsDeniedForever.add(string);
        }
    }

    private void requestCallback() {
        if (this.mSimpleCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mSimpleCallback.onGranted();
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mSimpleCallback.onDenied();
            }
            this.mSimpleCallback = null;
        }
        if (this.mFullCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mFullCallback.onGranted(this.mPermissionsGranted);
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mFullCallback.onDenied(this.mPermissionsDeniedForever, this.mPermissionsDenied);
            }
            this.mFullCallback = null;
        }
        this.mOnRationaleListener = null;
        this.mThemeCallback = null;
    }

    private void onRequestPermissionsResult(Activity activity) {
        this.getPermissionsStatus(activity);
        this.requestCallback();
    }

    public static interface ThemeCallback {
        public void onActivityCreate(Activity var1);
    }

    public static interface FullCallback {
        public void onGranted(List<String> var1);

        public void onDenied(List<String> var1, List<String> var2);
    }

    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    public static interface OnRationaleListener {
        public void rationale(ShouldRequest var1);

        public static interface ShouldRequest {
            public void again(boolean var1);
        }
    }

    @RequiresApi(api=23)
    public static class PermissionActivity
    extends Activity {
        public static void start(Context context) {
            Intent intent = new Intent(context, PermissionActivity.class);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }

        protected void onCreate(@Nullable Bundle bundle) {
            this.getWindow().addFlags(262160);
            if (sInstance == null) {
                super.onCreate(bundle);
                Log.e((String)"PermissionUtils", (String)"request permissions failed");
                this.finish();
                return;
            }
            if (sInstance.mThemeCallback != null) {
                sInstance.mThemeCallback.onActivityCreate(this);
            }
            super.onCreate(bundle);
            if (sInstance.rationale(this)) {
                this.finish();
                return;
            }
            if (sInstance.mPermissionsRequest != null) {
                int n = sInstance.mPermissionsRequest.size();
                if (n <= 0) {
                    this.finish();
                    return;
                }
                this.requestPermissions(sInstance.mPermissionsRequest.toArray(new String[n]), 1);
            }
        }

        public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
            if (stringArray == null) {
                throw new NullPointerException("Argument 'permissions' of type String[] (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            if (nArray == null) {
                throw new NullPointerException("Argument 'grantResults' of type int[] (#2 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
            }
            sInstance.onRequestPermissionsResult(this);
            this.finish();
        }

        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            this.finish();
            return true;
        }
    }
}

