/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.util.SimpleArrayMap;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public final class ObjectUtils {
    private ObjectUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray() && Array.getLength(object) == 0) {
            return true;
        }
        if (object instanceof CharSequence && object.toString().length() == 0) {
            return true;
        }
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return true;
        }
        if (object instanceof Map && ((Map)object).isEmpty()) {
            return true;
        }
        if (object instanceof SimpleArrayMap && ((SimpleArrayMap)object).isEmpty()) {
            return true;
        }
        if (object instanceof SparseArray && ((SparseArray)object).size() == 0) {
            return true;
        }
        if (object instanceof SparseBooleanArray && ((SparseBooleanArray)object).size() == 0) {
            return true;
        }
        if (object instanceof SparseIntArray && ((SparseIntArray)object).size() == 0) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 18 && object instanceof SparseLongArray && ((SparseLongArray)object).size() == 0) {
            return true;
        }
        if (object instanceof android.support.v4.util.LongSparseArray && ((android.support.v4.util.LongSparseArray)object).size() == 0) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 16 && object instanceof LongSparseArray && ((LongSparseArray)object).size() == 0;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.toString().length() == 0;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(SimpleArrayMap simpleArrayMap) {
        return simpleArrayMap == null || simpleArrayMap.isEmpty();
    }

    public static boolean isEmpty(SparseArray sparseArray) {
        return sparseArray == null || sparseArray.size() == 0;
    }

    public static boolean isEmpty(SparseBooleanArray sparseBooleanArray) {
        return sparseBooleanArray == null || sparseBooleanArray.size() == 0;
    }

    public static boolean isEmpty(SparseIntArray sparseIntArray) {
        return sparseIntArray == null || sparseIntArray.size() == 0;
    }

    public static boolean isEmpty(android.support.v4.util.LongSparseArray longSparseArray) {
        return longSparseArray == null || longSparseArray.size() == 0;
    }

    @RequiresApi(api=18)
    public static boolean isEmpty(SparseLongArray sparseLongArray) {
        return sparseLongArray == null || sparseLongArray.size() == 0;
    }

    @RequiresApi(api=16)
    public static boolean isEmpty(LongSparseArray longSparseArray) {
        return longSparseArray == null || longSparseArray.size() == 0;
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectUtils.isEmpty(object);
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !ObjectUtils.isEmpty(charSequence);
    }

    public static boolean isNotEmpty(Collection collection) {
        return !ObjectUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map map) {
        return !ObjectUtils.isEmpty(map);
    }

    public static boolean isNotEmpty(SimpleArrayMap simpleArrayMap) {
        return !ObjectUtils.isEmpty(simpleArrayMap);
    }

    public static boolean isNotEmpty(SparseArray sparseArray) {
        return !ObjectUtils.isEmpty(sparseArray);
    }

    public static boolean isNotEmpty(SparseBooleanArray sparseBooleanArray) {
        return !ObjectUtils.isEmpty(sparseBooleanArray);
    }

    public static boolean isNotEmpty(SparseIntArray sparseIntArray) {
        return !ObjectUtils.isEmpty(sparseIntArray);
    }

    public static boolean isNotEmpty(android.support.v4.util.LongSparseArray longSparseArray) {
        return !ObjectUtils.isEmpty(longSparseArray);
    }

    @RequiresApi(api=18)
    public static boolean isNotEmpty(SparseLongArray sparseLongArray) {
        return !ObjectUtils.isEmpty(sparseLongArray);
    }

    @RequiresApi(api=16)
    public static boolean isNotEmpty(LongSparseArray longSparseArray) {
        return !ObjectUtils.isEmpty(longSparseArray);
    }

    public static boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static <T> T requireNonNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException(string);
        }
        return t;
    }

    public static <T> T getOrDefault(T t, T t2) {
        if (t == null) {
            return t2;
        }
        return t;
    }

    public static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }
}

