/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.support.annotation.RequiresPermission;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.blankj.utilcode.util.ShellUtils;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class NetworkUtils {
    private static final int NETWORK_TYPE_GSM = 16;
    private static final int NETWORK_TYPE_TD_SCDMA = 17;
    private static final int NETWORK_TYPE_IWLAN = 18;

    private NetworkUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void openWirelessSettings() {
        Utils.getApp().startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnected() {
        NetworkInfo networkInfo = NetworkUtils.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByPing() {
        return NetworkUtils.isAvailableByPing(null);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByPing(String string) {
        boolean bl;
        if (string == null || string.length() <= 0) {
            string = "223.5.5.5";
        }
        ShellUtils.CommandResult commandResult = ShellUtils.execCmd(String.format("ping -c 1 %s", string), false);
        boolean bl2 = bl = commandResult.result == 0;
        if (commandResult.errorMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + commandResult.errorMsg));
        }
        if (commandResult.successMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + commandResult.successMsg));
        }
        return bl;
    }

    public static boolean getMobileDataEnabled() {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
            if (telephonyManager == null) {
                return false;
            }
            Method method = telephonyManager.getClass().getDeclaredMethod("getDataEnabled", new Class[0]);
            if (null != method) {
                return (Boolean)method.invoke((Object)telephonyManager, new Object[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public static void setMobileDataEnabled(boolean bl) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
            if (telephonyManager == null) {
                return;
            }
            Method method = telephonyManager.getClass().getDeclaredMethod("setDataEnabled", Boolean.TYPE);
            if (null != method) {
                method.invoke((Object)telephonyManager, bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isMobileData() {
        NetworkInfo networkInfo = NetworkUtils.getActiveNetworkInfo();
        return null != networkInfo && networkInfo.isAvailable() && networkInfo.getType() == 0;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean is4G() {
        NetworkInfo networkInfo = NetworkUtils.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable() && networkInfo.getSubtype() == 13;
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static boolean getWifiEnabled() {
        WifiManager wifiManager = (WifiManager)Utils.getApp().getSystemService("wifi");
        return wifiManager != null && wifiManager.isWifiEnabled();
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public static void setWifiEnabled(boolean bl) {
        WifiManager wifiManager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wifiManager == null) {
            return;
        }
        if (bl) {
            if (!wifiManager.isWifiEnabled()) {
                wifiManager.setWifiEnabled(true);
            }
        } else if (wifiManager.isWifiEnabled()) {
            wifiManager.setWifiEnabled(false);
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isWifiConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        return connectivityManager != null && connectivityManager.getActiveNetworkInfo() != null && connectivityManager.getActiveNetworkInfo().getType() == 1;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static boolean isWifiAvailable() {
        return NetworkUtils.getWifiEnabled() && NetworkUtils.isAvailableByPing();
    }

    public static String getNetworkOperatorName() {
        TelephonyManager telephonyManager = (TelephonyManager)Utils.getApp().getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getNetworkOperatorName() : "";
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static NetworkType getNetworkType() {
        NetworkType networkType = NetworkType.NETWORK_NO;
        NetworkInfo networkInfo = NetworkUtils.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            if (networkInfo.getType() == 1) {
                networkType = NetworkType.NETWORK_WIFI;
            } else if (networkInfo.getType() == 0) {
                switch (networkInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        networkType = NetworkType.NETWORK_2G;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        networkType = NetworkType.NETWORK_3G;
                        break;
                    }
                    case 13: 
                    case 18: {
                        networkType = NetworkType.NETWORK_4G;
                        break;
                    }
                    default: {
                        String string = networkInfo.getSubtypeName();
                        if (string.equalsIgnoreCase("TD-SCDMA") || string.equalsIgnoreCase("WCDMA") || string.equalsIgnoreCase("CDMA2000")) {
                            networkType = NetworkType.NETWORK_3G;
                            break;
                        }
                        networkType = NetworkType.NETWORK_UNKNOWN;
                        break;
                    }
                }
            } else {
                networkType = NetworkType.NETWORK_UNKNOWN;
            }
        }
        return networkType;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager connectivityManager = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (connectivityManager == null) {
            return null;
        }
        return connectivityManager.getActiveNetworkInfo();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getIPAddress(boolean bl) {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    boolean bl2;
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    String string = inetAddress.getHostAddress();
                    boolean bl3 = bl2 = string.indexOf(58) < 0;
                    if (bl) {
                        if (!bl2) continue;
                        return string;
                    }
                    if (bl2) continue;
                    int n = string.indexOf(37);
                    return n < 0 ? string.toUpperCase() : string.substring(0, n).toUpperCase();
                }
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        return "";
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getDomainAddress(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return "";
        }
    }

    public static enum NetworkType {
        NETWORK_WIFI,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO;

    }
}

