/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.IntRange;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class LogUtils {
    public static final int V = 2;
    public static final int D = 3;
    public static final int I = 4;
    public static final int W = 5;
    public static final int E = 6;
    public static final int A = 7;
    private static final char[] T = new char[]{'V', 'D', 'I', 'W', 'E', 'A'};
    private static final int FILE = 16;
    private static final int JSON = 32;
    private static final int XML = 48;
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String TOP_CORNER = "\u250c";
    private static final String MIDDLE_CORNER = "\u251c";
    private static final String LEFT_BORDER = "\u2502 ";
    private static final String BOTTOM_CORNER = "\u2514";
    private static final String SIDE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_DIVIDER = "\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String TOP_BORDER = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_BORDER = "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String BOTTOM_BORDER = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final int MAX_LEN = 3000;
    @SuppressLint(value={"SimpleDateFormat"})
    private static final Format FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS ");
    private static final String NOTHING = "log nothing";
    private static final String NULL = "null";
    private static final String ARGS = "args";
    private static final String PLACEHOLDER = " ";
    private static final Config CONFIG = new Config();
    private static ExecutorService sExecutor;

    private LogUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Config getConfig() {
        return CONFIG;
    }

    public static void v(Object ... objectArray) {
        LogUtils.log(2, CONFIG.mGlobalTag, objectArray);
    }

    public static void vTag(String string, Object ... objectArray) {
        LogUtils.log(2, string, objectArray);
    }

    public static void d(Object ... objectArray) {
        LogUtils.log(3, CONFIG.mGlobalTag, objectArray);
    }

    public static void dTag(String string, Object ... objectArray) {
        LogUtils.log(3, string, objectArray);
    }

    public static void i(Object ... objectArray) {
        LogUtils.log(4, CONFIG.mGlobalTag, objectArray);
    }

    public static void iTag(String string, Object ... objectArray) {
        LogUtils.log(4, string, objectArray);
    }

    public static void w(Object ... objectArray) {
        LogUtils.log(5, CONFIG.mGlobalTag, objectArray);
    }

    public static void wTag(String string, Object ... objectArray) {
        LogUtils.log(5, string, objectArray);
    }

    public static void e(Object ... objectArray) {
        LogUtils.log(6, CONFIG.mGlobalTag, objectArray);
    }

    public static void eTag(String string, Object ... objectArray) {
        LogUtils.log(6, string, objectArray);
    }

    public static void a(Object ... objectArray) {
        LogUtils.log(7, CONFIG.mGlobalTag, objectArray);
    }

    public static void aTag(String string, Object ... objectArray) {
        LogUtils.log(7, string, objectArray);
    }

    public static void file(Object object) {
        LogUtils.log(19, CONFIG.mGlobalTag, object);
    }

    public static void file(int n, Object object) {
        LogUtils.log(0x10 | n, CONFIG.mGlobalTag, object);
    }

    public static void file(String string, Object object) {
        LogUtils.log(19, string, object);
    }

    public static void file(int n, String string, Object object) {
        LogUtils.log(0x10 | n, string, object);
    }

    public static void json(String string) {
        LogUtils.log(35, CONFIG.mGlobalTag, string);
    }

    public static void json(int n, String string) {
        LogUtils.log(0x20 | n, CONFIG.mGlobalTag, string);
    }

    public static void json(String string, String string2) {
        LogUtils.log(35, string, string2);
    }

    public static void json(int n, String string, String string2) {
        LogUtils.log(0x20 | n, string, string2);
    }

    public static void xml(String string) {
        LogUtils.log(51, CONFIG.mGlobalTag, string);
    }

    public static void xml(int n, String string) {
        LogUtils.log(0x30 | n, CONFIG.mGlobalTag, string);
    }

    public static void xml(String string, String string2) {
        LogUtils.log(51, string, string2);
    }

    public static void xml(int n, String string, String string2) {
        LogUtils.log(0x30 | n, string, string2);
    }

    public static void log(int n, String string, Object ... objectArray) {
        if (!CONFIG.mLogSwitch || !CONFIG.mLog2ConsoleSwitch && !CONFIG.mLog2FileSwitch) {
            return;
        }
        int n2 = n & 0xF;
        int n3 = n & 0xF0;
        if (n2 < CONFIG.mConsoleFilter && n2 < CONFIG.mFileFilter) {
            return;
        }
        TagHead tagHead = LogUtils.processTagAndHead(string);
        String string2 = LogUtils.processBody(n3, objectArray);
        if (CONFIG.mLog2ConsoleSwitch && n2 >= CONFIG.mConsoleFilter && n3 != 16) {
            LogUtils.print2Console(n2, tagHead.tag, tagHead.consoleHead, string2);
        }
        if ((CONFIG.mLog2FileSwitch || n3 == 16) && n2 >= CONFIG.mFileFilter) {
            LogUtils.print2File(n2, tagHead.tag, tagHead.fileHead + string2);
        }
    }

    private static TagHead processTagAndHead(String string) {
        if (!CONFIG.mTagIsSpace && !CONFIG.mLogHeadSwitch) {
            string = CONFIG.mGlobalTag;
        } else {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            int n = 3 + CONFIG.mStackOffset;
            if (n >= stackTraceElementArray.length) {
                StackTraceElement stackTraceElement = stackTraceElementArray[3];
                String string2 = LogUtils.getFileName(stackTraceElement);
                if (CONFIG.mTagIsSpace && LogUtils.isSpace(string)) {
                    int n2 = string2.indexOf(46);
                    string = n2 == -1 ? string2 : string2.substring(0, n2);
                }
                return new TagHead(string, null, ": ");
            }
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string3 = LogUtils.getFileName(stackTraceElement);
            if (CONFIG.mTagIsSpace && LogUtils.isSpace(string)) {
                int n3 = string3.indexOf(46);
                String string4 = string = n3 == -1 ? string3 : string3.substring(0, n3);
            }
            if (CONFIG.mLogHeadSwitch) {
                String string5 = Thread.currentThread().getName();
                String string6 = new Formatter().format("%s, %s.%s(%s:%d)", string5, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), string3, stackTraceElement.getLineNumber()).toString();
                String string7 = " [" + string6 + "]: ";
                if (CONFIG.mStackDeep <= 1) {
                    return new TagHead(string, new String[]{string6}, string7);
                }
                String[] stringArray = new String[Math.min(CONFIG.mStackDeep, stackTraceElementArray.length - n)];
                stringArray[0] = string6;
                int n4 = string5.length() + 2;
                String string8 = new Formatter().format("%" + n4 + "s", "").toString();
                int n5 = stringArray.length;
                for (int i = 1; i < n5; ++i) {
                    stackTraceElement = stackTraceElementArray[i + n];
                    stringArray[i] = new Formatter().format("%s%s.%s(%s:%d)", string8, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), LogUtils.getFileName(stackTraceElement), stackTraceElement.getLineNumber()).toString();
                }
                return new TagHead(string, stringArray, string7);
            }
        }
        return new TagHead(string, null, ": ");
    }

    private static String getFileName(StackTraceElement stackTraceElement) {
        int n;
        String string = stackTraceElement.getFileName();
        if (string != null) {
            return string;
        }
        String string2 = stackTraceElement.getClassName();
        String[] stringArray = string2.split("\\.");
        if (stringArray.length > 0) {
            string2 = stringArray[stringArray.length - 1];
        }
        if ((n = string2.indexOf(36)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2 + ".java";
    }

    private static String processBody(int n, Object ... objectArray) {
        String string = NULL;
        if (objectArray != null) {
            if (objectArray.length == 1) {
                Object object = objectArray[0];
                if (object != null) {
                    string = object.toString();
                }
                if (n == 32) {
                    string = LogUtils.formatJson(string);
                } else if (n == 48) {
                    string = LogUtils.formatXml(string);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    Object object = objectArray[i];
                    stringBuilder.append(ARGS).append("[").append(i).append("]").append(" = ").append(object == null ? NULL : object.toString()).append(LINE_SEP);
                }
                string = stringBuilder.toString();
            }
        }
        return string.length() == 0 ? NOTHING : string;
    }

    private static String formatJson(String string) {
        try {
            if (string.startsWith("{")) {
                string = new JSONObject(string).toString(4);
            } else if (string.startsWith("[")) {
                string = new JSONArray(string).toString(4);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return string;
    }

    private static String formatXml(String string) {
        try {
            StreamSource streamSource = new StreamSource(new StringReader(string));
            StreamResult streamResult = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(streamSource, streamResult);
            string = streamResult.getWriter().toString().replaceFirst(">", ">" + LINE_SEP);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private static void print2Console(int n, String string, String[] stringArray, String string2) {
        if (CONFIG.mSingleTagSwitch) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(PLACEHOLDER).append(LINE_SEP);
            if (CONFIG.mLogBorderSwitch) {
                stringBuilder.append(TOP_BORDER).append(LINE_SEP);
                if (stringArray != null) {
                    for (String string3 : stringArray) {
                        stringBuilder.append(LEFT_BORDER).append(string3).append(LINE_SEP);
                    }
                    stringBuilder.append(MIDDLE_BORDER).append(LINE_SEP);
                }
                for (String string3 : string2.split(LINE_SEP)) {
                    stringBuilder.append(LEFT_BORDER).append(string3).append(LINE_SEP);
                }
                stringBuilder.append(BOTTOM_BORDER);
            } else {
                if (stringArray != null) {
                    for (String string4 : stringArray) {
                        stringBuilder.append(string4).append(LINE_SEP);
                    }
                }
                stringBuilder.append(string2);
            }
            LogUtils.printMsgSingleTag(n, string, stringBuilder.toString());
        } else {
            LogUtils.printBorder(n, string, true);
            LogUtils.printHead(n, string, stringArray);
            LogUtils.printMsg(n, string, string2);
            LogUtils.printBorder(n, string, false);
        }
    }

    private static void printBorder(int n, String string, boolean bl) {
        if (CONFIG.mLogBorderSwitch) {
            Log.println((int)n, (String)string, (String)(bl ? TOP_BORDER : BOTTOM_BORDER));
        }
    }

    private static void printHead(int n, String string, String[] stringArray) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                Log.println((int)n, (String)string, (String)(CONFIG.mLogBorderSwitch ? LEFT_BORDER + string2 : string2));
            }
            if (CONFIG.mLogBorderSwitch) {
                Log.println((int)n, (String)string, (String)MIDDLE_BORDER);
            }
        }
    }

    private static void printMsg(int n, String string, String string2) {
        int n2 = string2.length();
        int n3 = n2 / 3000;
        if (n3 > 0) {
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                LogUtils.printSubMsg(n, string, string2.substring(n4, n4 + 3000));
                n4 += 3000;
            }
            if (n4 != n2) {
                LogUtils.printSubMsg(n, string, string2.substring(n4, n2));
            }
        } else {
            LogUtils.printSubMsg(n, string, string2);
        }
    }

    private static void printMsgSingleTag(int n, String string, String string2) {
        int n2 = string2.length();
        int n3 = n2 / 3000;
        if (n3 > 0) {
            if (CONFIG.mLogBorderSwitch) {
                Log.println((int)n, (String)string, (String)(string2.substring(0, 3000) + LINE_SEP + BOTTOM_BORDER));
                int n4 = 3000;
                for (int i = 1; i < n3; ++i) {
                    Log.println((int)n, (String)string, (String)(PLACEHOLDER + LINE_SEP + TOP_BORDER + LINE_SEP + LEFT_BORDER + string2.substring(n4, n4 + 3000) + LINE_SEP + BOTTOM_BORDER));
                    n4 += 3000;
                }
                if (n4 != n2) {
                    Log.println((int)n, (String)string, (String)(PLACEHOLDER + LINE_SEP + TOP_BORDER + LINE_SEP + LEFT_BORDER + string2.substring(n4, n2)));
                }
            } else {
                int n5 = 0;
                for (int i = 0; i < n3; ++i) {
                    Log.println((int)n, (String)string, (String)string2.substring(n5, n5 + 3000));
                    n5 += 3000;
                }
                if (n5 != n2) {
                    Log.println((int)n, (String)string, (String)string2.substring(n5, n2));
                }
            }
        } else {
            Log.println((int)n, (String)string, (String)string2);
        }
    }

    private static void printSubMsg(int n, String string, String string2) {
        String[] stringArray;
        if (!CONFIG.mLogBorderSwitch) {
            Log.println((int)n, (String)string, (String)string2);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray = string2.split(LINE_SEP)) {
            Log.println((int)n, (String)string, (String)(LEFT_BORDER + string3));
        }
    }

    private static void printSubMsg1(int n, String string, String string2) {
        String[] stringArray;
        if (!CONFIG.mLogBorderSwitch) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray = string2.split(LINE_SEP)) {
            Log.println((int)n, (String)string, (String)(LEFT_BORDER + string3));
        }
    }

    private static void print2File(int n, String string, String string2) {
        Date date = new Date(System.currentTimeMillis());
        String string3 = FORMAT.format(date);
        String string4 = string3.substring(0, 5);
        String string5 = string3.substring(6);
        String string6 = (CONFIG.mDir == null ? CONFIG.mDefaultDir : CONFIG.mDir) + CONFIG.mFilePrefix + "-" + string4 + ".txt";
        if (!LogUtils.createOrExistsFile(string6)) {
            Log.e((String)"LogUtils", (String)("create " + string6 + " failed!"));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string5).append(T[n - 2]).append("/").append(string).append(string2).append(LINE_SEP);
        String string7 = stringBuilder.toString();
        LogUtils.input2File(string7, string6);
    }

    private static boolean createOrExistsFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.isFile();
        }
        if (!LogUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            boolean bl = file.createNewFile();
            if (bl) {
                LogUtils.printDeviceInfo(string);
            }
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static void printDeviceInfo(String string) {
        Object object;
        String string2 = "";
        int n = 0;
        try {
            object = Utils.getApp().getPackageManager().getPackageInfo(Utils.getApp().getPackageName(), 0);
            if (object != null) {
                string2 = object.versionName;
                n = object.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        object = string.substring(string.length() - 9, string.length() - 4);
        String string3 = "************* Log Head ****************\nDate of Log        : " + (String)object + "\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + string2 + "\nApp VersionCode    : " + n + "\n************* Log Head ****************\n\n";
        LogUtils.input2File(string3, string);
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void input2File(final String string, final String string2) {
        if (sExecutor == null) {
            sExecutor = Executors.newSingleThreadExecutor();
        }
        Future<Boolean> future = sExecutor.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(string2, true));
                    bufferedWriter.write(string);
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        try {
            if (future.get().booleanValue()) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        Log.e((String)"LogUtils", (String)("log to " + string2 + " failed!"));
    }

    private static class TagHead {
        String tag;
        String[] consoleHead;
        String fileHead;

        TagHead(String string, String[] stringArray, String string2) {
            this.tag = string;
            this.consoleHead = stringArray;
            this.fileHead = string2;
        }
    }

    public static class Config {
        private String mDefaultDir;
        private String mDir;
        private String mFilePrefix = "util";
        private boolean mLogSwitch = true;
        private boolean mLog2ConsoleSwitch = true;
        private String mGlobalTag = null;
        private boolean mTagIsSpace = true;
        private boolean mLogHeadSwitch = true;
        private boolean mLog2FileSwitch = false;
        private boolean mLogBorderSwitch = true;
        private boolean mSingleTagSwitch = true;
        private int mConsoleFilter = 2;
        private int mFileFilter = 2;
        private int mStackDeep = 1;
        private int mStackOffset = 0;

        private Config() {
            if (this.mDefaultDir != null) {
                return;
            }
            this.mDefaultDir = "mounted".equals(Environment.getExternalStorageState()) && Utils.getApp().getExternalCacheDir() != null ? Utils.getApp().getExternalCacheDir() + FILE_SEP + "log" + FILE_SEP : Utils.getApp().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        }

        public Config setLogSwitch(boolean bl) {
            this.mLogSwitch = bl;
            return this;
        }

        public Config setConsoleSwitch(boolean bl) {
            this.mLog2ConsoleSwitch = bl;
            return this;
        }

        public Config setGlobalTag(String string) {
            if (LogUtils.isSpace(string)) {
                this.mGlobalTag = "";
                this.mTagIsSpace = true;
            } else {
                this.mGlobalTag = string;
                this.mTagIsSpace = false;
            }
            return this;
        }

        public Config setLogHeadSwitch(boolean bl) {
            this.mLogHeadSwitch = bl;
            return this;
        }

        public Config setLog2FileSwitch(boolean bl) {
            this.mLog2FileSwitch = bl;
            return this;
        }

        public Config setDir(String string) {
            this.mDir = LogUtils.isSpace(string) ? null : (string.endsWith(FILE_SEP) ? string : string + FILE_SEP);
            return this;
        }

        public Config setDir(File file) {
            this.mDir = file == null ? null : file.getAbsolutePath() + FILE_SEP;
            return this;
        }

        public Config setFilePrefix(String string) {
            this.mFilePrefix = LogUtils.isSpace(string) ? "util" : string;
            return this;
        }

        public Config setBorderSwitch(boolean bl) {
            this.mLogBorderSwitch = bl;
            return this;
        }

        public Config setSingleTagSwitch(boolean bl) {
            this.mSingleTagSwitch = bl;
            return this;
        }

        public Config setConsoleFilter(int n) {
            this.mConsoleFilter = n;
            return this;
        }

        public Config setFileFilter(int n) {
            this.mFileFilter = n;
            return this;
        }

        public Config setStackDeep(@IntRange(from=1L) int n) {
            this.mStackDeep = n;
            return this;
        }

        public Config setStackOffset(@IntRange(from=0L) int n) {
            this.mStackOffset = n;
            return this;
        }

        public String toString() {
            return "switch: " + this.mLogSwitch + LINE_SEP + "console: " + this.mLog2ConsoleSwitch + LINE_SEP + "tag: " + (this.mTagIsSpace ? LogUtils.NULL : this.mGlobalTag) + LINE_SEP + "head: " + this.mLogHeadSwitch + LINE_SEP + "file: " + this.mLog2FileSwitch + LINE_SEP + "dir: " + (this.mDir == null ? this.mDefaultDir : this.mDir) + LINE_SEP + "filePrefix: " + this.mFilePrefix + LINE_SEP + "border: " + this.mLogBorderSwitch + LINE_SEP + "singleTag: " + this.mSingleTagSwitch + LINE_SEP + "consoleFilter: " + T[this.mConsoleFilter - 2] + LINE_SEP + "fileFilter: " + T[this.mFileFilter - 2] + LINE_SEP + "stackDeep: " + this.mStackDeep + LINE_SEP + "mStackOffset: " + this.mStackOffset;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TYPE {
    }
}

