/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Field;

public final class KeyboardUtils {
    private static int sContentViewInvisibleHeightPre;
    private static ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
    private static OnSoftInputChangedListener onSoftInputChangedListener;

    private KeyboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void showSoftInput(Activity activity) {
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager == null) {
            return;
        }
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
            view.setFocusable(true);
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
        inputMethodManager.showSoftInput(view, 2);
    }

    public static void showSoftInput(View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (inputMethodManager == null) {
            return;
        }
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        inputMethodManager.showSoftInput(view, 2);
    }

    public static void hideSoftInput(Activity activity) {
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager == null) {
            return;
        }
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInput(View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (inputMethodManager == null) {
            return;
        }
        inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void toggleSoftInput() {
        InputMethodManager inputMethodManager = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (inputMethodManager == null) {
            return;
        }
        inputMethodManager.toggleSoftInput(2, 0);
    }

    public static boolean isSoftInputVisible(Activity activity) {
        return KeyboardUtils.isSoftInputVisible(activity, 200);
    }

    public static boolean isSoftInputVisible(Activity activity, int n) {
        return KeyboardUtils.getContentViewInvisibleHeight(activity) >= n;
    }

    private static int getContentViewInvisibleHeight(Activity activity) {
        View view = activity.findViewById(0x1020002);
        Rect rect = new Rect();
        view.getWindowVisibleDisplayFrame(rect);
        LogUtils.d(view.getTop(), view.getBottom(), rect.top, rect.bottom);
        return view.getBottom() - rect.bottom;
    }

    public static void registerSoftInputChangedListener(final Activity activity, OnSoftInputChangedListener onSoftInputChangedListener) {
        int n = activity.getWindow().getAttributes().flags;
        if ((n & 0x200) != 0) {
            activity.getWindow().clearFlags(512);
        }
        View view = activity.findViewById(0x1020002);
        sContentViewInvisibleHeightPre = KeyboardUtils.getContentViewInvisibleHeight(activity);
        KeyboardUtils.onSoftInputChangedListener = onSoftInputChangedListener;
        onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (onSoftInputChangedListener != null) {
                    int n = KeyboardUtils.getContentViewInvisibleHeight(activity);
                    if (sContentViewInvisibleHeightPre != n) {
                        onSoftInputChangedListener.onSoftInputChanged(n);
                        sContentViewInvisibleHeightPre = n;
                    }
                }
            }
        };
        view.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }

    @TargetApi(value=16)
    public static void unregisterSoftInputChangedListener(Activity activity) {
        View view = activity.findViewById(0x1020002);
        view.getViewTreeObserver().removeOnGlobalLayoutListener(onGlobalLayoutListener);
        onSoftInputChangedListener = null;
        onGlobalLayoutListener = null;
    }

    public static void fixSoftInputLeaks(Context context) {
        if (context == null) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (inputMethodManager == null) {
            return;
        }
        String[] stringArray = new String[]{"mCurRootView", "mServedView", "mNextServedView"};
        for (int i = 0; i < 3; ++i) {
            try {
                Object object;
                Field field = inputMethodManager.getClass().getDeclaredField(stringArray[i]);
                if (field == null) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((object = field.get(inputMethodManager)) == null || !(object instanceof View)) continue;
                View view = (View)object;
                if (view.getContext() == context) {
                    field.set(inputMethodManager, null);
                    continue;
                }
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void clickBlankArea2HideSoftInput() {
        Log.i((String)"KeyboardUtils", (String)"Please refer to the following code.");
    }

    public static interface OnSoftInputChangedListener {
        public void onSoftInputChanged(int var1);
    }
}

