/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import android.support.v4.content.FileProvider;
import com.blankj.utilcode.util.Utils;
import java.io.File;

public final class IntentUtils {
    private IntentUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Intent getInstallAppIntent(String string) {
        return IntentUtils.getInstallAppIntent(IntentUtils.getFileByPath(string), false);
    }

    public static Intent getInstallAppIntent(File file) {
        return IntentUtils.getInstallAppIntent(file, false);
    }

    public static Intent getInstallAppIntent(String string, boolean bl) {
        return IntentUtils.getInstallAppIntent(IntentUtils.getFileByPath(string), bl);
    }

    public static Intent getInstallAppIntent(File file, boolean bl) {
        Uri uri;
        if (file == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String string = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT < 24) {
            uri = Uri.fromFile((File)file);
        } else {
            intent.setFlags(1);
            String string2 = Utils.getApp().getPackageName() + ".utilcode.provider";
            uri = FileProvider.getUriForFile((Context)Utils.getApp(), (String)string2, (File)file);
        }
        intent.setDataAndType(uri, string);
        return IntentUtils.getIntent(intent, bl);
    }

    @Deprecated
    public static Intent getInstallAppIntent(String string, String string2) {
        return IntentUtils.getInstallAppIntent(IntentUtils.getFileByPath(string), string2, false);
    }

    @Deprecated
    public static Intent getInstallAppIntent(File file, String string) {
        return IntentUtils.getInstallAppIntent(file, string, false);
    }

    @Deprecated
    public static Intent getInstallAppIntent(String string, String string2, boolean bl) {
        return IntentUtils.getInstallAppIntent(IntentUtils.getFileByPath(string), string2, bl);
    }

    @Deprecated
    public static Intent getInstallAppIntent(File file, String string, boolean bl) {
        Uri uri;
        if (file == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String string2 = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT < 24) {
            uri = Uri.fromFile((File)file);
        } else {
            intent.setFlags(1);
            uri = FileProvider.getUriForFile((Context)Utils.getApp(), (String)string, (File)file);
        }
        intent.setDataAndType(uri, string2);
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getUninstallAppIntent(String string) {
        return IntentUtils.getUninstallAppIntent(string, false);
    }

    public static Intent getUninstallAppIntent(String string, boolean bl) {
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + string)));
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getLaunchAppIntent(String string) {
        return IntentUtils.getLaunchAppIntent(string, false);
    }

    public static Intent getLaunchAppIntent(String string, boolean bl) {
        Intent intent = Utils.getApp().getPackageManager().getLaunchIntentForPackage(string);
        if (intent == null) {
            return null;
        }
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getLaunchAppDetailsSettingsIntent(String string) {
        return IntentUtils.getLaunchAppDetailsSettingsIntent(string, false);
    }

    public static Intent getLaunchAppDetailsSettingsIntent(String string, boolean bl) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + string)));
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getShareTextIntent(String string) {
        return IntentUtils.getShareTextIntent(string, false);
    }

    public static Intent getShareTextIntent(String string, boolean bl) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", string);
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getShareImageIntent(String string, String string2) {
        return IntentUtils.getShareImageIntent(string, string2, false);
    }

    public static Intent getShareImageIntent(String string, String string2, boolean bl) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return IntentUtils.getShareImageIntent(string, new File(string2), bl);
    }

    public static Intent getShareImageIntent(String string, File file) {
        return IntentUtils.getShareImageIntent(string, file, false);
    }

    public static Intent getShareImageIntent(String string, File file, boolean bl) {
        if (file != null && file.isFile()) {
            return null;
        }
        return IntentUtils.getShareImageIntent(string, Uri.fromFile((File)file), bl);
    }

    public static Intent getShareImageIntent(String string, Uri uri) {
        return IntentUtils.getShareImageIntent(string, uri, false);
    }

    public static Intent getShareImageIntent(String string, Uri uri, boolean bl) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", string);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        intent.setType("image/*");
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getComponentIntent(String string, String string2) {
        return IntentUtils.getComponentIntent(string, string2, null, false);
    }

    public static Intent getComponentIntent(String string, String string2, boolean bl) {
        return IntentUtils.getComponentIntent(string, string2, null, bl);
    }

    public static Intent getComponentIntent(String string, String string2, Bundle bundle) {
        return IntentUtils.getComponentIntent(string, string2, bundle, false);
    }

    public static Intent getComponentIntent(String string, String string2, Bundle bundle, boolean bl) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        ComponentName componentName = new ComponentName(string, string2);
        intent.setComponent(componentName);
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getShutdownIntent() {
        return IntentUtils.getShutdownIntent(false);
    }

    public static Intent getShutdownIntent(boolean bl) {
        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getDialIntent(String string) {
        return IntentUtils.getDialIntent(string, false);
    }

    public static Intent getDialIntent(String string, boolean bl) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + string)));
        return IntentUtils.getIntent(intent, bl);
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static Intent getCallIntent(String string) {
        return IntentUtils.getCallIntent(string, false);
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static Intent getCallIntent(String string, boolean bl) {
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + string)));
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getSendSmsIntent(String string, String string2) {
        return IntentUtils.getSendSmsIntent(string, string2, false);
    }

    public static Intent getSendSmsIntent(String string, String string2, boolean bl) {
        Uri uri = Uri.parse((String)("smsto:" + string));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", string2);
        return IntentUtils.getIntent(intent, bl);
    }

    public static Intent getCaptureIntent(Uri uri) {
        return IntentUtils.getCaptureIntent(uri, false);
    }

    public static Intent getCaptureIntent(Uri uri, boolean bl) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)uri);
        intent.addFlags(1);
        return IntentUtils.getIntent(intent, bl);
    }

    private static Intent getIntent(Intent intent, boolean bl) {
        return bl ? intent.addFlags(0x10000000) : intent;
    }

    private static File getFileByPath(String string) {
        return IntentUtils.isSpace(string) ? null : new File(string);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

