/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.view.View;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FragmentUtils {
    private static final int TYPE_ADD_FRAGMENT = 1;
    private static final int TYPE_SHOW_FRAGMENT = 2;
    private static final int TYPE_HIDE_FRAGMENT = 4;
    private static final int TYPE_SHOW_HIDE_FRAGMENT = 8;
    private static final int TYPE_REPLACE_FRAGMENT = 16;
    private static final int TYPE_REMOVE_FRAGMENT = 32;
    private static final int TYPE_REMOVE_TO_FRAGMENT = 64;
    private static final String ARGS_ID = "args_id";
    private static final String ARGS_IS_HIDE = "args_is_hide";
    private static final String ARGS_IS_ADD_STACK = "args_is_add_stack";
    private static final String ARGS_TAG = "args_tag";

    private FragmentUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, false, false);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, bl, false);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl, boolean bl2) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, bl, bl2);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, @AnimRes int n2, @AnimRes int n3) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, false, n2, n3, 0, 0);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl, @AnimRes int n2, @AnimRes int n3) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, bl, n2, n3, 0, 0);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4, @AnimRes int n5) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, false, n2, n3, n4, n5);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4, @AnimRes int n5) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, bl, n2, n3, n4, n5);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, View ... viewArray) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (viewArray == null) {
            throw new NullPointerException("Argument 'sharedElements' of type View[] (#3 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, false, viewArray);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl, View ... viewArray) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (viewArray == null) {
            throw new NullPointerException("Argument 'sharedElements' of type View[] (#4 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, null, bl, viewArray);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull List<Fragment> list, @IdRes int n, int n2) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (list == null) {
            throw new NullPointerException("Argument 'adds' of type List<Fragment> (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, list.toArray(new Fragment[list.size()]), n, null, n2);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment[] fragmentArray, @IdRes int n, int n2) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragmentArray == null) {
            throw new NullPointerException("Argument 'adds' of type Fragment[] (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragmentArray, n, null, n2);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, string, false, false);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, string, bl, false);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl, boolean bl2) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.putArgs(fragment, new Args(n, string, bl, bl2));
        FragmentUtils.operateNoAnim(fragmentManager, 1, null, fragment);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, @AnimRes int n2, @AnimRes int n3) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, string, false, n2, n3, 0, 0);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl, @AnimRes int n2, @AnimRes int n3) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, string, bl, n2, n3, 0, 0);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4, @AnimRes int n5) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, string, false, n2, n3, n4, n5);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4, @AnimRes int n5) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 9, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 9, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        FragmentUtils.putArgs(fragment, new Args(n, string, false, bl));
        FragmentUtils.addAnim(fragmentTransaction, n2, n3, n4, n5);
        FragmentUtils.operate(1, fragmentManager, fragmentTransaction, null, fragment);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, View ... viewArray) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (viewArray == null) {
            throw new NullPointerException("Argument 'sharedElements' of type View[] (#4 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, fragment, n, string, false, viewArray);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl, View ... viewArray) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (viewArray == null) {
            throw new NullPointerException("Argument 'sharedElements' of type View[] (#5 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        FragmentUtils.putArgs(fragment, new Args(n, string, false, bl));
        FragmentUtils.addSharedElement(fragmentTransaction, viewArray);
        FragmentUtils.operate(1, fragmentManager, fragmentTransaction, null, fragment);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull List<Fragment> list, @IdRes int n, String[] stringArray, int n2) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (list == null) {
            throw new NullPointerException("Argument 'adds' of type List<Fragment> (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fragmentManager, list.toArray(new Fragment[list.size()]), n, stringArray, n2);
    }

    public static void add(@NonNull FragmentManager fragmentManager, @NonNull Fragment[] fragmentArray, @IdRes int n, String[] stringArray, int n2) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragmentArray == null) {
            throw new NullPointerException("Argument 'adds' of type Fragment[] (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (stringArray == null) {
            int n3 = fragmentArray.length;
            for (int i = 0; i < n3; ++i) {
                FragmentUtils.putArgs(fragmentArray[i], new Args(n, null, n2 != i, false));
            }
        } else {
            int n4 = fragmentArray.length;
            for (int i = 0; i < n4; ++i) {
                FragmentUtils.putArgs(fragmentArray[i], new Args(n, stringArray[i], n2 != i, false));
            }
        }
        FragmentUtils.operateNoAnim(fragmentManager, 1, null, fragmentArray);
    }

    public static void show(@NonNull Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'show' of type Fragment (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.putArgs(fragment, false);
        FragmentUtils.operateNoAnim(fragment.getFragmentManager(), 2, null, fragment);
    }

    public static void show(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list = FragmentUtils.getFragments(fragmentManager);
        for (Fragment fragment : list) {
            FragmentUtils.putArgs(fragment, false);
        }
        FragmentUtils.operateNoAnim(fragmentManager, 2, null, list.toArray(new Fragment[list.size()]));
    }

    public static void hide(@NonNull Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'hide' of type Fragment (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.putArgs(fragment, true);
        FragmentUtils.operateNoAnim(fragment.getFragmentManager(), 4, null, fragment);
    }

    public static void hide(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list = FragmentUtils.getFragments(fragmentManager);
        for (Fragment fragment : list) {
            FragmentUtils.putArgs(fragment, true);
        }
        FragmentUtils.operateNoAnim(fragmentManager, 4, null, list.toArray(new Fragment[list.size()]));
    }

    public static void showHide(int n, @NonNull List<Fragment> list) {
        if (list == null) {
            throw new NullPointerException("Argument 'fragments' of type List<Fragment> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.showHide(list.get(n), list);
    }

    public static void showHide(@NonNull Fragment fragment, @NonNull List<Fragment> list) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'show' of type Fragment (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (list == null) {
            throw new NullPointerException("Argument 'hide' of type List<Fragment> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        for (Fragment fragment2 : list) {
            FragmentUtils.putArgs(fragment2, fragment2 != fragment);
        }
        FragmentUtils.operateNoAnim(fragment.getFragmentManager(), 8, fragment, list.toArray(new Fragment[list.size()]));
    }

    public static void showHide(int n, Fragment ... fragmentArray) {
        if (fragmentArray == null) {
            throw new NullPointerException("Argument 'fragments' of type Fragment[] (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.showHide(fragmentArray[n], fragmentArray);
    }

    public static void showHide(@NonNull Fragment fragment, Fragment ... fragmentArray) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'show' of type Fragment (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragmentArray == null) {
            throw new NullPointerException("Argument 'hide' of type Fragment[] (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        for (Fragment fragment2 : fragmentArray) {
            FragmentUtils.putArgs(fragment2, fragment2 != fragment);
        }
        FragmentUtils.operateNoAnim(fragment.getFragmentManager(), 8, fragment, fragmentArray);
    }

    public static void showHide(@NonNull Fragment fragment, @NonNull Fragment fragment2) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'show' of type Fragment (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'hide' of type Fragment (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.putArgs(fragment, false);
        FragmentUtils.putArgs(fragment2, true);
        FragmentUtils.operateNoAnim(fragment.getFragmentManager(), 8, fragment, fragment2);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, null, false);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, boolean bl) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, null, bl);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, @AnimRes int n, @AnimRes int n2) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, null, false, n, n2, 0, 0);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, boolean bl, @AnimRes int n, @AnimRes int n2) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, null, bl, n, n2, 0, 0);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, @AnimRes int n, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, null, false, n, n2, n3, n4);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, boolean bl, @AnimRes int n, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, null, bl, n, n2, n3, n4);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, View ... viewArray) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, null, false, viewArray);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, boolean bl, View ... viewArray) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, null, bl, viewArray);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, null, false);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, null, bl);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, @AnimRes int n2, @AnimRes int n3) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, null, false, n2, n3, 0, 0);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl, @AnimRes int n2, @AnimRes int n3) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, null, bl, n2, n3, 0, 0);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4, @AnimRes int n5) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, null, false, n2, n3, n4, n5);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4, @AnimRes int n5) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, null, bl, n2, n3, n4, n5);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, View ... viewArray) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, null, false, viewArray);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, boolean bl, View ... viewArray) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, null, bl, viewArray);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, String string) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, string, false);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, String string, boolean bl) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Args args = FragmentUtils.getArgs(fragment);
        FragmentUtils.replace(fragment.getFragmentManager(), fragment2, args.id, string, bl);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, String string, @AnimRes int n, @AnimRes int n2) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, string, false, n, n2, 0, 0);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, String string, boolean bl, @AnimRes int n, @AnimRes int n2) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, string, bl, n, n2, 0, 0);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, String string, @AnimRes int n, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, string, false, n, n2, n3, n4);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, String string, boolean bl, @AnimRes int n, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Args args = FragmentUtils.getArgs(fragment);
        FragmentUtils.replace(fragment.getFragmentManager(), fragment2, args.id, string, bl, n, n2, n3, n4);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, String string, View ... viewArray) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragment, fragment2, string, false, viewArray);
    }

    public static void replace(@NonNull Fragment fragment, @NonNull Fragment fragment2, String string, boolean bl, View ... viewArray) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment2 == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Args args = FragmentUtils.getArgs(fragment);
        FragmentUtils.replace(fragment.getFragmentManager(), fragment2, args.id, string, bl, viewArray);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, string, false);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        FragmentUtils.putArgs(fragment, new Args(n, string, false, bl));
        FragmentUtils.operate(16, fragmentManager, fragmentTransaction, null, fragment);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, @AnimRes int n2, @AnimRes int n3) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, string, false, n2, n3, 0, 0);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl, @AnimRes int n2, @AnimRes int n3) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, string, bl, n2, n3, 0, 0);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4, @AnimRes int n5) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 8, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, string, false, n2, n3, n4, n5);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl, @AnimRes int n2, @AnimRes int n3, @AnimRes int n4, @AnimRes int n5) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 9, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 9, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        FragmentUtils.putArgs(fragment, new Args(n, string, false, bl));
        FragmentUtils.addAnim(fragmentTransaction, n2, n3, n4, n5);
        FragmentUtils.operate(16, fragmentManager, fragmentTransaction, null, fragment);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, View ... viewArray) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fragmentManager, fragment, n, string, false, viewArray);
    }

    public static void replace(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment, @IdRes int n, String string, boolean bl, View ... viewArray) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        FragmentUtils.putArgs(fragment, new Args(n, string, false, bl));
        FragmentUtils.addSharedElement(fragmentTransaction, viewArray);
        FragmentUtils.operate(16, fragmentManager, fragmentTransaction, null, fragment);
    }

    public static void pop(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.pop(fragmentManager, true);
    }

    public static void pop(@NonNull FragmentManager fragmentManager, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl) {
            fragmentManager.popBackStackImmediate();
        } else {
            fragmentManager.popBackStack();
        }
    }

    public static void popTo(@NonNull FragmentManager fragmentManager, Class<? extends Fragment> clazz, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.popTo(fragmentManager, clazz, bl, true);
    }

    public static void popTo(@NonNull FragmentManager fragmentManager, Class<? extends Fragment> clazz, boolean bl, boolean bl2) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bl2) {
            fragmentManager.popBackStackImmediate(clazz.getName(), bl ? 1 : 0);
        } else {
            fragmentManager.popBackStack(clazz.getName(), bl ? 1 : 0);
        }
    }

    public static void popAll(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.popAll(fragmentManager, true);
    }

    public static void popAll(@NonNull FragmentManager fragmentManager, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        while (fragmentManager.getBackStackEntryCount() > 0) {
            if (bl) {
                fragmentManager.popBackStackImmediate();
                continue;
            }
            fragmentManager.popBackStack();
        }
    }

    public static void remove(@NonNull Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'remove' of type Fragment (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.operateNoAnim(fragment.getFragmentManager(), 32, null, fragment);
    }

    public static void removeTo(@NonNull Fragment fragment, boolean bl) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'removeTo' of type Fragment (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        FragmentUtils.operateNoAnim(fragment.getFragmentManager(), 64, (Fragment)(bl ? fragment : null), fragment);
    }

    public static void removeAll(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list = FragmentUtils.getFragments(fragmentManager);
        FragmentUtils.operateNoAnim(fragmentManager, 32, null, list.toArray(new Fragment[list.size()]));
    }

    private static void putArgs(Fragment fragment, Args args) {
        Bundle bundle = fragment.getArguments();
        if (bundle == null) {
            bundle = new Bundle();
            fragment.setArguments(bundle);
        }
        bundle.putInt(ARGS_ID, args.id);
        bundle.putBoolean(ARGS_IS_HIDE, args.isHide);
        bundle.putBoolean(ARGS_IS_ADD_STACK, args.isAddStack);
        bundle.putString(ARGS_TAG, args.tag);
    }

    private static void putArgs(Fragment fragment, boolean bl) {
        Bundle bundle = fragment.getArguments();
        if (bundle == null) {
            bundle = new Bundle();
            fragment.setArguments(bundle);
        }
        bundle.putBoolean(ARGS_IS_HIDE, bl);
    }

    private static Args getArgs(Fragment fragment) {
        Bundle bundle = fragment.getArguments();
        return new Args(bundle.getInt(ARGS_ID, fragment.getId()), bundle.getBoolean(ARGS_IS_HIDE), bundle.getBoolean(ARGS_IS_ADD_STACK));
    }

    private static void operateNoAnim(FragmentManager fragmentManager, int n, Fragment fragment, Fragment ... fragmentArray) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        FragmentUtils.operate(n, fragmentManager, fragmentTransaction, fragment, fragmentArray);
    }

    private static void operate(int n, FragmentManager fragmentManager, FragmentTransaction fragmentTransaction, Fragment fragment, Fragment ... fragmentArray) {
        if (fragment != null && fragment.isRemoving()) {
            Log.e((String)"FragmentUtils", (String)(fragment.getClass().getName() + " is isRemoving"));
            return;
        }
        block0 : switch (n) {
            case 1: {
                for (Fragment fragment2 : fragmentArray) {
                    Bundle bundle = fragment2.getArguments();
                    if (bundle == null) {
                        return;
                    }
                    String string = bundle.getString(ARGS_TAG, fragment2.getClass().getName());
                    Fragment fragment3 = fragmentManager.findFragmentByTag(string);
                    while (fragment3 != null && fragment3.isAdded()) {
                        fragmentTransaction.remove(fragment3);
                        fragment3 = fragmentManager.findFragmentByTag(string);
                    }
                    fragmentTransaction.add(bundle.getInt(ARGS_ID), fragment2, string);
                    if (bundle.getBoolean(ARGS_IS_HIDE)) {
                        fragmentTransaction.hide(fragment2);
                    }
                    if (!bundle.getBoolean(ARGS_IS_ADD_STACK)) continue;
                    fragmentTransaction.addToBackStack(string);
                }
                break;
            }
            case 4: {
                for (Fragment fragment4 : fragmentArray) {
                    fragmentTransaction.hide(fragment4);
                }
                break;
            }
            case 2: {
                for (Fragment fragment5 : fragmentArray) {
                    fragmentTransaction.show(fragment5);
                }
                break;
            }
            case 8: {
                fragmentTransaction.show(fragment);
                for (Fragment fragment6 : fragmentArray) {
                    if (fragment6 == fragment) continue;
                    fragmentTransaction.hide(fragment6);
                }
                break;
            }
            case 16: {
                Bundle bundle = fragmentArray[0].getArguments();
                if (bundle == null) {
                    return;
                }
                String string = bundle.getString(ARGS_TAG, fragmentArray[0].getClass().getName());
                fragmentTransaction.replace(bundle.getInt(ARGS_ID), fragmentArray[0], string);
                if (!bundle.getBoolean(ARGS_IS_ADD_STACK)) break;
                fragmentTransaction.addToBackStack(string);
                break;
            }
            case 32: {
                for (Fragment fragment7 : fragmentArray) {
                    if (fragment7 == fragment) continue;
                    fragmentTransaction.remove(fragment7);
                }
                break;
            }
            case 64: {
                for (int i = fragmentArray.length - 1; i >= 0; --i) {
                    Fragment fragment8 = fragmentArray[i];
                    if (fragment8 == fragmentArray[0]) {
                        if (fragment == null) break block0;
                        fragmentTransaction.remove(fragment8);
                        break block0;
                    }
                    fragmentTransaction.remove(fragment8);
                }
                break;
            }
        }
        fragmentTransaction.commitAllowingStateLoss();
    }

    private static void addAnim(FragmentTransaction fragmentTransaction, int n, int n2, int n3, int n4) {
        fragmentTransaction.setCustomAnimations(n, n2, n3, n4);
    }

    private static void addSharedElement(FragmentTransaction fragmentTransaction, View ... viewArray) {
        if (Build.VERSION.SDK_INT >= 21) {
            for (View view : viewArray) {
                fragmentTransaction.addSharedElement(view, view.getTransitionName());
            }
        }
    }

    public static Fragment getTop(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getTopIsInStack(fragmentManager, false);
    }

    public static Fragment getTopInStack(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getTopIsInStack(fragmentManager, true);
    }

    private static Fragment getTopIsInStack(@NonNull FragmentManager fragmentManager, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list = FragmentUtils.getFragments(fragmentManager);
        for (int i = list.size() - 1; i >= 0; --i) {
            Fragment fragment = list.get(i);
            if (fragment == null) continue;
            if (bl) {
                if (!fragment.getArguments().getBoolean(ARGS_IS_ADD_STACK)) continue;
                return fragment;
            }
            return fragment;
        }
        return null;
    }

    public static Fragment getTopShow(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getTopShowIsInStack(fragmentManager, false);
    }

    public static Fragment getTopShowInStack(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getTopShowIsInStack(fragmentManager, true);
    }

    private static Fragment getTopShowIsInStack(@NonNull FragmentManager fragmentManager, boolean bl) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list = FragmentUtils.getFragments(fragmentManager);
        for (int i = list.size() - 1; i >= 0; --i) {
            Fragment fragment = list.get(i);
            if (fragment == null || !fragment.isResumed() || !fragment.isVisible() || !fragment.getUserVisibleHint()) continue;
            if (bl) {
                if (!fragment.getArguments().getBoolean(ARGS_IS_ADD_STACK)) continue;
                return fragment;
            }
            return fragment;
        }
        return null;
    }

    public static List<Fragment> getFragments(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List list = fragmentManager.getFragments();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public static List<Fragment> getFragmentsInStack(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list = FragmentUtils.getFragments(fragmentManager);
        ArrayList<Fragment> arrayList = new ArrayList<Fragment>();
        for (Fragment fragment : list) {
            if (fragment == null || !fragment.getArguments().getBoolean(ARGS_IS_ADD_STACK)) continue;
            arrayList.add(fragment);
        }
        return arrayList;
    }

    public static List<FragmentNode> getAllFragments(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getAllFragments(fragmentManager, new ArrayList<FragmentNode>());
    }

    private static List<FragmentNode> getAllFragments(@NonNull FragmentManager fragmentManager, List<FragmentNode> list) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list2 = FragmentUtils.getFragments(fragmentManager);
        for (int i = list2.size() - 1; i >= 0; --i) {
            Fragment fragment = list2.get(i);
            if (fragment == null) continue;
            list.add(new FragmentNode(fragment, FragmentUtils.getAllFragments(fragment.getChildFragmentManager(), new ArrayList<FragmentNode>())));
        }
        return list;
    }

    public static List<FragmentNode> getAllFragmentsInStack(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getAllFragmentsInStack(fragmentManager, new ArrayList<FragmentNode>());
    }

    private static List<FragmentNode> getAllFragmentsInStack(@NonNull FragmentManager fragmentManager, List<FragmentNode> list) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list2 = FragmentUtils.getFragments(fragmentManager);
        for (int i = list2.size() - 1; i >= 0; --i) {
            Fragment fragment = list2.get(i);
            if (fragment == null || !fragment.getArguments().getBoolean(ARGS_IS_ADD_STACK)) continue;
            list.add(new FragmentNode(fragment, FragmentUtils.getAllFragmentsInStack(fragment.getChildFragmentManager(), new ArrayList<FragmentNode>())));
        }
        return list;
    }

    public static Fragment findFragment(@NonNull FragmentManager fragmentManager, Class<? extends Fragment> clazz) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return fragmentManager.findFragmentByTag(clazz.getName());
    }

    public static Fragment findFragment(@NonNull FragmentManager fragmentManager, @NonNull String string) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'tag' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return fragmentManager.findFragmentByTag(string);
    }

    public static boolean dispatchBackPress(@NonNull Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return fragment.isResumed() && fragment.isVisible() && fragment.getUserVisibleHint() && fragment instanceof OnBackClickListener && ((OnBackClickListener)fragment).onBackClick();
    }

    public static boolean dispatchBackPress(@NonNull FragmentManager fragmentManager) {
        if (fragmentManager == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        List<Fragment> list = FragmentUtils.getFragments(fragmentManager);
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Fragment fragment = list.get(i);
            if (fragment == null || !fragment.isResumed() || !fragment.isVisible() || !fragment.getUserVisibleHint() || !(fragment instanceof OnBackClickListener) || !((OnBackClickListener)fragment).onBackClick()) continue;
            return true;
        }
        return false;
    }

    public static void setBackgroundColor(@NonNull Fragment fragment, @ColorInt int n) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view = fragment.getView();
        if (view != null) {
            view.setBackgroundColor(n);
        }
    }

    public static void setBackgroundResource(@NonNull Fragment fragment, @DrawableRes int n) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view = fragment.getView();
        if (view != null) {
            view.setBackgroundResource(n);
        }
    }

    public static void setBackground(@NonNull Fragment fragment, Drawable drawable) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        View view = fragment.getView();
        if (view == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    public static String getSimpleName(Fragment fragment) {
        return fragment == null ? "null" : fragment.getClass().getSimpleName();
    }

    public static interface OnBackClickListener {
        public boolean onBackClick();
    }

    public static class FragmentNode {
        Fragment fragment;
        List<FragmentNode> next;

        public FragmentNode(Fragment fragment, List<FragmentNode> list) {
            this.fragment = fragment;
            this.next = list;
        }

        public String toString() {
            return this.fragment.getClass().getSimpleName() + "->" + (this.next == null || this.next.isEmpty() ? "no child" : this.next.toString());
        }
    }

    private static class Args {
        int id;
        boolean isHide;
        boolean isAddStack;
        String tag;

        private Args(int n, boolean bl, boolean bl2) {
            this(n, null, bl, bl2);
        }

        private Args(int n, String string, boolean bl, boolean bl2) {
            this.id = n;
            this.tag = string;
            this.isHide = bl;
            this.isAddStack = bl2;
        }
    }
}

