/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import com.blankj.utilcode.util.FileIOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class FileUtils {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private FileUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static File getFileByPath(String string) {
        return FileUtils.isSpace(string) ? null : new File(string);
    }

    public static boolean isFileExists(String string) {
        return FileUtils.isFileExists(FileUtils.getFileByPath(string));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean rename(String string, String string2) {
        return FileUtils.rename(FileUtils.getFileByPath(string), string2);
    }

    public static boolean rename(File file, String string) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (FileUtils.isSpace(string)) {
            return false;
        }
        if (string.equals(file.getName())) {
            return true;
        }
        File file2 = new File(file.getParent() + File.separator + string);
        return !file2.exists() && file.renameTo(file2);
    }

    public static boolean isDir(String string) {
        return FileUtils.isDir(FileUtils.getFileByPath(string));
    }

    public static boolean isDir(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public static boolean isFile(String string) {
        return FileUtils.isFile(FileUtils.getFileByPath(string));
    }

    public static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean createOrExistsDir(String string) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(string));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String string) {
        return FileUtils.createOrExistsFile(FileUtils.getFileByPath(string));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String string) {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFileByPath(string));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean copyDir(String string, String string2) {
        return FileUtils.copyDir(FileUtils.getFileByPath(string), FileUtils.getFileByPath(string2));
    }

    public static boolean copyDir(String string, String string2, OnReplaceListener onReplaceListener) {
        return FileUtils.copyDir(FileUtils.getFileByPath(string), FileUtils.getFileByPath(string2), onReplaceListener);
    }

    public static boolean copyDir(File file, File file2) {
        return FileUtils.copyOrMoveDir(file, file2, false);
    }

    public static boolean copyDir(File file, File file2, OnReplaceListener onReplaceListener) {
        return FileUtils.copyOrMoveDir(file, file2, onReplaceListener, false);
    }

    public static boolean copyFile(String string, String string2) {
        return FileUtils.copyFile(FileUtils.getFileByPath(string), FileUtils.getFileByPath(string2));
    }

    public static boolean copyFile(String string, String string2, OnReplaceListener onReplaceListener) {
        return FileUtils.copyFile(FileUtils.getFileByPath(string), FileUtils.getFileByPath(string2), onReplaceListener);
    }

    public static boolean copyFile(File file, File file2) {
        return FileUtils.copyOrMoveFile(file, file2, false);
    }

    public static boolean copyFile(File file, File file2, OnReplaceListener onReplaceListener) {
        return FileUtils.copyOrMoveFile(file, file2, onReplaceListener, false);
    }

    public static boolean moveDir(String string, String string2) {
        return FileUtils.moveDir(FileUtils.getFileByPath(string), FileUtils.getFileByPath(string2));
    }

    public static boolean moveDir(String string, String string2, OnReplaceListener onReplaceListener) {
        return FileUtils.moveDir(FileUtils.getFileByPath(string), FileUtils.getFileByPath(string2), onReplaceListener);
    }

    public static boolean moveDir(File file, File file2) {
        return FileUtils.copyOrMoveDir(file, file2, true);
    }

    public static boolean moveDir(File file, File file2, OnReplaceListener onReplaceListener) {
        return FileUtils.copyOrMoveDir(file, file2, onReplaceListener, true);
    }

    public static boolean moveFile(String string, String string2) {
        return FileUtils.moveFile(FileUtils.getFileByPath(string), FileUtils.getFileByPath(string2));
    }

    public static boolean moveFile(String string, String string2, OnReplaceListener onReplaceListener) {
        return FileUtils.moveFile(FileUtils.getFileByPath(string), FileUtils.getFileByPath(string2), onReplaceListener);
    }

    public static boolean moveFile(File file, File file2) {
        return FileUtils.copyOrMoveFile(file, file2, true);
    }

    public static boolean moveFile(File file, File file2, OnReplaceListener onReplaceListener) {
        return FileUtils.copyOrMoveFile(file, file2, onReplaceListener, true);
    }

    private static boolean copyOrMoveDir(File file, File file2, boolean bl) {
        return FileUtils.copyOrMoveDir(file, file2, new OnReplaceListener(){

            @Override
            public boolean onReplace() {
                return true;
            }
        }, bl);
    }

    private static boolean copyOrMoveDir(File file, File file2, OnReplaceListener onReplaceListener, boolean bl) {
        File[] fileArray;
        if (file == null || file2 == null) {
            return false;
        }
        String string = file.getPath() + File.separator;
        String string2 = file2.getPath() + File.separator;
        if (string2.contains(string)) {
            return false;
        }
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        if (file2.exists()) {
            if (onReplaceListener == null || onReplaceListener.onReplace()) {
                if (!FileUtils.deleteAllInDir(file2)) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(file2)) {
            return false;
        }
        for (File file3 : fileArray = file.listFiles()) {
            File file4 = new File(string2 + file3.getName());
            if (!(file3.isFile() ? !FileUtils.copyOrMoveFile(file3, file4, onReplaceListener, bl) : file3.isDirectory() && !FileUtils.copyOrMoveDir(file3, file4, onReplaceListener, bl))) continue;
            return false;
        }
        return !bl || FileUtils.deleteDir(file);
    }

    private static boolean copyOrMoveFile(File file, File file2, boolean bl) {
        return FileUtils.copyOrMoveFile(file, file2, new OnReplaceListener(){

            @Override
            public boolean onReplace() {
                return true;
            }
        }, bl);
    }

    private static boolean copyOrMoveFile(File file, File file2, OnReplaceListener onReplaceListener, boolean bl) {
        if (file == null || file2 == null) {
            return false;
        }
        if (file.equals(file2)) {
            return false;
        }
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        if (file2.exists()) {
            if (onReplaceListener == null || onReplaceListener.onReplace()) {
                if (!file2.delete()) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(file2.getParentFile())) {
            return false;
        }
        try {
            return FileIOUtils.writeFileFromIS(file2, (InputStream)new FileInputStream(file), false) && (!bl || FileUtils.deleteFile(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
    }

    public static boolean deleteDir(String string) {
        return FileUtils.deleteDir(FileUtils.getFileByPath(string));
    }

    public static boolean deleteDir(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length != 0) {
            for (File file2 : fileArray) {
                if (!(file2.isFile() ? !file2.delete() : file2.isDirectory() && !FileUtils.deleteDir(file2))) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean deleteFile(String string) {
        return FileUtils.deleteFile(FileUtils.getFileByPath(string));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean deleteAllInDir(String string) {
        return FileUtils.deleteAllInDir(FileUtils.getFileByPath(string));
    }

    public static boolean deleteAllInDir(File file) {
        return FileUtils.deleteFilesInDirWithFilter(file, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }
        });
    }

    public static boolean deleteFilesInDir(String string) {
        return FileUtils.deleteFilesInDir(FileUtils.getFileByPath(string));
    }

    public static boolean deleteFilesInDir(File file) {
        return FileUtils.deleteFilesInDirWithFilter(file, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
    }

    public static boolean deleteFilesInDirWithFilter(String string, FileFilter fileFilter) {
        return FileUtils.deleteFilesInDirWithFilter(FileUtils.getFileByPath(string), fileFilter);
    }

    public static boolean deleteFilesInDirWithFilter(File file, FileFilter fileFilter) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length != 0) {
            for (File file2 : fileArray) {
                if (!fileFilter.accept(file2) || !(file2.isFile() ? !file2.delete() : file2.isDirectory() && !FileUtils.deleteDir(file2))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String string) {
        return FileUtils.listFilesInDir(string, false);
    }

    public static List<File> listFilesInDir(File file) {
        return FileUtils.listFilesInDir(file, false);
    }

    public static List<File> listFilesInDir(String string, boolean bl) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(string), bl);
    }

    public static List<File> listFilesInDir(File file, boolean bl) {
        return FileUtils.listFilesInDirWithFilter(file, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }
        }, bl);
    }

    public static List<File> listFilesInDirWithFilter(String string, FileFilter fileFilter) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(string), fileFilter, false);
    }

    public static List<File> listFilesInDirWithFilter(File file, FileFilter fileFilter) {
        return FileUtils.listFilesInDirWithFilter(file, fileFilter, false);
    }

    public static List<File> listFilesInDirWithFilter(String string, FileFilter fileFilter, boolean bl) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(string), fileFilter, bl);
    }

    public static List<File> listFilesInDirWithFilter(File file, FileFilter fileFilter, boolean bl) {
        if (!FileUtils.isDir(file)) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length != 0) {
            for (File file2 : fileArray) {
                if (fileFilter.accept(file2)) {
                    arrayList.add(file2);
                }
                if (!bl || !file2.isDirectory()) continue;
                arrayList.addAll(FileUtils.listFilesInDirWithFilter(file2, fileFilter, true));
            }
        }
        return arrayList;
    }

    public static long getFileLastModified(String string) {
        return FileUtils.getFileLastModified(FileUtils.getFileByPath(string));
    }

    public static long getFileLastModified(File file) {
        if (file == null) {
            return -1L;
        }
        return file.lastModified();
    }

    public static String getFileCharsetSimple(String string) {
        return FileUtils.getFileCharsetSimple(FileUtils.getFileByPath(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        int n = 0;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            n = (inputStream.read() << 8) + inputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        switch (n) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static int getFileLines(String string) {
        return FileUtils.getFileLines(FileUtils.getFileByPath(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        int n = 1;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[1024];
            if (LINE_SEP.endsWith("\n")) {
                int n2;
                while ((n2 = inputStream.read(byArray, 0, 1024)) != -1) {
                    for (int i = 0; i < n2; ++i) {
                        if (byArray[i] != 10) continue;
                        ++n;
                    }
                }
            } else {
                int n3;
                while ((n3 = inputStream.read(byArray, 0, 1024)) != -1) {
                    for (int i = 0; i < n3; ++i) {
                        if (byArray[i] != 13) continue;
                        ++n;
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return n;
    }

    public static String getDirSize(String string) {
        return FileUtils.getDirSize(FileUtils.getFileByPath(string));
    }

    public static String getDirSize(File file) {
        long l = FileUtils.getDirLength(file);
        return l == -1L ? "" : FileUtils.byte2FitMemorySize(l);
    }

    public static String getFileSize(String string) {
        long l = FileUtils.getFileLength(string);
        return l == -1L ? "" : FileUtils.byte2FitMemorySize(l);
    }

    public static String getFileSize(File file) {
        long l = FileUtils.getFileLength(file);
        return l == -1L ? "" : FileUtils.byte2FitMemorySize(l);
    }

    public static long getDirLength(String string) {
        return FileUtils.getDirLength(FileUtils.getFileByPath(string));
    }

    public static long getDirLength(File file) {
        if (!FileUtils.isDir(file)) {
            return -1L;
        }
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length != 0) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    l += FileUtils.getDirLength(file2);
                    continue;
                }
                l += file2.length();
            }
        }
        return l;
    }

    public static long getFileLength(String string) {
        boolean bl = string.matches("[a-zA-z]+://[^\\s]*");
        if (bl) {
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
                httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    return httpURLConnection.getContentLength();
                }
                return -1L;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return FileUtils.getFileLength(FileUtils.getFileByPath(string));
    }

    public static long getFileLength(File file) {
        if (!FileUtils.isFile(file)) {
            return -1L;
        }
        return file.length();
    }

    public static String getFileMD5ToString(String string) {
        File file = FileUtils.isSpace(string) ? null : new File(string);
        return FileUtils.getFileMD5ToString(file);
    }

    public static String getFileMD5ToString(File file) {
        return FileUtils.bytes2HexString(FileUtils.getFileMD5(file));
    }

    public static byte[] getFileMD5(String string) {
        return FileUtils.getFileMD5(FileUtils.getFileByPath(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileMD5(File file) {
        if (file == null) {
            return null;
        }
        FilterInputStream filterInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            filterInputStream = new DigestInputStream(fileInputStream, messageDigest);
            byte[] byArray = new byte[262144];
            while (filterInputStream.read(byArray) > 0) {
            }
            messageDigest = ((DigestInputStream)filterInputStream).getMessageDigest();
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static String getDirName(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getDirName(file.getAbsolutePath());
    }

    public static String getDirName(String string) {
        if (FileUtils.isSpace(string)) {
            return "";
        }
        int n = string.lastIndexOf(File.separator);
        return n == -1 ? "" : string.substring(0, n + 1);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getFileName(file.getAbsolutePath());
    }

    public static String getFileName(String string) {
        if (FileUtils.isSpace(string)) {
            return "";
        }
        int n = string.lastIndexOf(File.separator);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String string) {
        if (FileUtils.isSpace(string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(File.separator);
        if (n2 == -1) {
            return n == -1 ? string : string.substring(0, n);
        }
        if (n == -1 || n2 > n) {
            return string.substring(n2 + 1);
        }
        return string.substring(n2 + 1, n);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String string) {
        if (FileUtils.isSpace(string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(File.separator);
        if (n == -1 || n2 >= n) {
            return "";
        }
        return string.substring(n + 1);
    }

    private static String bytes2HexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        int n = byArray.length;
        if (n <= 0) {
            return "";
        }
        char[] cArray = new char[n << 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = HEX_DIGITS[byArray[i] >>> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[byArray[i] & 0xF];
        }
        return new String(cArray);
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String byte2FitMemorySize(long l) {
        if (l < 0L) {
            return "shouldn't be less than zero!";
        }
        if (l < 1024L) {
            return String.format("%.3fB", l);
        }
        if (l < 0x100000L) {
            return String.format("%.3fKB", (double)l / 1024.0);
        }
        if (l < 0x40000000L) {
            return String.format("%.3fMB", (double)l / 1048576.0);
        }
        return String.format("%.3fGB", (double)l / 1.073741824E9);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static interface OnReplaceListener {
        public boolean onReplace();
    }
}

