/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class CrashUtils {
    private static String defaultDir;
    private static String dir;
    private static String versionName;
    private static int versionCode;
    private static final String FILE_SEP;
    @SuppressLint(value={"SimpleDateFormat"})
    private static final Format FORMAT;
    private static final Thread.UncaughtExceptionHandler DEFAULT_UNCAUGHT_EXCEPTION_HANDLER;
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER;
    private static OnCrashListener sOnCrashListener;

    private CrashUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init() {
        CrashUtils.init("");
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("Argument 'crashDir' of type File (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        CrashUtils.init(file.getAbsolutePath(), null);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(String string) {
        CrashUtils.init(string, null);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(OnCrashListener onCrashListener) {
        CrashUtils.init("", onCrashListener);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(@NonNull File file, OnCrashListener onCrashListener) {
        if (file == null) {
            throw new NullPointerException("Argument 'crashDir' of type File (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        CrashUtils.init(file.getAbsolutePath(), onCrashListener);
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public static void init(String string, OnCrashListener onCrashListener) {
        dir = CrashUtils.isSpace(string) ? null : (string.endsWith(FILE_SEP) ? string : string + FILE_SEP);
        defaultDir = "mounted".equals(Environment.getExternalStorageState()) && Utils.getApp().getExternalCacheDir() != null ? Utils.getApp().getExternalCacheDir() + FILE_SEP + "crash" + FILE_SEP : Utils.getApp().getCacheDir() + FILE_SEP + "crash" + FILE_SEP;
        sOnCrashListener = onCrashListener;
        Thread.setDefaultUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
    }

    private static void input2File(final String string, final String string2) {
        Future<Boolean> future = Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(string2, true));
                    bufferedWriter.write(string);
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        try {
            if (future.get().booleanValue()) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        Log.e((String)"CrashUtils", (String)("write crash info to " + string2 + " failed!"));
    }

    private static boolean createOrExistsFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.isFile();
        }
        if (!CrashUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        FILE_SEP = System.getProperty("file.separator");
        FORMAT = new SimpleDateFormat("MM-dd HH-mm-ss");
        try {
            PackageInfo packageInfo = Utils.getApp().getPackageManager().getPackageInfo(Utils.getApp().getPackageName(), 0);
            if (packageInfo != null) {
                versionName = packageInfo.versionName;
                versionCode = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        DEFAULT_UNCAUGHT_EXCEPTION_HANDLER = Thread.getDefaultUncaughtExceptionHandler();
        UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                if (throwable == null) {
                    if (DEFAULT_UNCAUGHT_EXCEPTION_HANDLER != null) {
                        DEFAULT_UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(thread, null);
                    } else {
                        Process.killProcess((int)Process.myPid());
                        System.exit(1);
                    }
                    return;
                }
                String string = FORMAT.format(new Date(System.currentTimeMillis()));
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = "************* Log Head ****************\nTime Of Crash      : " + string + "\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + versionName + "\nApp VersionCode    : " + versionCode + "\n************* Log Head ****************\n\n";
                stringBuilder.append(string2);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                    throwable2.printStackTrace(printWriter);
                }
                printWriter.flush();
                stringBuilder.append(stringWriter.toString());
                String string3 = stringBuilder.toString();
                String string4 = (dir == null ? defaultDir : dir) + string + ".txt";
                if (CrashUtils.createOrExistsFile(string4)) {
                    CrashUtils.input2File(string3, string4);
                } else {
                    Log.e((String)"CrashUtils", (String)("create " + string4 + " failed!"));
                }
                if (sOnCrashListener != null) {
                    sOnCrashListener.onCrash(string3, throwable);
                }
                if (DEFAULT_UNCAUGHT_EXCEPTION_HANDLER != null) {
                    DEFAULT_UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(thread, throwable);
                }
            }
        };
    }

    public static interface OnCrashListener {
        public void onCrash(String var1, Throwable var2);
    }
}

