/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import com.blankj.utilcode.constant.CacheConstants;
import com.blankj.utilcode.util.CacheDiskUtils;
import com.blankj.utilcode.util.CacheMemoryUtils;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONObject;

public final class CacheDoubleUtils
implements CacheConstants {
    private static final SimpleArrayMap<String, CacheDoubleUtils> CACHE_MAP = new SimpleArrayMap();
    private CacheMemoryUtils mCacheMemoryUtils;
    private CacheDiskUtils mCacheDiskUtils;

    public static CacheDoubleUtils getInstance() {
        return CacheDoubleUtils.getInstance(CacheMemoryUtils.getInstance(), CacheDiskUtils.getInstance());
    }

    public static CacheDoubleUtils getInstance(@NonNull CacheMemoryUtils cacheMemoryUtils, @NonNull CacheDiskUtils cacheDiskUtils) {
        if (cacheMemoryUtils == null) {
            throw new NullPointerException("Argument 'cacheMemoryUtils' of type CacheMemoryUtils (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (cacheDiskUtils == null) {
            throw new NullPointerException("Argument 'cacheDiskUtils' of type CacheDiskUtils (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        String string = cacheDiskUtils.toString() + "_" + cacheMemoryUtils.toString();
        CacheDoubleUtils cacheDoubleUtils = (CacheDoubleUtils)CACHE_MAP.get((Object)string);
        if (cacheDoubleUtils == null) {
            cacheDoubleUtils = new CacheDoubleUtils(cacheMemoryUtils, cacheDiskUtils);
            CACHE_MAP.put((Object)string, (Object)cacheDoubleUtils);
        }
        return cacheDoubleUtils;
    }

    private CacheDoubleUtils(CacheMemoryUtils cacheMemoryUtils, CacheDiskUtils cacheDiskUtils) {
        this.mCacheMemoryUtils = cacheMemoryUtils;
        this.mCacheDiskUtils = cacheDiskUtils;
    }

    public void put(@NonNull String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, byArray, -1);
    }

    public void put(@NonNull String string, byte[] byArray, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.put(string, byArray, n);
        this.mCacheDiskUtils.put(string, byArray, n);
    }

    public byte[] getBytes(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getBytes(string, null);
    }

    public byte[] getBytes(@NonNull String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        byte[] byArray2 = (byte[])this.mCacheMemoryUtils.get(string);
        if (byArray2 != null) {
            return byArray2;
        }
        return this.mCacheDiskUtils.getBytes(string, byArray);
    }

    public void put(@NonNull String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, string2, -1);
    }

    public void put(@NonNull String string, String string2, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.put(string, string2, n);
        this.mCacheDiskUtils.put(string, string2, n);
    }

    public String getString(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getString(string, null);
    }

    public String getString(@NonNull String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        String string3 = (String)this.mCacheMemoryUtils.get(string);
        if (string3 != null) {
            return string3;
        }
        return this.mCacheDiskUtils.getString(string, string2);
    }

    public void put(@NonNull String string, JSONObject jSONObject) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, jSONObject, -1);
    }

    public void put(@NonNull String string, JSONObject jSONObject, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.put(string, jSONObject, n);
        this.mCacheDiskUtils.put(string, jSONObject, n);
    }

    public JSONObject getJSONObject(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getJSONObject(string, null);
    }

    public JSONObject getJSONObject(@NonNull String string, JSONObject jSONObject) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        JSONObject jSONObject2 = (JSONObject)this.mCacheMemoryUtils.get(string);
        if (jSONObject2 != null) {
            return jSONObject2;
        }
        return this.mCacheDiskUtils.getJSONObject(string, jSONObject);
    }

    public void put(@NonNull String string, JSONArray jSONArray) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, jSONArray, -1);
    }

    public void put(@NonNull String string, JSONArray jSONArray, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.put(string, jSONArray, n);
        this.mCacheDiskUtils.put(string, jSONArray, n);
    }

    public JSONArray getJSONArray(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getJSONArray(string, null);
    }

    public JSONArray getJSONArray(@NonNull String string, JSONArray jSONArray) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        JSONArray jSONArray2 = (JSONArray)this.mCacheMemoryUtils.get(string);
        if (jSONArray2 != null) {
            return jSONArray2;
        }
        return this.mCacheDiskUtils.getJSONArray(string, jSONArray);
    }

    public void put(@NonNull String string, Bitmap bitmap) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, bitmap, -1);
    }

    public void put(@NonNull String string, Bitmap bitmap, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.put(string, bitmap, n);
        this.mCacheDiskUtils.put(string, bitmap, n);
    }

    public Bitmap getBitmap(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getBitmap(string, null);
    }

    public Bitmap getBitmap(@NonNull String string, Bitmap bitmap) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Bitmap bitmap2 = (Bitmap)this.mCacheMemoryUtils.get(string);
        if (bitmap2 != null) {
            return bitmap2;
        }
        return this.mCacheDiskUtils.getBitmap(string, bitmap);
    }

    public void put(@NonNull String string, Drawable drawable) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, drawable, -1);
    }

    public void put(@NonNull String string, Drawable drawable, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.put(string, drawable, n);
        this.mCacheDiskUtils.put(string, drawable, n);
    }

    public Drawable getDrawable(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getDrawable(string, null);
    }

    public Drawable getDrawable(@NonNull String string, Drawable drawable) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Drawable drawable2 = (Drawable)this.mCacheMemoryUtils.get(string);
        if (drawable2 != null) {
            return drawable2;
        }
        return this.mCacheDiskUtils.getDrawable(string, drawable);
    }

    public void put(@NonNull String string, Parcelable parcelable) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, parcelable, -1);
    }

    public void put(@NonNull String string, Parcelable parcelable, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.put(string, parcelable, n);
        this.mCacheDiskUtils.put(string, parcelable, n);
    }

    public <T> T getParcelable(@NonNull String string, @NonNull Parcelable.Creator<T> creator) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (creator == null) {
            throw new NullPointerException("Argument 'creator' of type Parcelable.Creator<T> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getParcelable(string, creator, null);
    }

    public <T> T getParcelable(@NonNull String string, @NonNull Parcelable.Creator<T> creator, T t) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (creator == null) {
            throw new NullPointerException("Argument 'creator' of type Parcelable.Creator<T> (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Object t2 = this.mCacheMemoryUtils.get(string);
        if (t2 != null) {
            return t2;
        }
        return this.mCacheDiskUtils.getParcelable(string, creator, t);
    }

    public void put(@NonNull String string, Serializable serializable) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.put(string, serializable, -1);
    }

    public void put(@NonNull String string, Serializable serializable, int n) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.put(string, serializable, n);
        this.mCacheDiskUtils.put(string, serializable, n);
    }

    public Object getSerializable(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return this.getSerializable(string, null);
    }

    public Object getSerializable(@NonNull String string, Object object) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Object t = this.mCacheMemoryUtils.get(string);
        if (t != null) {
            return t;
        }
        return this.mCacheDiskUtils.getSerializable(string, object);
    }

    public long getCacheDiskSize() {
        return this.mCacheDiskUtils.getCacheSize();
    }

    public int getCacheDiskCount() {
        return this.mCacheDiskUtils.getCacheCount();
    }

    public int getCacheMemoryCount() {
        return this.mCacheMemoryUtils.getCacheCount();
    }

    public void remove(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'key' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        this.mCacheMemoryUtils.remove(string);
        this.mCacheDiskUtils.remove(string);
    }

    public void clear() {
        this.mCacheMemoryUtils.clear();
        this.mCacheDiskUtils.clear();
    }
}

