/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityOptionsCompat;
import android.support.v4.util.Pair;
import android.view.View;
import com.blankj.utilcode.util.Utils;
import java.util.LinkedList;
import java.util.List;

public final class ActivityUtils {
    private ActivityUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isActivityExists(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Intent intent = new Intent();
        intent.setClassName(string, string2);
        return Utils.getApp().getPackageManager().resolveActivity(intent, 0) != null && intent.resolveActivity(Utils.getApp().getPackageManager()) != null && Utils.getApp().getPackageManager().queryIntentActivities(intent, 0).size() != 0;
    }

    public static void startActivity(@NonNull Class<? extends Activity> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clazz.getName(), null);
    }

    public static void startActivity(@NonNull Class<? extends Activity> clazz, Bundle bundle) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clazz.getName(), bundle);
    }

    public static void startActivity(@NonNull Class<? extends Activity> clazz, @AnimRes int n, @AnimRes int n2) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clazz.getName(), ActivityUtils.getOptionsBundle(context, n, n2));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clazz) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clazz.getName(), null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clazz, Bundle bundle) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clazz.getName(), bundle);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clazz, View ... viewArray) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clazz.getName(), ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clazz, @AnimRes int n, @AnimRes int n2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clazz.getName(), ActivityUtils.getOptionsBundle((Context)activity, n, n2));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Class<? extends Activity> clazz) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, bundle, context.getPackageName(), clazz.getName(), null);
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Class<? extends Activity> clazz, @NonNull Bundle bundle2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bundle2 == null) {
            throw new NullPointerException("Argument 'options' of type Bundle (#2 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, bundle, context.getPackageName(), clazz.getName(), bundle2);
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Class<? extends Activity> clazz, @AnimRes int n, @AnimRes int n2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, bundle, context.getPackageName(), clazz.getName(), ActivityUtils.getOptionsBundle(context, n, n2));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull Class<? extends Activity> clazz) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#2 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, bundle, activity.getPackageName(), clazz.getName(), null);
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull Class<? extends Activity> clazz, @NonNull Bundle bundle2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bundle2 == null) {
            throw new NullPointerException("Argument 'options' of type Bundle (#3 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, bundle, activity.getPackageName(), clazz.getName(), bundle2);
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull Class<? extends Activity> clazz, View ... viewArray) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, bundle, activity.getPackageName(), clazz.getName(), ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull Class<? extends Activity> clazz, @AnimRes int n, @AnimRes int n2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, bundle, activity.getPackageName(), clazz.getName(), ActivityUtils.getOptionsBundle((Context)activity, n, n2));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(Utils.getTopActivityOrApp(), null, string, string2, null);
    }

    public static void startActivity(@NonNull String string, @NonNull String string2, Bundle bundle) {
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(Utils.getTopActivityOrApp(), null, string, string2, bundle);
    }

    public static void startActivity(@NonNull String string, @NonNull String string2, @AnimRes int n, @AnimRes int n2) {
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, string, string2, ActivityUtils.getOptionsBundle(context, n, n2));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String string, @NonNull String string2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#2 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, null, string, string2, null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String string, @NonNull String string2, Bundle bundle) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, null, string, string2, bundle);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String string, @NonNull String string2, View ... viewArray) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, null, string, string2, ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String string, @NonNull String string2, @AnimRes int n, @AnimRes int n2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, null, string, string2, ActivityUtils.getOptionsBundle((Context)activity, n, n2));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull String string, @NonNull String string2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#2 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(Utils.getTopActivityOrApp(), bundle, string, string2, null);
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull String string, @NonNull String string2, Bundle bundle2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(Utils.getTopActivityOrApp(), bundle, string, string2, bundle2);
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull String string, @NonNull String string2, @AnimRes int n, @AnimRes int n2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, bundle, string, string2, ActivityUtils.getOptionsBundle(context, n, n2));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull String string, @NonNull String string2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#3 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, bundle, string, string2, null);
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull String string, @NonNull String string2, Bundle bundle2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#3 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, bundle, string, string2, bundle2);
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull String string, @NonNull String string2, View ... viewArray) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#3 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, bundle, string, string2, ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivity(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull String string, @NonNull String string2, @AnimRes int n, @AnimRes int n2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#2 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#3 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity((Context)activity, bundle, string, string2, ActivityUtils.getOptionsBundle((Context)activity, n, n2));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull Intent intent) {
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(intent, Utils.getTopActivityOrApp(), null);
    }

    public static void startActivity(@NonNull Intent intent, @NonNull Bundle bundle) {
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bundle == null) {
            throw new NullPointerException("Argument 'options' of type Bundle (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(intent, Utils.getTopActivityOrApp(), bundle);
    }

    public static void startActivity(@NonNull Intent intent, @AnimRes int n, @AnimRes int n2) {
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivity(intent, context, ActivityUtils.getOptionsBundle(context, n, n2));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(n, n2);
        }
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(intent, (Context)activity, null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, Bundle bundle) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(intent, (Context)activity, bundle);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, View ... viewArray) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(intent, (Context)activity, ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, @AnimRes int n, @AnimRes int n2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivity(intent, (Context)activity, ActivityUtils.getOptionsBundle((Context)activity, n, n2));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n, n2);
        }
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clazz, int n) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clazz.getName(), n, null);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clazz, int n, Bundle bundle) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clazz.getName(), n, bundle);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clazz, int n, View ... viewArray) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clazz.getName(), n, ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clazz, int n, @AnimRes int n2, @AnimRes int n3) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clazz.getName(), n, ActivityUtils.getOptionsBundle((Context)activity, n2, n3));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n2, n3);
        }
    }

    public static void startActivityForResult(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull Class<? extends Activity> clazz, int n) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#2 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, bundle, activity.getPackageName(), clazz.getName(), n, null);
    }

    public static void startActivityForResult(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull Class<? extends Activity> clazz, int n, @NonNull Bundle bundle2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (bundle2 == null) {
            throw new NullPointerException("Argument 'options' of type Bundle (#4 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, bundle, activity.getPackageName(), clazz.getName(), n, bundle2);
    }

    public static void startActivityForResult(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull Class<? extends Activity> clazz, int n, View ... viewArray) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, bundle, activity.getPackageName(), clazz.getName(), n, ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivityForResult(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull Class<? extends Activity> clazz, int n, @AnimRes int n2, @AnimRes int n3) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#2 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, bundle, activity.getPackageName(), clazz.getName(), n, ActivityUtils.getOptionsBundle((Context)activity, n2, n3));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n2, n3);
        }
    }

    public static void startActivityForResult(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull String string, @NonNull String string2, int n) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#2 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#3 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, bundle, string, string2, n, null);
    }

    public static void startActivityForResult(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull String string, @NonNull String string2, int n, Bundle bundle2) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#2 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#3 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, bundle, string, string2, n, bundle2);
    }

    public static void startActivityForResult(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull String string, @NonNull String string2, int n, View ... viewArray) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#2 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#3 out of 6, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, bundle, string, string2, n, ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivityForResult(@NonNull Bundle bundle, @NonNull Activity activity, @NonNull String string, @NonNull String string2, int n, @AnimRes int n2, @AnimRes int n3) {
        if (bundle == null) {
            throw new NullPointerException("Argument 'extras' of type Bundle (#0 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#1 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#2 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (string2 == null) {
            throw new NullPointerException("Argument 'cls' of type String (#3 out of 7, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(activity, bundle, string, string2, n, ActivityUtils.getOptionsBundle((Context)activity, n2, n3));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n2, n3);
        }
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int n) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(intent, activity, n, null);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int n, Bundle bundle) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(intent, activity, n, bundle);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int n, View ... viewArray) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(intent, activity, n, ActivityUtils.getOptionsBundle(activity, viewArray));
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int n, @AnimRes int n2, @AnimRes int n3) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intent == null) {
            throw new NullPointerException("Argument 'intent' of type Intent (#1 out of 5, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivityForResult(intent, activity, n, ActivityUtils.getOptionsBundle((Context)activity, n2, n3));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n2, n3);
        }
    }

    public static void startActivities(@NonNull Intent[] intentArray) {
        if (intentArray == null) {
            throw new NullPointerException("Argument 'intents' of type Intent[] (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivities(intentArray, Utils.getTopActivityOrApp(), null);
    }

    public static void startActivities(@NonNull Intent[] intentArray, Bundle bundle) {
        if (intentArray == null) {
            throw new NullPointerException("Argument 'intents' of type Intent[] (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivities(intentArray, Utils.getTopActivityOrApp(), bundle);
    }

    public static void startActivities(@NonNull Intent[] intentArray, @AnimRes int n, @AnimRes int n2) {
        if (intentArray == null) {
            throw new NullPointerException("Argument 'intents' of type Intent[] (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Context context = Utils.getTopActivityOrApp();
        ActivityUtils.startActivities(intentArray, context, ActivityUtils.getOptionsBundle(context, n, n2));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(n, n2);
        }
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intentArray) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intentArray == null) {
            throw new NullPointerException("Argument 'intents' of type Intent[] (#1 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivities(intentArray, (Context)activity, null);
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intentArray, Bundle bundle) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intentArray == null) {
            throw new NullPointerException("Argument 'intents' of type Intent[] (#1 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivities(intentArray, (Context)activity, bundle);
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intentArray, @AnimRes int n, @AnimRes int n2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        if (intentArray == null) {
            throw new NullPointerException("Argument 'intents' of type Intent[] (#1 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.startActivities(intentArray, (Context)activity, ActivityUtils.getOptionsBundle((Context)activity, n, n2));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(n, n2);
        }
    }

    public static void startHomeActivity() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ActivityUtils.startActivity(intent);
    }

    public static List<Activity> getActivityList() {
        return Utils.getActivityList();
    }

    public static String getLauncherActivity() {
        return ActivityUtils.getLauncherActivity(Utils.getApp().getPackageName());
    }

    public static String getLauncherActivity(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'pkg' of type String (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addFlags(0x10000000);
        PackageManager packageManager = Utils.getApp().getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : list) {
            if (!resolveInfo.activityInfo.packageName.equals(string)) continue;
            return resolveInfo.activityInfo.name;
        }
        return "no " + string;
    }

    public static Activity getTopActivity() {
        return Utils.getActivityLifecycle().getTopActivity();
    }

    public static boolean isActivityExistsInStack(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (Activity activity2 : linkedList) {
            if (!activity2.equals(activity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isActivityExistsInStack(@NonNull Class<? extends Activity> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (Activity activity : linkedList) {
            if (!activity.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static void finishActivity(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.finishActivity(activity, false);
    }

    public static void finishActivity(@NonNull Activity activity, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        activity.finish();
        if (!bl) {
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void finishActivity(@NonNull Activity activity, @AnimRes int n, @AnimRes int n2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        activity.finish();
        activity.overridePendingTransition(n, n2);
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.finishActivity(clazz, false);
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clazz, boolean bl) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (Activity activity : linkedList) {
            if (!activity.getClass().equals(clazz)) continue;
            activity.finish();
            if (bl) continue;
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clazz, @AnimRes int n, @AnimRes int n2) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (Activity activity : linkedList) {
            if (!activity.getClass().equals(clazz)) continue;
            activity.finish();
            activity.overridePendingTransition(n, n2);
        }
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean bl) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return ActivityUtils.finishToActivity(activity, bl, false);
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean bl, boolean bl2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity2 = (Activity)linkedList.get(i);
            if (activity2.equals(activity)) {
                if (bl) {
                    ActivityUtils.finishActivity(activity2, bl2);
                }
                return true;
            }
            ActivityUtils.finishActivity(activity2, bl2);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean bl, @AnimRes int n, @AnimRes int n2) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity2 = (Activity)linkedList.get(i);
            if (activity2.equals(activity)) {
                if (bl) {
                    ActivityUtils.finishActivity(activity2, n, n2);
                }
                return true;
            }
            ActivityUtils.finishActivity(activity2, n, n2);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clazz, boolean bl) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return ActivityUtils.finishToActivity(clazz, bl, false);
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clazz, boolean bl, boolean bl2) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)linkedList.get(i);
            if (activity.getClass().equals(clazz)) {
                if (bl) {
                    ActivityUtils.finishActivity(activity, bl2);
                }
                return true;
            }
            ActivityUtils.finishActivity(activity, bl2);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clazz, boolean bl, @AnimRes int n, @AnimRes int n2) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 4, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)linkedList.get(i);
            if (activity.getClass().equals(clazz)) {
                if (bl) {
                    ActivityUtils.finishActivity(activity, n, n2);
                }
                return true;
            }
            ActivityUtils.finishActivity(activity, n, n2);
        }
        return false;
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        ActivityUtils.finishOtherActivities(clazz, false);
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clazz, boolean bl) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)linkedList.get(i);
            if (activity.getClass().equals(clazz)) continue;
            ActivityUtils.finishActivity(activity, bl);
        }
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clazz, @AnimRes int n, @AnimRes int n2) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 3, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)linkedList.get(i);
            if (activity.getClass().equals(clazz)) continue;
            ActivityUtils.finishActivity(activity, n, n2);
        }
    }

    public static void finishAllActivities() {
        ActivityUtils.finishAllActivities(false);
    }

    public static void finishAllActivities(boolean bl) {
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)linkedList.get(i);
            activity.finish();
            if (bl) continue;
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void finishAllActivities(@AnimRes int n, @AnimRes int n2) {
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)linkedList.get(i);
            activity.finish();
            activity.overridePendingTransition(n, n2);
        }
    }

    public static void finishAllActivitiesExceptNewest() {
        ActivityUtils.finishAllActivitiesExceptNewest(false);
    }

    public static void finishAllActivitiesExceptNewest(boolean bl) {
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 2; i >= 0; --i) {
            ActivityUtils.finishActivity((Activity)linkedList.get(i), bl);
        }
    }

    public static void finishAllActivitiesExceptNewest(@AnimRes int n, @AnimRes int n2) {
        LinkedList<Activity> linkedList = Utils.getActivityList();
        for (int i = linkedList.size() - 2; i >= 0; --i) {
            ActivityUtils.finishActivity((Activity)linkedList.get(i), n, n2);
        }
    }

    public static Drawable getActivityIcon(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return ActivityUtils.getActivityIcon(activity.getComponentName());
    }

    public static Drawable getActivityIcon(@NonNull Class<? extends Activity> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return ActivityUtils.getActivityIcon(new ComponentName((Context)Utils.getApp(), clazz));
    }

    public static Drawable getActivityIcon(@NonNull ComponentName componentName) {
        if (componentName == null) {
            throw new NullPointerException("Argument 'activityName' of type ComponentName (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        PackageManager packageManager = Utils.getApp().getPackageManager();
        try {
            return packageManager.getActivityIcon(componentName);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Drawable getActivityLogo(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return ActivityUtils.getActivityLogo(activity.getComponentName());
    }

    public static Drawable getActivityLogo(@NonNull Class<? extends Activity> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Argument 'clz' of type Class<? extends Activity> (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return ActivityUtils.getActivityLogo(new ComponentName((Context)Utils.getApp(), clazz));
    }

    public static Drawable getActivityLogo(@NonNull ComponentName componentName) {
        if (componentName == null) {
            throw new NullPointerException("Argument 'activityName' of type ComponentName (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        PackageManager packageManager = Utils.getApp().getPackageManager();
        try {
            return packageManager.getActivityLogo(componentName);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    private static void startActivity(Context context, Bundle bundle, String string, String string2, Bundle bundle2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        intent.setComponent(new ComponentName(string, string2));
        ActivityUtils.startActivity(intent, context, bundle2);
    }

    private static void startActivity(Intent intent, Context context, Bundle bundle) {
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (bundle != null && Build.VERSION.SDK_INT >= 16) {
            context.startActivity(intent, bundle);
        } else {
            context.startActivity(intent);
        }
    }

    private static void startActivityForResult(Activity activity, Bundle bundle, String string, String string2, int n, Bundle bundle2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        intent.setComponent(new ComponentName(string, string2));
        ActivityUtils.startActivityForResult(intent, activity, n, bundle2);
    }

    private static void startActivityForResult(Intent intent, Activity activity, int n, Bundle bundle) {
        if (bundle != null && Build.VERSION.SDK_INT >= 16) {
            activity.startActivityForResult(intent, n, bundle);
        } else {
            activity.startActivityForResult(intent, n);
        }
    }

    private static void startActivities(Intent[] intentArray, Context context, Bundle bundle) {
        if (!(context instanceof Activity)) {
            for (Intent intent : intentArray) {
                intent.addFlags(0x10000000);
            }
        }
        if (bundle != null && Build.VERSION.SDK_INT >= 16) {
            context.startActivities(intentArray, bundle);
        } else {
            context.startActivities(intentArray);
        }
    }

    private static Bundle getOptionsBundle(Context context, int n, int n2) {
        return ActivityOptionsCompat.makeCustomAnimation((Context)context, (int)n, (int)n2).toBundle();
    }

    private static Bundle getOptionsBundle(Activity activity, View[] viewArray) {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (viewArray == null) {
            return null;
        }
        int n = viewArray.length;
        if (n <= 0) {
            return null;
        }
        Pair[] pairArray = new Pair[n];
        for (int i = 0; i < n; ++i) {
            pairArray[i] = Pair.create((Object)viewArray[i], (Object)viewArray[i].getTransitionName());
        }
        return ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (Pair[])pairArray).toBundle();
    }
}

