/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioValueMapper;
import com.blackducksoftware.common.value.ContentRange;
import com.blackducksoftware.common.value.ContentType;
import com.blackducksoftware.common.value.Digest;
import com.blackducksoftware.common.value.ProductList;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class StandardJavaValueMapper
implements BdioValueMapper {
    private static final StandardJavaValueMapper INSTANCE = new StandardJavaValueMapper();

    public static StandardJavaValueMapper getInstance() {
        return INSTANCE;
    }

    protected StandardJavaValueMapper() {
    }

    @Override
    public Object fromFieldValue(Map<?, ?> fieldValue) {
        Object id = fieldValue.get("@id");
        if (id != null && fieldValue.size() == 1) {
            return id;
        }
        Object value = fieldValue.get("@value");
        if (value != null) {
            Object type = fieldValue.get("@type");
            if (Objects.equals(type, "@id")) {
                return value;
            }
            return this.fromValue(this.determineStandardType(type), value);
        }
        return fieldValue;
    }

    @Override
    public Object toFieldValue(@Nullable Object definedType, Object input, Predicate<Object> isEmbeddedType) {
        if (input instanceof Map) {
            Object type = ((Map)input).get("@type");
            Object id = ((Map)input).get("@id");
            if (type != null && isEmbeddedType.test(type)) {
                return input;
            }
            if (id != null) {
                LinkedHashMap valueMap = new LinkedHashMap(3);
                if (Objects.equals(definedType, "@id")) {
                    valueMap.put("@id", id);
                } else {
                    valueMap.put("@value", id);
                }
                return valueMap;
            }
            throw new IllegalArgumentException("unrecognized input (" + input.getClass().getName() + "): " + input);
        }
        Object value = this.toValue(this.determineStandardType(definedType), input);
        if (definedType != null && !definedType.equals("") && !definedType.equals(Collections.emptyList())) {
            LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(3);
            valueMap.put("@type", definedType);
            valueMap.put("@value", value);
            return valueMap;
        }
        return value;
    }

    @Override
    public Collector<? super Object, ?, ?> getCollector(String container) {
        switch (this.determineStandardContainer(container)) {
            case single: {
                return Collectors.reducing(null, (a, b) -> a != null ? a : b);
            }
            case ordered: {
                return Collectors.toList();
            }
            case unordered: {
                return Collectors.toList();
            }
        }
        throw new IllegalArgumentException("unknown container: " + container);
    }

    @Override
    public Stream<?> split(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream();
        }
        return Stream.of(value);
    }

    protected Bdio.Datatype determineStandardType(@Nullable Object type) {
        block6: {
            block5: {
                if (type == null || type.equals("") || type.equals(Collections.emptyList())) {
                    return Bdio.Datatype.Default;
                }
                if (!(type instanceof List)) break block5;
                for (Object t : (List)type) {
                    try {
                        return this.determineStandardType(t);
                    }
                    catch (IllegalArgumentException e) {
                    }
                }
                break block6;
            }
            if (!(type instanceof String)) break block6;
            for (Bdio.Datatype datatype : Bdio.Datatype.values()) {
                if (!datatype.toString().equals(type)) continue;
                return datatype;
            }
        }
        throw new IllegalArgumentException("unknown datatype: " + type);
    }

    protected Bdio.Container determineStandardContainer(@Nullable String container) {
        if (container == null || container.isEmpty() || container.equals("@none") || container.equals("@id")) {
            return Bdio.Container.single;
        }
        if (container.equals("@list")) {
            return Bdio.Container.ordered;
        }
        if (container.equals("@set")) {
            return Bdio.Container.unordered;
        }
        throw new IllegalArgumentException("unknown continer: " + container);
    }

    protected Object fromValue(Bdio.Datatype datatype, Object value) {
        switch (datatype) {
            case ContentRange: {
                return ContentRange.from((Object)value);
            }
            case ContentType: {
                return ContentType.from((Object)value);
            }
            case DateTime: {
                return StandardJavaValueMapper.zonedDateTimeFrom(value);
            }
            case Default: {
                return StandardJavaValueMapper.defaultFrom(value);
            }
            case Digest: {
                return Digest.from((Object)value);
            }
            case Long: {
                return StandardJavaValueMapper.longFrom(value);
            }
            case Products: {
                return ProductList.from((Object)value);
            }
        }
        throw new IllegalArgumentException("unknown datatype: " + (Object)((Object)datatype));
    }

    protected Object toValue(Bdio.Datatype datatype, Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return value;
        }
        return value.toString();
    }

    private static Object defaultFrom(Object value) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        throw new IllegalArgumentException("unexpected input: " + value);
    }

    private static ZonedDateTime zonedDateTimeFrom(Object value) {
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value instanceof Temporal) {
            return ZonedDateTime.from((Temporal)value);
        }
        if (value instanceof Date) {
            return ZonedDateTime.ofInstant(((Date)value).toInstant(), ZoneOffset.UTC);
        }
        if (value instanceof CharSequence) {
            return ZonedDateTime.parse(((CharSequence)value).toString());
        }
        throw new IllegalArgumentException("unexpected input: " + value);
    }

    private static Long longFrom(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof CharSequence) {
            return Long.valueOf(((CharSequence)value).toString());
        }
        throw new IllegalArgumentException("unexpected input: " + value);
    }
}

