/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Emitter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.Nullable;

abstract class LegacyJsonParserEmitter
implements Emitter {
    private final Callable<JsonParser> parserSupplier;
    private JsonParser jp;

    protected LegacyJsonParserEmitter(JsonFactory jsonFactory, InputStream inputStream) {
        Objects.requireNonNull(jsonFactory);
        Objects.requireNonNull(inputStream);
        this.parserSupplier = () -> jsonFactory.createParser(inputStream);
    }

    @Override
    public final void emit(Consumer<Object> onNext, Consumer<Throwable> onError, Runnable onComplete) {
        Objects.requireNonNull(onNext);
        Objects.requireNonNull(onError);
        Objects.requireNonNull(onComplete);
        try {
            Object next;
            if (this.jp == null) {
                this.jp = this.parserSupplier.call();
            }
            if ((next = this.next(this.jp)) != null) {
                onNext.accept(next);
            } else {
                onComplete.run();
            }
        }
        catch (Exception e) {
            onError.accept(e);
        }
    }

    @Override
    public final void dispose() {
        if (this.jp != null) {
            try {
                this.jp.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Nullable
    protected abstract Object next(JsonParser var1) throws IOException;
}

