/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.BdioContext;
import com.blackducksoftware.bdio2.BdioEmitter;
import com.blackducksoftware.bdio2.Emitter;
import com.blackducksoftware.bdio2.LegacyBdio1xEmitter;
import com.blackducksoftware.bdio2.LegacyScanContainerEmitter;
import com.blackducksoftware.bdio2.LegacyStreamingScanContainerEmitter;
import com.blackducksoftware.common.io.ExtraIO;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public class EmitterFactory {
    private static final int SNIFF_LIMIT = 512;
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    @VisibleForTesting
    static final ImmutableSet<String> SCAN_CONTAINER_FIELD_NAMES = ImmutableSet.builder().add((Object)"scanProblem").add((Object)"scanProblemList").add((Object)"scanNodeList").add((Object)"baseDir").add((Object)"createdOn").add((Object)"hostName").build();
    @VisibleForTesting
    static final ImmutableSet<String> STREAMABLE_SCAN_CONTAINER_FIELD_NAMES = ImmutableSet.builder().add((Object)"scannerVersion").add((Object)"signatureVersion").add((Object)"ownerEntityKeyToken").build();
    @VisibleForTesting
    static final ImmutableSet<String> BDIO_1X_TYPE_NAMES = ImmutableSet.builder().add((Object)"BillOfMaterials").add((Object)"ExternalIdentifier").add((Object)"MatchDetail").add((Object)"http://blackducksoftware.com/rdf/terms#BillOfMaterials").add((Object)"http://blackducksoftware.com/rdf/terms#Component").add((Object)"http://blackducksoftware.com/rdf/terms#File").add((Object)"http://blackducksoftware.com/rdf/terms#License").add((Object)"http://blackducksoftware.com/rdf/terms#Project").add((Object)"http://blackducksoftware.com/rdf/terms#Vulnerability").add((Object)"http://blackducksoftware.com/rdf/terms#ExternalIdentifier").add((Object)"http://blackducksoftware.com/rdf/terms#MatchDetail").build();
    static final ImmutableSet<String> BDIO_1X_FIELD_NAMES = ImmutableSet.builder().add((Object)"specVersion").add((Object)"externalIdentifier").add((Object)"externalSystemTypeId").add((Object)"externalId").add((Object)"externalRepositoryLocation").add((Object)"matchDetail").add((Object)"matchType").add((Object)"http://blackducksoftware.com/rdf/terms#specVersion").add((Object)"http://blackducksoftware.com/rdf/terms#externalIdentifier").add((Object)"http://blackducksoftware.com/rdf/terms#externalSystemTypeId").add((Object)"http://blackducksoftware.com/rdf/terms#externalId").add((Object)"http://blackducksoftware.com/rdf/terms#externalRepositoryLocation").add((Object)"http://blackducksoftware.com/rdf/terms#matchDetail").add((Object)"http://blackducksoftware.com/rdf/terms#matchType").build();

    public static Emitter newEmitter(BdioContext context, InputStream in) throws IOException {
        InputStream bufferedIn = ExtraIO.buffer((InputStream)in);
        if (context.isLegacyBdio()) {
            return new LegacyBdio1xEmitter(bufferedIn);
        }
        byte[] buffer = new byte[512];
        int len = EmitterFactory.readAndReset(bufferedIn, buffer);
        return EmitterFactory.detectEmitter(buffer, len).orElse(BdioEmitter::new).apply(bufferedIn);
    }

    private static int readAndReset(InputStream in, byte[] buffer) throws IOException {
        in.mark(buffer.length);
        try {
            int n = ByteStreams.read((InputStream)in, (byte[])buffer, (int)0, (int)buffer.length);
            return n;
        }
        finally {
            in.reset();
        }
    }

    @VisibleForTesting
    protected static Optional<Function<InputStream, Emitter>> detectEmitter(byte[] buffer, int len) throws IOException {
        if (EmitterFactory.isEmpty(buffer, len)) {
            return Optional.of(x -> Emitter.empty());
        }
        if (EmitterFactory.isZipMagic(buffer, len)) {
            return Optional.empty();
        }
        if (EmitterFactory.containsBdio1xVocab(buffer, len)) {
            return Optional.of(LegacyBdio1xEmitter::new);
        }
        try {
            JsonParser jp = JSON_FACTORY.createParser(buffer, 0, len);
            jp.nextToken();
            if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
                while (jp.nextToken() == JsonToken.START_OBJECT) {
                    while (jp.nextValue() != JsonToken.END_OBJECT) {
                        if (!BDIO_1X_FIELD_NAMES.contains((Object)jp.getCurrentName()) && (!"@type".equals(jp.getCurrentName()) || !BDIO_1X_TYPE_NAMES.contains((Object)jp.getText()))) continue;
                        return Optional.of(LegacyBdio1xEmitter::new);
                    }
                }
            } else if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                String fieldName = jp.nextFieldName();
                if (SCAN_CONTAINER_FIELD_NAMES.contains((Object)fieldName)) {
                    return Optional.of(LegacyScanContainerEmitter::new);
                }
                if (STREAMABLE_SCAN_CONTAINER_FIELD_NAMES.contains((Object)fieldName)) {
                    return Optional.of(LegacyStreamingScanContainerEmitter::new);
                }
            }
            return Optional.empty();
        }
        catch (JsonParseException e) {
            return Optional.empty();
        }
    }

    private static boolean isZipMagic(byte[] buffer, int len) {
        return len >= 4 && buffer[0] == 80 && buffer[1] == 75 && buffer[2] == 3 && buffer[3] == 4;
    }

    private static boolean isEmpty(byte[] buffer, int len) {
        if (len == 0) {
            return true;
        }
        try {
            JsonParser jp = JSON_FACTORY.createParser(buffer, 0, len);
            return jp.nextToken().isStructStart() && jp.nextToken().isStructEnd();
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean containsBdio1xVocab(byte[] buffer, int len) {
        byte[] array = len == buffer.length ? buffer : Arrays.copyOf(buffer, len);
        byte[] target = "http://blackducksoftware.com/rdf/terms#".getBytes(StandardCharsets.UTF_8);
        return Bytes.indexOf((byte[])array, (byte[])target) > 0;
    }
}

