/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.links;

import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.DefaultCharset;
import java.nio.charset.Charset;

public class RiakLink {
    private final BinaryValue bucket;
    private final BinaryValue key;
    private final BinaryValue tag;

    public RiakLink(String bucket, String key, String tag) {
        this(bucket, key, tag, DefaultCharset.get());
    }

    public RiakLink(String bucket, String key, String tag, Charset charset) {
        this.bucket = BinaryValue.unsafeCreate(bucket.getBytes(charset));
        this.key = BinaryValue.unsafeCreate(key.getBytes(charset));
        this.tag = BinaryValue.unsafeCreate(tag.getBytes(charset));
    }

    public RiakLink(BinaryValue bucket, BinaryValue key, BinaryValue tag) {
        this.bucket = bucket;
        this.key = key;
        this.tag = tag;
    }

    public RiakLink(RiakLink riakLink) {
        this.bucket = riakLink.bucket;
        this.key = riakLink.key;
        this.tag = riakLink.tag;
    }

    public String getBucket() {
        return this.bucket.toString();
    }

    public String getBucket(Charset charset) {
        return this.bucket.toString(charset);
    }

    public BinaryValue getBucketAsBytes() {
        return this.bucket;
    }

    public String getKey() {
        return this.key.toString();
    }

    public String getKey(Charset charset) {
        return this.key.toString(charset);
    }

    public BinaryValue getKeyAsBytes() {
        return this.key;
    }

    public String getTag() {
        return this.tag.toString();
    }

    public String getTag(Charset charset) {
        return this.tag.toString(charset);
    }

    public BinaryValue getTagAsBytes() {
        return this.tag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucket == null ? 0 : this.bucket.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RiakLink)) {
            return false;
        }
        RiakLink other = (RiakLink)obj;
        if (this.bucket == null ? other.bucket != null : !this.bucket.equals(other.bucket)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
    }

    public String toString() {
        return String.format("RiakLink [tag=%s, bucket=%s, key=%s]", this.tag, this.bucket, this.key);
    }
}

