/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query;

import com.basho.riak.client.api.cap.Quorum;
import com.basho.riak.client.core.query.functions.Function;
import java.util.LinkedList;
import java.util.List;

public class BucketProperties {
    private final Function linkwalkFunction;
    private final Function chashKeyFunction;
    private final Quorum rw;
    private final Quorum dw;
    private final Quorum w;
    private final Quorum r;
    private final Quorum pr;
    private final Quorum pw;
    private final Boolean notFoundOk;
    private final Boolean basicQuorum;
    private final List<Function> precommitHooks;
    private final List<Function> postcommitHooks;
    private final Long oldVClock;
    private final Long youngVClock;
    private final Long bigVClock;
    private final Long smallVClock;
    private final String backend;
    private final Integer nVal;
    private final Boolean lastWriteWins;
    private final Boolean allowSiblings;
    private final Boolean search;
    private final String yokozunaIndex;

    private BucketProperties(Builder builder) {
        this.allowSiblings = builder.allowSiblings;
        this.backend = builder.backend;
        this.basicQuorum = builder.basicQuorum;
        this.bigVClock = builder.bigVClock;
        this.chashKeyFunction = builder.chashKeyFunction;
        this.dw = builder.dw;
        this.lastWriteWins = builder.lastWriteWins;
        this.linkwalkFunction = builder.linkwalkFunction;
        this.nVal = builder.nVal;
        this.notFoundOk = builder.notFoundOk;
        this.oldVClock = builder.oldVClock;
        this.postcommitHooks = builder.postcommitHooks;
        this.pr = builder.pr;
        this.precommitHooks = builder.precommitHooks;
        this.pw = builder.pw;
        this.r = builder.r;
        this.rw = builder.rw;
        this.search = builder.search;
        this.smallVClock = builder.smallVClock;
        this.w = builder.w;
        this.yokozunaIndex = builder.yokozunaIndex;
        this.youngVClock = builder.youngVClock;
    }

    public boolean hasLinkwalkFunction() {
        return this.linkwalkFunction != null;
    }

    public Function getLinkwalkFunction() {
        return this.linkwalkFunction;
    }

    public boolean hasChashKeyFunction() {
        return this.chashKeyFunction != null;
    }

    public Function getChashKeyFunction() {
        return this.chashKeyFunction;
    }

    public boolean hasRw() {
        return this.rw != null;
    }

    public Quorum getRw() {
        return this.rw;
    }

    public boolean hasDw() {
        return this.rw != null;
    }

    public Quorum getDw() {
        return this.dw;
    }

    public boolean hasW() {
        return this.w != null;
    }

    public Quorum getW() {
        return this.w;
    }

    public boolean hasR() {
        return this.r != null;
    }

    public Quorum getR() {
        return this.r;
    }

    public boolean hasPr() {
        return this.pr != null;
    }

    public Quorum getPr() {
        return this.pr;
    }

    public boolean hasPw() {
        return this.pw != null;
    }

    public Quorum getPw() {
        return this.pw;
    }

    public boolean hasNotFoundOk() {
        return this.notFoundOk != null;
    }

    public Boolean getNotFoundOk() {
        return this.notFoundOk;
    }

    public boolean hasBasicQuorum() {
        return this.basicQuorum != null;
    }

    public Boolean getBasicQuorum() {
        return this.basicQuorum;
    }

    public boolean hasPrecommitHooks() {
        return !this.precommitHooks.isEmpty();
    }

    public List<Function> getPrecommitHooks() {
        return this.precommitHooks;
    }

    public boolean hasPostcommitHooks() {
        return !this.postcommitHooks.isEmpty();
    }

    public List<Function> getPostcommitHooks() {
        return this.postcommitHooks;
    }

    public boolean hasOldVClock() {
        return this.oldVClock != null;
    }

    public Long getOldVClock() {
        return this.oldVClock;
    }

    public boolean hasYoungVClock() {
        return this.youngVClock != null;
    }

    public Long getYoungVClock() {
        return this.youngVClock;
    }

    public boolean hasBigVClock() {
        return this.bigVClock != null;
    }

    public Long getBigVClock() {
        return this.bigVClock;
    }

    public boolean hasSmallVClock() {
        return this.smallVClock != null;
    }

    public Long getSmallVClock() {
        return this.smallVClock;
    }

    public boolean hasBackend() {
        return this.backend != null;
    }

    public String getBackend() {
        return this.backend;
    }

    public boolean hasNVal() {
        return this.nVal != null;
    }

    public Integer getNVal() {
        return this.nVal;
    }

    public boolean hasLastWriteWins() {
        return this.lastWriteWins != null;
    }

    public Boolean getLastWriteWins() {
        return this.lastWriteWins;
    }

    public boolean hasAllowMulti() {
        return this.allowSiblings != null;
    }

    public Boolean getAllowMulti() {
        return this.allowSiblings;
    }

    public boolean hasLegacyRiakSearchEnabled() {
        return this.search != null;
    }

    public Boolean getLegacyRiakSearchEnabled() {
        return this.search;
    }

    public boolean hasSearchIndex() {
        return this.yokozunaIndex != null;
    }

    public String getSearchIndex() {
        return this.yokozunaIndex;
    }

    public String toString() {
        return String.format("DefaultBucketProperties [allowSiblings=%s, lastWriteWins=%s, nVal=%s, backend=%s,  capProps=[rw=%s,dw=%s,w=%s,r=%s,pr=%s,pw=%s],vclockProps=[oldVClock=%s, youngVClock=%s, bigVClock=%s, smallVClock=%s],precommitHooks=%s, postcommitHooks=%s, , chashKeyFunction=%s, linkWalkFunction=%s, search=%s,yokozunaIndex=%s]", this.allowSiblings, this.lastWriteWins, this.nVal, this.backend, this.rw, this.dw, this.w, this.r, this.pr, this.pw, this.oldVClock, this.youngVClock, this.bigVClock, this.smallVClock, this.precommitHooks, this.postcommitHooks, this.chashKeyFunction, this.linkwalkFunction, this.search, this.yokozunaIndex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (null == this.linkwalkFunction ? 0 : this.linkwalkFunction.hashCode());
        result = 31 * result + (null == this.chashKeyFunction ? 0 : this.chashKeyFunction.hashCode());
        result = 31 * result + (null == this.rw ? 0 : this.rw.hashCode());
        result = 31 * result + (null == this.dw ? 0 : this.dw.hashCode());
        result = 31 * result + (null == this.w ? 0 : this.w.hashCode());
        result = 31 * result + (null == this.r ? 0 : this.r.hashCode());
        result = 31 * result + (null == this.pr ? 0 : this.pr.hashCode());
        result = 31 * result + (null == this.pw ? 0 : this.pw.hashCode());
        result = 31 * result + (null == this.notFoundOk ? 0 : this.notFoundOk.hashCode());
        result = 31 * result + (null == this.basicQuorum ? 0 : this.basicQuorum.hashCode());
        result = 31 * result + this.precommitHooks.hashCode();
        result = 31 * result + this.postcommitHooks.hashCode();
        result = 31 * result + (null == this.oldVClock ? 0 : this.oldVClock.hashCode());
        result = 31 * result + (null == this.youngVClock ? 0 : this.youngVClock.hashCode());
        result = 31 * result + (null == this.bigVClock ? 0 : this.bigVClock.hashCode());
        result = 31 * result + (null == this.smallVClock ? 0 : this.smallVClock.hashCode());
        result = 31 * result + (null == this.backend ? 0 : this.backend.hashCode());
        result = 31 * result + (null == this.nVal ? 0 : this.nVal.hashCode());
        result = 31 * result + (null == this.lastWriteWins ? 0 : this.lastWriteWins.hashCode());
        result = 31 * result + (null == this.allowSiblings ? 0 : this.allowSiblings.hashCode());
        result = 31 * result + (null == this.yokozunaIndex ? 0 : this.yokozunaIndex.hashCode());
        result = 31 * result + (null == this.search ? 0 : this.search.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof BucketProperties)) {
            return false;
        }
        BucketProperties other = (BucketProperties)obj;
        return (this.linkwalkFunction == other.linkwalkFunction || this.linkwalkFunction != null && this.linkwalkFunction.equals(other.linkwalkFunction)) && (this.chashKeyFunction == other.chashKeyFunction || this.chashKeyFunction != null && this.chashKeyFunction.equals(other.chashKeyFunction)) && (this.rw == other.rw || this.rw != null && this.rw.equals(other.rw)) && (this.dw == other.dw || this.dw != null && this.dw.equals(other.rw)) && (this.w == other.w || this.w != null && this.w.equals(other.w)) && (this.r == other.r || this.r != null && this.r.equals(other.r)) && (this.pr == other.pr || this.pr != null && this.pr.equals(other.pr)) && (this.pw == other.pw || this.pw != null && this.pw.equals(other.pw)) && (this.notFoundOk == other.notFoundOk || this.notFoundOk != null && this.notFoundOk.equals(other.notFoundOk)) && (this.basicQuorum == other.basicQuorum || this.basicQuorum != null && this.basicQuorum.equals(other.basicQuorum)) && this.precommitHooks.equals(other.precommitHooks) && this.postcommitHooks.equals(other.postcommitHooks) && (this.oldVClock == other.oldVClock || this.oldVClock != null && this.oldVClock.equals(other.oldVClock)) && (this.youngVClock == other.youngVClock || this.youngVClock != null && this.youngVClock.equals(other.youngVClock)) && (this.bigVClock == other.bigVClock || this.bigVClock != null && this.bigVClock.equals(other.bigVClock)) && (this.smallVClock == other.smallVClock || this.smallVClock != null && this.smallVClock.equals(other.smallVClock)) && (null == this.backend && other.backend == null || this.backend.equals(other.backend)) && (this.nVal == other.nVal || this.nVal != null && this.nVal.equals(other.nVal)) && (this.lastWriteWins == other.lastWriteWins || this.lastWriteWins != null && this.lastWriteWins.equals(other.lastWriteWins)) && (this.allowSiblings == other.allowSiblings || this.allowSiblings != null && this.allowSiblings.equals(other.allowSiblings)) && (null == this.yokozunaIndex && null == other.yokozunaIndex || this.yokozunaIndex.equals(other.yokozunaIndex)) && (this.search == other.search || this.search != null && this.search.equals(other.search));
    }

    public static class Builder {
        private Function linkwalkFunction;
        private Function chashKeyFunction;
        private Quorum rw;
        private Quorum dw;
        private Quorum w;
        private Quorum r;
        private Quorum pr;
        private Quorum pw;
        private Boolean notFoundOk;
        private Boolean basicQuorum;
        private final List<Function> precommitHooks = new LinkedList<Function>();
        private final List<Function> postcommitHooks = new LinkedList<Function>();
        private Long oldVClock;
        private Long youngVClock;
        private Long bigVClock;
        private Long smallVClock;
        private String backend;
        private Integer nVal;
        private Boolean lastWriteWins;
        private Boolean allowSiblings;
        private Boolean search;
        private String yokozunaIndex;

        public Builder withAllowMulti(boolean allow) {
            this.allowSiblings = allow;
            return this;
        }

        public Builder withBackend(String backend) {
            if (null == backend || backend.length() == 0) {
                throw new IllegalArgumentException("Backend can not be null or zero length");
            }
            this.backend = backend;
            return this;
        }

        public Builder withBasicQuorum(boolean use) {
            this.basicQuorum = use;
            return this;
        }

        public Builder withBigVClock(long bigVClock) {
            this.bigVClock = bigVClock;
            return this;
        }

        public Builder withChashkeyFunction(Function func) {
            this.verifyErlangFunc(func);
            this.chashKeyFunction = func;
            return this;
        }

        public Builder withLastWriteWins(boolean wins) {
            this.lastWriteWins = wins;
            return this;
        }

        public Builder withLinkwalkFunction(Function func) {
            this.verifyErlangFunc(func);
            this.linkwalkFunction = func;
            return this;
        }

        public Builder withRw(int rw) {
            this.rw = new Quorum(rw);
            return this;
        }

        public Builder withRw(Quorum rw) {
            this.rw = rw;
            return this;
        }

        public Builder withDw(int dw) {
            this.dw = new Quorum(dw);
            return this;
        }

        public Builder withW(int w) {
            this.w = new Quorum(w);
            return this;
        }

        public Builder withW(Quorum w) {
            this.w = w;
            return this;
        }

        public Builder withR(int r) {
            this.r = new Quorum(r);
            return this;
        }

        public Builder withR(Quorum r) {
            this.r = r;
            return this;
        }

        public Builder withPr(int pr) {
            this.pr = new Quorum(pr);
            return this;
        }

        public Builder withPr(Quorum pr) {
            this.pr = pr;
            return this;
        }

        public Builder withPw(int pw) {
            this.pw = new Quorum(pw);
            return this;
        }

        public Builder withPw(Quorum pw) {
            this.pw = pw;
            return this;
        }

        public Builder withNotFoundOk(boolean ok) {
            this.notFoundOk = ok;
            return this;
        }

        public Builder withPrecommitHook(Function hook) {
            if (null == hook || hook.isJavascript() && !hook.isNamed()) {
                throw new IllegalArgumentException("Must be a named JS or Erlang function.");
            }
            this.precommitHooks.add(hook);
            return this;
        }

        public Builder withPostcommitHook(Function hook) {
            this.verifyErlangFunc(hook);
            this.postcommitHooks.add(hook);
            return this;
        }

        public Builder withOldVClock(long oldVClock) {
            this.oldVClock = oldVClock;
            return this;
        }

        public Builder withYoungVClock(long youngVClock) {
            this.youngVClock = youngVClock;
            return this;
        }

        public Builder withSmallVClock(long smallVClock) {
            this.smallVClock = smallVClock;
            return this;
        }

        public Builder withNVal(int nVal) {
            if (nVal <= 0) {
                throw new IllegalArgumentException("nVal must be >= 1");
            }
            this.nVal = nVal;
            return this;
        }

        public Builder withLegacyRiakSearchEnabled(boolean enable) {
            this.search = enable;
            return this;
        }

        public Builder withSearchIndex(String indexName) {
            if (null == indexName || indexName.length() == 0) {
                throw new IllegalArgumentException("Index name cannot be null or zero length");
            }
            this.yokozunaIndex = indexName;
            return this;
        }

        public BucketProperties build() {
            return new BucketProperties(this);
        }

        private void verifyErlangFunc(Function f) {
            if (null == f || f.isJavascript()) {
                throw new IllegalArgumentException("Must be an Erlang Function.");
            }
        }
    }
}

