/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.PBFutureOperation;
import com.basho.riak.client.core.query.timeseries.CollectionConverters;
import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import com.basho.riak.client.core.query.timeseries.ConvertibleIterable;
import com.basho.riak.client.core.query.timeseries.Row;
import java.util.Collection;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class StoreOperation
extends PBFutureOperation<Void, RiakTsPB.TsPutResp, String> {
    private final String tableName;
    private final int rowCount;
    private String queryInfoMessage;

    private StoreOperation(Builder builder) {
        super((byte)92, (byte)93, builder.reqBuilder, RiakTsPB.TsPutResp.PARSER);
        this.tableName = builder.reqBuilder.getTable().toStringUtf8();
        this.rowCount = builder.reqBuilder.getRowsCount();
    }

    @Override
    protected Void convert(List<RiakTsPB.TsPutResp> responses) {
        this.checkAndGetSingleResponse(responses);
        return null;
    }

    @Override
    public String getQueryInfo() {
        if (this.queryInfoMessage == null) {
            this.queryInfoMessage = this.createQueryInfoMessage();
        }
        return this.queryInfoMessage;
    }

    private String createQueryInfoMessage() {
        return "INSERT <" + this.rowCount + " rows> into " + this.tableName;
    }

    public static class Builder {
        private final RiakTsPB.TsPutReq.Builder reqBuilder;

        public Builder(String tableName) {
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("TableName can not be null or empty");
            }
            this.reqBuilder = RiakTsPB.TsPutReq.newBuilder();
            this.reqBuilder.setTable(ByteString.copyFromUtf8(tableName));
        }

        public Builder withColumns(Collection<ColumnDescription> columns) {
            this.reqBuilder.addAllColumns(CollectionConverters.convertColumnDescriptionsToPb(columns));
            return this;
        }

        public Builder withRows(Iterable<Row> rows) {
            this.reqBuilder.addAllRows(ConvertibleIterable.asIterablePbRow(rows));
            return this;
        }

        public StoreOperation build() {
            return new StoreOperation(this);
        }
    }
}

