/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.HostAndPort;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class CoveragePlanOperation
extends FutureOperation<Response, RiakKvPB.RpbCoverageResp, Namespace> {
    private final RiakKvPB.RpbCoverageReq.Builder reqBuilder;
    private final Namespace namespace;

    private CoveragePlanOperation(AbstractBuilder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.namespace = builder.namespace;
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbCoverageResp> rawResponse) {
        Response r = new Response();
        for (RiakKvPB.RpbCoverageResp resp : rawResponse) {
            for (RiakKvPB.RpbCoverageEntry e : resp.getEntriesList()) {
                Response.CoverageEntry ce = new Response.CoverageEntry();
                Response.CoverageEntry.access$202(ce, e.getCoverContext().toByteArray());
                ce.description = e.getKeyspaceDesc().toStringUtf8();
                ce.host = e.getIp().toStringUtf8();
                ce.port = e.getPort();
                if ("0.0.0.0".equals(ce.getHost())) {
                    LoggerFactory.getLogger(CoveragePlanOperation.class).error("CoveragePlanOperation returns at least one coverage entry: '{}' -- with IP address '0.0.0.0'.\nExecution will be failed due to the imposibility of using IP '0.0.0.0' for querying data from the remote Riak.", (Object)ce.description);
                    throw new RuntimeException("CoveragePlanOperation returns at least one coverage entry with ip '0.0.0.0'.");
                }
                r.addEntry(ce);
            }
        }
        return r;
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(70, this.reqBuilder.build().toByteArray());
    }

    @Override
    protected RiakKvPB.RpbCoverageResp decode(RiakMessage rawMessage) {
        try {
            Operations.checkMessageType(rawMessage, (byte)71);
            return RiakKvPB.RpbCoverageResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid message received", e);
        }
    }

    @Override
    public Namespace getQueryInfo() {
        return this.namespace;
    }

    public static class Response
    implements Iterable<CoverageEntry> {
        private HashMap<HostAndPort, List<CoverageEntry>> perHostCoverage = new HashMap();

        protected Response() {
        }

        protected Response(Response rhs) {
            this.perHostCoverage.putAll(rhs.perHostCoverage);
        }

        public Set<HostAndPort> hosts() {
            return this.perHostCoverage.keySet();
        }

        public List<CoverageEntry> hostEntries(HostAndPort host) {
            List<CoverageEntry> lst = this.perHostCoverage.get(host);
            if (lst == null) {
                return Collections.emptyList();
            }
            return lst;
        }

        public List<CoverageEntry> hostEntries(String host, int port) {
            return this.hostEntries(HostAndPort.fromParts(host, port));
        }

        private static <T> Iterator<T> emptyIterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public Iterator<CoverageEntry> iterator() {
            final Iterator<List<CoverageEntry>> itor = this.perHostCoverage.values().iterator();
            return new Iterator<CoverageEntry>(){
                Iterator<CoverageEntry> subIterator = null;

                @Override
                public boolean hasNext() {
                    if (this.subIterator == null || !this.subIterator.hasNext()) {
                        if (itor.hasNext()) {
                            this.subIterator = ((List)itor.next()).iterator();
                        } else {
                            this.subIterator = Response.emptyIterator();
                            return false;
                        }
                    }
                    return this.subIterator.hasNext();
                }

                @Override
                public CoverageEntry next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    assert (this.subIterator != null);
                    return this.subIterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private void addEntry(CoverageEntry coverageEntry) {
            HostAndPort key = HostAndPort.fromParts(coverageEntry.getHost(), coverageEntry.getPort());
            List<CoverageEntry> lst = this.perHostCoverage.get(key);
            if (lst == null) {
                lst = new LinkedList<CoverageEntry>();
                this.perHostCoverage.put(key, lst);
            }
            lst.add(coverageEntry);
        }

        public static class CoverageEntry
        implements Serializable {
            private static final long serialVersionUID = 0L;
            private String host;
            private int port;
            private String description;
            private byte[] coverageContext;

            public String getHost() {
                return this.host;
            }

            public int getPort() {
                return this.port;
            }

            public String getDescription() {
                return this.description;
            }

            public byte[] getCoverageContext() {
                return this.coverageContext;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof CoverageEntry)) {
                    return false;
                }
                CoverageEntry that = (CoverageEntry)o;
                if (this.getPort() != that.getPort()) {
                    return false;
                }
                if (!this.getHost().equals(that.getHost())) {
                    return false;
                }
                return Arrays.equals(this.getCoverageContext(), that.getCoverageContext());
            }

            public int hashCode() {
                int result = this.getHost().hashCode();
                result = 31 * result + this.getPort();
                result = 31 * result + Arrays.hashCode(this.getCoverageContext());
                return result;
            }

            public String toString() {
                return "CoverageEntry{description='" + this.description + '\'' + '}';
            }

            static /* synthetic */ byte[] access$202(CoverageEntry x0, byte[] x1) {
                x0.coverageContext = x1;
                return x1;
            }
        }
    }

    public static abstract class AbstractBuilder<R> {
        private final RiakKvPB.RpbCoverageReq.Builder reqBuilder = RiakKvPB.RpbCoverageReq.newBuilder();
        private Namespace namespace;

        public AbstractBuilder(Namespace ns) {
            if (ns == null) {
                throw new IllegalArgumentException("Namespace can not be null");
            }
            this.reqBuilder.setType(ByteString.copyFrom(ns.getBucketType().unsafeGetValue()));
            this.reqBuilder.setBucket(ByteString.copyFrom(ns.getBucketName().unsafeGetValue()));
            this.namespace = ns;
        }

        public AbstractBuilder<R> withMinPartitions(int minPartitions) {
            this.reqBuilder.setMinPartitions(minPartitions);
            return this;
        }

        public AbstractBuilder<R> withReplaceCoverageEntry(Response.CoverageEntry coverageEntry) {
            return this.withReplaceCoverageContext(coverageEntry.getCoverageContext());
        }

        public AbstractBuilder<R> withReplaceCoverageContext(byte[] coverageContext) {
            this.reqBuilder.setReplaceCover(ByteString.copyFrom(coverageContext));
            return this;
        }

        public AbstractBuilder<R> withUnavailableCoverageContext(Iterable<byte[]> coverageContext) {
            Iterator<byte[]> iterator = coverageContext.iterator();
            while (iterator.hasNext()) {
                this.withUnavailableCoverageContext(new byte[][]{iterator.next()});
            }
            return this;
        }

        public AbstractBuilder<R> withUnavailableCoverageEntries(Iterable<Response.CoverageEntry> coverageEntries) {
            for (Response.CoverageEntry coverageEntry : coverageEntries) {
                this.withUnavailableCoverageContext(new byte[][]{coverageEntry.getCoverageContext()});
            }
            return this;
        }

        public AbstractBuilder<R> withUnavailableCoverageContext(byte[] ... coverageContext) {
            for (byte[] cc : coverageContext) {
                this.reqBuilder.addUnavailableCover(ByteString.copyFrom(cc));
            }
            return this;
        }

        public CoveragePlanOperation buildOperation() {
            return new CoveragePlanOperation(this);
        }

        public abstract R build();

        public Namespace getNamespace() {
            return this.namespace;
        }
    }
}

