/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core;

import com.basho.riak.client.core.ConnectionFailedException;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.HealthCheckFactory;
import com.basho.riak.client.core.NodeStateListener;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.RiakResponseListener;
import com.basho.riak.client.core.netty.HealthCheckDecoder;
import com.basho.riak.client.core.netty.PingHealthCheck;
import com.basho.riak.client.core.netty.RiakChannelInitializer;
import com.basho.riak.client.core.netty.RiakResponseException;
import com.basho.riak.client.core.netty.RiakSecurityDecoder;
import com.basho.riak.client.core.util.HostAndPort;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiakNode
implements RiakResponseListener {
    private final Logger logger = LoggerFactory.getLogger(RiakNode.class);
    private final LinkedBlockingDeque<ChannelWithIdleTime> available = new LinkedBlockingDeque();
    private final ConcurrentLinkedQueue<ChannelWithIdleTime> recentlyClosed = new ConcurrentLinkedQueue();
    private final List<NodeStateListener> stateListeners = Collections.synchronizedList(new LinkedList());
    private final Map<Channel, FutureOperation> inProgressMap = new ConcurrentHashMap<Channel, FutureOperation>();
    private final Sync permits;
    private final String remoteAddress;
    private final int port;
    private final String username;
    private final String password;
    private final KeyStore trustStore;
    private final KeyStore keyStore;
    private final String keyPassword;
    private final AtomicLong consecutiveFailedOperations = new AtomicLong(0L);
    private final AtomicLong consecutiveFailedConnectionAttempts = new AtomicLong(0L);
    private volatile Bootstrap bootstrap;
    private volatile boolean ownsBootstrap;
    private volatile ScheduledExecutorService executor;
    private volatile boolean ownsExecutor;
    private volatile State state;
    private volatile ScheduledFuture<?> idleReaperFuture;
    private volatile ScheduledFuture<?> healthMonitorFuture;
    private volatile int minConnections;
    private volatile long idleTimeoutInNanos;
    private volatile int connectionTimeout;
    private volatile boolean blockOnMaxConnections;
    private HealthCheckFactory healthCheckFactory;
    private final ChannelFutureListener writeListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                RiakNode.this.logger.error("Write failed on RiakNode {}:{} id: {}; cause: {}", new Object[]{RiakNode.this.remoteAddress, RiakNode.this.port, future.channel().hashCode(), future.cause()});
                FutureOperation inProgress = (FutureOperation)RiakNode.this.inProgressMap.remove(future.channel());
                if (inProgress != null) {
                    future.channel().close();
                    RiakNode.this.returnConnection(future.channel());
                    RiakNode.this.recentlyClosed.add(new ChannelWithIdleTime(future.channel()));
                    inProgress.setException(future.cause());
                }
            } else {
                future.channel().closeFuture().addListener((GenericFutureListener)RiakNode.this.inProgressCloseListener);
            }
        }
    };
    private final ChannelFutureListener inAvailableCloseListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            RiakNode.this.recentlyClosed.add(new ChannelWithIdleTime(future.channel()));
            RiakNode.this.logger.error("inAvailable channel closed; id:{} {}:{}", new Object[]{future.channel().hashCode(), RiakNode.this.remoteAddress, RiakNode.this.port});
        }
    };
    private final ChannelFutureListener inProgressCloseListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            FutureOperation inProgress = (FutureOperation)RiakNode.this.inProgressMap.remove(future.channel());
            RiakNode.this.logger.error("Channel closed while operation in progress; id:{} {}:{}", new Object[]{future.channel().hashCode(), RiakNode.this.remoteAddress, RiakNode.this.port});
            if (inProgress != null) {
                RiakNode.this.returnConnection(future.channel());
                RiakNode.this.recentlyClosed.add(new ChannelWithIdleTime(future.channel()));
                if (future.cause() != null) {
                    inProgress.setException(future.cause());
                } else {
                    inProgress.setException(new Exception("Connection closed unexpectantly"));
                }
            }
        }
    };
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    private RiakNode(Builder builder) {
        this.executor = builder.executor;
        this.connectionTimeout = builder.connectionTimeout;
        this.idleTimeoutInNanos = TimeUnit.NANOSECONDS.convert(builder.idleTimeout, TimeUnit.MILLISECONDS);
        this.minConnections = builder.minConnections;
        this.port = builder.port;
        this.remoteAddress = builder.remoteAddress;
        this.blockOnMaxConnections = builder.blockOnMaxConnections;
        this.username = builder.username;
        this.password = builder.password;
        this.trustStore = builder.trustStore;
        this.keyStore = builder.keyStore;
        this.keyPassword = builder.keyPassword;
        this.healthCheckFactory = builder.healthCheckFactory;
        if (builder.bootstrap != null) {
            this.bootstrap = builder.bootstrap.clone();
        }
        this.permits = builder.maxConnections < 1 ? new Sync(Integer.MAX_VALUE) : new Sync(builder.maxConnections);
        this.checkNetworkAddressCacheSettings();
        this.state = State.CREATED;
    }

    private void stateCheck(State ... allowedStates) {
        if (Arrays.binarySearch((Object[])allowedStates, (Object)this.state) < 0) {
            this.logger.debug("IllegalStateException; RiakNode: {}:{} required: {} current: {} ", new Object[]{this.remoteAddress, this.port, Arrays.toString((Object[])allowedStates), this.state});
            throw new IllegalStateException("required: " + Arrays.toString((Object[])allowedStates) + " current: " + (Object)((Object)this.state));
        }
    }

    int getNumInProgress() {
        return this.inProgressMap.size();
    }

    public synchronized RiakNode start() throws UnknownHostException {
        this.stateCheck(State.CREATED);
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.ownsExecutor = true;
        }
        if (this.bootstrap == null) {
            this.bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class);
            this.ownsBootstrap = true;
        }
        this.bootstrap.handler((ChannelHandler)new RiakChannelInitializer(this));
        this.refreshBootstrapRemoteAddress();
        if (this.connectionTimeout > 0) {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeout);
        }
        if (this.minConnections > 0) {
            LinkedList<Channel> minChannels = new LinkedList<Channel>();
            for (int i = 0; i < this.minConnections; ++i) {
                try {
                    Channel channel = this.doGetConnection(false);
                    minChannels.add(channel);
                    continue;
                }
                catch (ConnectionFailedException connectionFailedException) {
                    // empty catch block
                }
            }
            for (Channel c : minChannels) {
                this.available.offerFirst(new ChannelWithIdleTime(c));
                c.closeFuture().addListener((GenericFutureListener)this.inAvailableCloseListener);
            }
        }
        this.idleReaperFuture = this.executor.scheduleWithFixedDelay(new IdleReaper(), 1L, 5L, TimeUnit.SECONDS);
        this.healthMonitorFuture = this.executor.scheduleWithFixedDelay(new HealthMonitorTask(), 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.state = State.RUNNING;
        this.logger.info("RiakNode started; {}:{}", (Object)this.remoteAddress, (Object)this.port);
        this.notifyStateListeners();
        return this;
    }

    private void refreshBootstrapRemoteAddress() throws UnknownHostException {
        InetSocketAddress socketAddress = new InetSocketAddress(this.remoteAddress, this.port);
        if (socketAddress.isUnresolved()) {
            throw new UnknownHostException("RiakNode:start - Failed resolving host " + this.remoteAddress);
        }
        this.bootstrap.remoteAddress((SocketAddress)socketAddress);
    }

    public synchronized Future<Boolean> shutdown() {
        this.stateCheck(State.RUNNING, State.HEALTH_CHECKING);
        this.state = State.SHUTTING_DOWN;
        this.logger.info("RiakNode shutting down; {}:{}", (Object)this.remoteAddress, (Object)this.port);
        this.notifyStateListeners();
        this.idleReaperFuture.cancel(true);
        this.healthMonitorFuture.cancel(true);
        ChannelWithIdleTime cwi = this.available.poll();
        while (cwi != null) {
            Channel c = cwi.getChannel();
            this.closeConnection(c);
            cwi = this.available.poll();
        }
        this.executor.schedule(new ShutdownTask(), 0L, TimeUnit.SECONDS);
        return new Future<Boolean>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public Boolean get() throws InterruptedException {
                RiakNode.this.shutdownLatch.await();
                return true;
            }

            @Override
            public Boolean get(long timeout, TimeUnit unit) throws InterruptedException {
                return RiakNode.this.shutdownLatch.await(timeout, unit);
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return RiakNode.this.shutdownLatch.getCount() <= 0L;
            }
        };
    }

    public RiakNode setBootstrap(Bootstrap bootstrap) {
        this.stateCheck(State.CREATED);
        if (this.bootstrap != null) {
            throw new IllegalArgumentException("Bootstrap already set");
        }
        this.bootstrap = bootstrap.clone();
        return this;
    }

    public RiakNode setExecutor(ScheduledExecutorService executor) {
        this.stateCheck(State.CREATED);
        if (this.executor != null) {
            throw new IllegalArgumentException("Executor already set");
        }
        this.executor = executor;
        return this;
    }

    public RiakNode setMaxConnections(int maxConnections) {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        if (maxConnections < this.getMinConnections()) {
            throw new IllegalArgumentException("Max connections less than min connections");
        }
        this.permits.setMaxPermits(maxConnections);
        return this;
    }

    public int getMaxConnections() {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        return this.permits.getMaxPermits();
    }

    public RiakNode setMinConnections(int minConnections) {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        if (minConnections > this.getMaxConnections()) {
            throw new IllegalArgumentException("Min connections greater than max connections");
        }
        this.minConnections = minConnections;
        return this;
    }

    public int getMinConnections() {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        return this.minConnections;
    }

    public void setBlockOnMaxConnections(boolean block) {
        this.blockOnMaxConnections = block;
    }

    public boolean getBlockOnMaxConnections() {
        return this.blockOnMaxConnections;
    }

    public RiakNode setIdleTimeout(int idleTimeoutInMillis) {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        this.idleTimeoutInNanos = TimeUnit.NANOSECONDS.convert(idleTimeoutInMillis, TimeUnit.MILLISECONDS);
        return this;
    }

    public int getIdleTimeout() {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        return (int)TimeUnit.MILLISECONDS.convert(this.idleTimeoutInNanos, TimeUnit.NANOSECONDS);
    }

    public RiakNode setConnectionTimeout(int connectionTimeoutInMillis) {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        this.connectionTimeout = connectionTimeoutInMillis;
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeout);
        return this;
    }

    public int getConnectionTimeout() {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        return this.connectionTimeout;
    }

    public int availablePermits() {
        this.stateCheck(State.CREATED, State.RUNNING, State.HEALTH_CHECKING);
        return this.permits.availablePermits();
    }

    public void addStateListener(NodeStateListener listener) {
        this.stateListeners.add(listener);
    }

    public boolean removeStateListener(NodeStateListener listener) {
        return this.stateListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStateListeners() {
        List<NodeStateListener> list = this.stateListeners;
        synchronized (list) {
            for (NodeStateListener listener : this.stateListeners) {
                listener.nodeStateChanged(this, this.state);
            }
        }
    }

    public boolean execute(FutureOperation operation) {
        this.stateCheck(State.RUNNING, State.HEALTH_CHECKING);
        operation.setLastNode(this);
        Channel channel = this.getConnection();
        if (channel != null) {
            this.inProgressMap.put(channel, operation);
            ChannelFuture writeFuture = channel.writeAndFlush((Object)operation);
            writeFuture.addListener((GenericFutureListener)this.writeListener);
            this.logger.debug("Operation being executed on RiakNode {}:{}", (Object)this.remoteAddress, (Object)this.port);
            return true;
        }
        this.logger.debug("Operation not being executed Riaknode {}:{}; no connections available", (Object)this.remoteAddress, (Object)this.port);
        return false;
    }

    private Channel getConnection() {
        this.stateCheck(State.RUNNING, State.HEALTH_CHECKING);
        boolean acquired = false;
        if (this.blockOnMaxConnections) {
            try {
                this.logger.debug("Attempting to acquire channel permit");
                if (!this.permits.tryAcquire()) {
                    this.logger.info("All connections in use for {}; had to wait for one.", (Object)this.remoteAddress);
                    this.permits.acquire();
                }
                acquired = true;
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.logger.debug("Attempting to acquire channel permit");
            acquired = this.permits.tryAcquire();
        }
        Channel channel = null;
        if (acquired) {
            try {
                channel = this.doGetConnection(true);
                channel.closeFuture().removeListener((GenericFutureListener)this.inAvailableCloseListener);
            }
            catch (ConnectionFailedException ex) {
                this.permits.release();
            }
            catch (UnknownHostException ex) {
                this.permits.release();
                this.logger.error("Unknown host encountered while trying to open connection; {}", (Throwable)ex);
            }
        }
        return channel;
    }

    private Channel doGetConnection(boolean forceAddressRefresh) throws ConnectionFailedException, UnknownHostException {
        ChannelWithIdleTime cwi;
        while ((cwi = this.available.poll()) != null) {
            Channel channel = cwi.getChannel();
            if (!channel.isOpen()) continue;
            return channel;
        }
        if (forceAddressRefresh) {
            this.refreshBootstrapRemoteAddress();
        }
        ChannelFuture f = this.bootstrap.connect();
        try {
            f.await();
        }
        catch (InterruptedException ex) {
            this.logger.error("Thread interrupted waiting for new connection to be made; {}", (Object)this.remoteAddress);
            Thread.currentThread().interrupt();
            throw new ConnectionFailedException(ex);
        }
        if (!f.isSuccess()) {
            this.logger.error("Connection attempt failed: {}:{}; {}", new Object[]{this.remoteAddress, this.port, f.cause()});
            this.consecutiveFailedConnectionAttempts.incrementAndGet();
            throw new ConnectionFailedException(f.cause());
        }
        this.consecutiveFailedConnectionAttempts.set(0L);
        Channel c = f.channel();
        if (this.trustStore != null) {
            this.setupTLSAndAuthenticate(c);
        }
        return c;
    }

    private void setupTLSAndAuthenticate(Channel c) throws ConnectionFailedException {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.trustStore);
            if (this.keyStore != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(this.keyStore, this.keyPassword == null ? "".toCharArray() : this.keyPassword.toCharArray());
                context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            } else {
                context.init(null, tmf.getTrustManagers(), null);
            }
        }
        catch (Exception ex) {
            c.close();
            this.logger.error("Failure configuring SSL; {}:{} {}", new Object[]{this.remoteAddress, this.port, ex});
            throw new ConnectionFailedException(ex);
        }
        SSLEngine engine = context.createSSLEngine();
        HashSet<String> protocols = new HashSet<String>(Arrays.asList(engine.getSupportedProtocols()));
        if (protocols.contains("TLSv1.2")) {
            engine.setEnabledProtocols(new String[]{"TLSv1.2"});
            this.logger.debug("Using TLSv1.2");
        } else if (protocols.contains("TLSv1.1")) {
            engine.setEnabledProtocols(new String[]{"TLSv1.1"});
            this.logger.debug("Using TLSv1.1");
        }
        engine.setUseClientMode(true);
        RiakSecurityDecoder decoder = new RiakSecurityDecoder(engine, this.username, this.password);
        c.pipeline().addFirst(new ChannelHandler[]{decoder});
        try {
            DefaultPromise<Void> promise = decoder.getPromise();
            this.logger.debug("Waiting on SSL Promise");
            promise.await();
            if (!promise.isSuccess()) {
                c.close();
                this.logger.error("Failure during Auth; {}:{} {}", new Object[]{this.remoteAddress, this.port, promise.cause()});
                throw new ConnectionFailedException(promise.cause());
            }
            this.logger.debug("Auth succeeded; {}:{}", (Object)this.remoteAddress, (Object)this.port);
        }
        catch (InterruptedException e) {
            c.close();
            this.logger.error("Thread interrupted during Auth; {}:{}", (Object)this.remoteAddress, (Object)this.port);
            Thread.currentThread().interrupt();
            throw new ConnectionFailedException(e);
        }
    }

    private void returnConnection(Channel c) {
        switch (this.state) {
            case SHUTTING_DOWN: 
            case SHUTDOWN: {
                this.closeConnection(c);
                break;
            }
            default: {
                if (this.inProgressMap.containsKey(c)) {
                    this.logger.error("Channel returned to pool while still in use. id: {}", (Object)c.hashCode());
                    break;
                }
                if (c.isOpen()) {
                    this.logger.debug("Channel id:{} returned to pool", (Object)c.hashCode());
                    c.closeFuture().removeListener((GenericFutureListener)this.inProgressCloseListener);
                    c.closeFuture().addListener((GenericFutureListener)this.inAvailableCloseListener);
                    this.available.offerFirst(new ChannelWithIdleTime(c));
                } else {
                    this.logger.debug("Closed channel id:{} returned to pool; discarding", (Object)c.hashCode());
                }
                this.logger.debug("Released pool permit");
                this.permits.release();
            }
        }
    }

    private void closeConnection(Channel c) {
        c.closeFuture().removeListener((GenericFutureListener)this.inProgressCloseListener);
        c.closeFuture().removeListener((GenericFutureListener)this.inAvailableCloseListener);
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Channel channel, RiakMessage response) {
        this.logger.debug("Operation onSuccess() channel: id:{} {}:{}", new Object[]{channel.hashCode(), this.remoteAddress, this.port});
        this.consecutiveFailedOperations.set(0L);
        FutureOperation inProgress = this.inProgressMap.get(channel);
        if (inProgress != null) {
            inProgress.setResponse(response);
            if (inProgress.isDone()) {
                try {
                    this.inProgressMap.remove(channel);
                    this.returnConnection(channel);
                }
                finally {
                    inProgress.setComplete();
                }
            }
        }
    }

    @Override
    public void onRiakErrorResponse(Channel channel, RiakResponseException ex) {
        this.logger.debug("Riak replied with error; {}:{}", (Object)ex.getCode(), (Object)ex.getMessage());
        FutureOperation inProgress = this.inProgressMap.remove(channel);
        this.consecutiveFailedOperations.incrementAndGet();
        if (inProgress != null) {
            this.returnConnection(channel);
            inProgress.setException(ex);
        }
    }

    @Override
    public void onException(Channel channel, Throwable t) {
        this.logger.error("Operation onException() channel: id:{} {}:{} {}", new Object[]{channel.hashCode(), this.remoteAddress, this.port, t});
        FutureOperation inProgress = this.inProgressMap.remove(channel);
        if (inProgress != null) {
            this.returnConnection(channel);
            inProgress.setException(t);
        }
    }

    private void checkNetworkAddressCacheSettings() {
        String property = Security.getProperty("networkaddress.cache.ttl");
        boolean usingSecurityMgr = System.getSecurityManager() != null;
        boolean propertyUndefined = property == null;
        boolean logWarning = false;
        if (propertyUndefined && usingSecurityMgr) {
            logWarning = true;
        } else if (!propertyUndefined) {
            int cacheTTL = Integer.parseInt(property);
            boolean bl = logWarning = cacheTTL == -1;
        }
        if (logWarning) {
            this.logger.warn("The Java Security \"networkaddress.cache.ttl\" property may be set to cache DNS lookups forever. Using domain names for Riak nodes or an intermediate load balancer could result in stale IP addresses being used for new connections, causing connection errors. If you use domain names for Riak nodes, please set this property to a value greater than zero.");
        }
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getPort() {
        return this.port;
    }

    public State getNodeState() {
        return this.state;
    }

    private void reapIdleConnections() {
        int currentNum = this.inProgressMap.size() + this.available.size();
        if (currentNum > this.minConnections) {
            ChannelWithIdleTime cwi;
            Iterator<ChannelWithIdleTime> i = this.available.descendingIterator();
            while (i.hasNext() && currentNum > this.minConnections && (cwi = i.next()).getIdleStart() + this.idleTimeoutInNanos < System.nanoTime()) {
                boolean removed = this.available.remove(cwi);
                if (!removed) continue;
                Channel c = cwi.getChannel();
                this.logger.debug("Idle channel closed; {}:{}", (Object)this.remoteAddress, (Object)this.port);
                this.closeConnection(c);
                --currentNum;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHealth() {
        try {
            HealthCheckDecoder healthCheck = this.healthCheckFactory.makeDecoder();
            RiakFuture<RiakMessage, Void> future = healthCheck.getFuture();
            Channel c = this.doGetConnection(true);
            this.logger.debug("Healthcheck channel: {} isOpen: {} handlers:{}", new Object[]{c.hashCode(), c.isOpen(), c.pipeline().names()});
            try {
                if (c.pipeline().names().contains("sslHandler")) {
                    c.pipeline().addAfter("sslHandler", "healthCheckCodec", (ChannelHandler)healthCheck);
                } else {
                    c.pipeline().addBefore("codec", "healthCheckCodec", (ChannelHandler)healthCheck);
                }
                this.logger.debug("healthCheck added to pipeline.");
                future.await();
                if (future.isSuccess()) {
                    this.healthCheckSucceeded();
                } else {
                    this.healthCheckFailed(future.cause());
                }
            }
            catch (InterruptedException ex) {
                this.logger.error("Thread interrupted performing healthcheck.");
            }
            catch (NoSuchElementException e) {
                this.healthCheckFailed(new IOException("Channel closed during health check"));
            }
            finally {
                this.closeConnection(c);
            }
        }
        catch (ConnectionFailedException ex) {
            this.healthCheckFailed(ex);
        }
        catch (UnknownHostException ex) {
            this.healthCheckFailed(ex);
        }
        catch (IllegalStateException ex) {
            this.logger.debug("Illegal state exception during healthcheck.");
            this.logger.debug("Stack: {}", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            this.logger.error("Runtime exception during healthcheck: {}", (Throwable)ex);
        }
    }

    private void healthCheckFailed(Throwable cause) {
        if (this.state == State.RUNNING) {
            this.logger.error("RiakNode failed healthcheck operation; health checking; {}:{} {}", new Object[]{this.remoteAddress, this.port, cause});
            this.state = State.HEALTH_CHECKING;
            this.notifyStateListeners();
        } else {
            this.logger.error("RiakNode failed healthcheck operation; {}:{} {}", new Object[]{this.remoteAddress, this.port, cause});
        }
    }

    private void healthCheckSucceeded() {
        if (this.state == State.HEALTH_CHECKING) {
            this.logger.info("RiakNode recovered; {}:{}", (Object)this.remoteAddress, (Object)this.port);
            this.state = State.RUNNING;
            this.notifyStateListeners();
        }
    }

    public static class Builder {
        public static final String DEFAULT_REMOTE_ADDRESS = "127.0.0.1";
        public static final int DEFAULT_REMOTE_PORT = 8087;
        public static final int DEFAULT_MIN_CONNECTIONS = 1;
        public static final int DEFAULT_MAX_CONNECTIONS = 0;
        public static final int DEFAULT_IDLE_TIMEOUT = 1000;
        public static final int DEFAULT_CONNECTION_TIMEOUT = 0;
        public static final HealthCheckFactory DEFAULT_HEALTHCHECK_FACTORY = new PingHealthCheck();
        private int port = 8087;
        private String remoteAddress = "127.0.0.1";
        private int minConnections = 1;
        private int maxConnections = 0;
        private int idleTimeout = 1000;
        private int connectionTimeout = 0;
        private HealthCheckFactory healthCheckFactory = DEFAULT_HEALTHCHECK_FACTORY;
        private Bootstrap bootstrap;
        private ScheduledExecutorService executor;
        private boolean blockOnMaxConnections;
        private String username;
        private String password;
        private KeyStore trustStore;
        private KeyStore keyStore;
        private String keyPassword;

        public Builder withRemoteHost(HostAndPort hostAndPOrt) {
            this.withRemoteAddress(hostAndPOrt.getHost());
            this.withRemotePort(hostAndPOrt.getPort());
            return this;
        }

        public Builder withRemoteAddress(String remoteAddress) {
            this.withRemoteAddress(HostAndPort.fromString(remoteAddress, this.port));
            return this;
        }

        public Builder withRemotePort(int port) {
            this.port = port;
            return this;
        }

        public Builder withRemoteAddress(HostAndPort hp) {
            this.port = hp.getPortOrDefault(8087);
            this.remoteAddress = hp.getHost();
            return this;
        }

        public Builder withMinConnections(int minConnections) {
            if (this.maxConnections != 0 && minConnections > this.maxConnections) {
                throw new IllegalArgumentException("Min connections greater than max connections");
            }
            this.minConnections = minConnections;
            return this;
        }

        public Builder withMaxConnections(int maxConnections) {
            if (maxConnections != 0 && maxConnections < this.minConnections) {
                throw new IllegalArgumentException("Max connections less than min connections");
            }
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder withIdleTimeout(int idleTimeoutInMillis) {
            this.idleTimeout = idleTimeoutInMillis;
            return this;
        }

        public Builder withConnectionTimeout(int connectionTimeoutInMillis) {
            this.connectionTimeout = connectionTimeoutInMillis;
            return this;
        }

        public Builder withExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withBootstrap(Bootstrap bootstrap) {
            this.bootstrap = bootstrap;
            return this;
        }

        public Builder withBlockOnMaxConnections(boolean block) {
            this.blockOnMaxConnections = block;
            return this;
        }

        public Builder withAuth(String username, String password, KeyStore trustStore) {
            this.username = username;
            this.password = password;
            this.trustStore = trustStore;
            return this;
        }

        public Builder withAuth(String username, String password, KeyStore trustStore, KeyStore keyStore, String keyPassword) {
            this.username = username;
            this.password = password;
            this.trustStore = trustStore;
            this.keyStore = keyStore;
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder withHealthCheck(HealthCheckFactory factory) {
            this.healthCheckFactory = factory;
            return this;
        }

        public RiakNode build() {
            return new RiakNode(this);
        }

        public static List<RiakNode> buildNodes(Builder builder, List<String> remoteAddresses) {
            HashSet<HostAndPort> hps = new HashSet<HostAndPort>();
            for (String remoteAddress : remoteAddresses) {
                hps.addAll(HostAndPort.hostsFromString(remoteAddress, builder.port));
            }
            ArrayList<RiakNode> nodes = new ArrayList<RiakNode>(hps.size());
            for (HostAndPort hp : hps) {
                builder.withRemoteAddress(hp);
                nodes.add(builder.build());
            }
            return nodes;
        }

        public static List<RiakNode> buildNodes(Builder builder, String ... remoteAddresses) throws UnknownHostException {
            return Builder.buildNodes(builder, Arrays.asList(remoteAddresses));
        }
    }

    private class ShutdownTask
    implements Runnable {
        private ShutdownTask() {
        }

        @Override
        public void run() {
            if (RiakNode.this.inProgressMap.isEmpty()) {
                RiakNode.this.state = State.SHUTDOWN;
                RiakNode.this.notifyStateListeners();
                if (RiakNode.this.ownsExecutor) {
                    RiakNode.this.executor.shutdown();
                }
                if (RiakNode.this.ownsBootstrap) {
                    RiakNode.this.bootstrap.group().shutdownGracefully();
                }
                RiakNode.this.logger.debug("RiakNode shut down {}:{}", (Object)RiakNode.this.remoteAddress, (Object)RiakNode.this.port);
                RiakNode.this.shutdownLatch.countDown();
            }
        }
    }

    private class HealthMonitorTask
    implements Runnable {
        private HealthMonitorTask() {
        }

        @Override
        public void run() {
            long current = System.nanoTime();
            long window = 3000000000L;
            ChannelWithIdleTime cwi = (ChannelWithIdleTime)RiakNode.this.recentlyClosed.peek();
            while (cwi != null && current - cwi.getIdleStart() > window) {
                RiakNode.this.recentlyClosed.poll();
                cwi = (ChannelWithIdleTime)RiakNode.this.recentlyClosed.peek();
            }
            if (RiakNode.this.state == State.RUNNING && (RiakNode.this.recentlyClosed.size() > 5 || RiakNode.this.consecutiveFailedConnectionAttempts.get() > 1L || RiakNode.this.consecutiveFailedOperations.get() > 5L) || RiakNode.this.state == State.HEALTH_CHECKING) {
                RiakNode.this.checkHealth();
            }
        }
    }

    private class IdleReaper
    implements Runnable {
        private IdleReaper() {
        }

        @Override
        public void run() {
            RiakNode.this.reapIdleConnections();
        }
    }

    private class Sync
    extends Semaphore {
        private static final long serialVersionUID = -5118488872281021072L;
        private volatile int maxPermits;

        public Sync(int numPermits) {
            super(numPermits);
            this.maxPermits = numPermits;
        }

        public Sync(int numPermits, boolean fair) {
            super(numPermits, fair);
            this.maxPermits = numPermits;
        }

        public int getMaxPermits() {
            return this.maxPermits;
        }

        synchronized void setMaxPermits(int maxPermits) {
            int diff = maxPermits - this.maxPermits;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                this.release(diff);
            } else if (diff < 0) {
                this.reducePermits(diff);
            }
            this.maxPermits = maxPermits;
        }
    }

    private class ChannelWithIdleTime {
        private Channel channel;
        private long idleStart;

        public ChannelWithIdleTime(Channel channel) {
            this.channel = channel;
            this.idleStart = System.nanoTime();
        }

        public Channel getChannel() {
            return this.channel;
        }

        public long getIdleStart() {
            return this.idleStart;
        }
    }

    public static enum State {
        CREATED,
        RUNNING,
        HEALTH_CHECKING,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

