/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert.reflection;

import com.basho.riak.client.api.annotations.RiakIndex;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Set;

public class RiakIndexMethod {
    private final Method method;
    private final String indexName;
    private final MethodType methodType;

    public RiakIndexMethod(Method method) {
        this.methodType = this.validateAndGetReturnType(method);
        this.method = method;
        this.indexName = method.getAnnotation(RiakIndex.class).name();
        if (this.indexName.isEmpty()) {
            throw new IllegalArgumentException("@RiakIndex must have 'name' parameter");
        }
        if (!(this.methodType != MethodType.RAW_GETTER && this.methodType != MethodType.RAW_SETTER && this.methodType != MethodType.SET_RAW_GETTER && this.methodType != MethodType.SET_RAW_SETTER || this.indexName.endsWith("_bin") || this.indexName.endsWith("_int"))) {
            throw new IllegalArgumentException("@RiakIndex annotated byte[] setter/getter must declare full indexname");
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    private MethodType validateAndGetReturnType(Method m) {
        if (m != null) {
            if (m.getReturnType().equals(Void.TYPE)) {
                Type[] genericParameterTypes = m.getGenericParameterTypes();
                Type t = genericParameterTypes[0];
                if (t instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)t;
                    if (pType.getRawType().equals(Set.class)) {
                        Class genericType = (Class)pType.getActualTypeArguments()[0];
                        if (String.class.equals((Object)genericType)) {
                            return MethodType.SET_STRING_SETTER;
                        }
                        if (Long.class.equals((Object)genericType)) {
                            return MethodType.SET_LONG_SETTER;
                        }
                        if (BigInteger.class.equals((Object)genericType)) {
                            return MethodType.SET_BIG_INT_SETTER;
                        }
                        if (genericType.isArray() && genericType.getComponentType().equals(Byte.TYPE)) {
                            return MethodType.SET_RAW_SETTER;
                        }
                    }
                } else {
                    Class<?> c = m.getParameterTypes()[0];
                    if (c.equals(String.class)) {
                        return MethodType.STRING_SETTER;
                    }
                    if (c.equals(Long.class) || c.equals(Long.TYPE)) {
                        return MethodType.LONG_SETTER;
                    }
                    if (c.equals(BigInteger.class)) {
                        return MethodType.BIG_INT_SETTER;
                    }
                    if (c.isArray() && c.getComponentType().equals(Byte.TYPE)) {
                        return MethodType.RAW_SETTER;
                    }
                }
                throw new IllegalArgumentException("@RiakIndex setter must take a single or Set<> of String, Long, or byte[]: " + m);
            }
            Type t = m.getGenericReturnType();
            if (t instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)t;
                if (pType.getRawType().equals(Set.class)) {
                    Class genericType = (Class)pType.getActualTypeArguments()[0];
                    if (String.class.equals((Object)genericType)) {
                        return MethodType.SET_STRING_GETTER;
                    }
                    if (Long.class.equals((Object)genericType)) {
                        return MethodType.SET_LONG_GETTER;
                    }
                    if (BigInteger.class.equals((Object)genericType)) {
                        return MethodType.SET_BIG_INT_GETTER;
                    }
                    if (genericType.isArray() && genericType.getComponentType().equals(Byte.TYPE)) {
                        return MethodType.SET_RAW_GETTER;
                    }
                }
            } else {
                Class<?> c = m.getReturnType();
                if (c.equals(String.class)) {
                    return MethodType.STRING_GETTER;
                }
                if (c.equals(Long.class) || c.equals(Long.TYPE)) {
                    return MethodType.LONG_GETTER;
                }
                if (c.equals(BigInteger.class)) {
                    return MethodType.BIG_INT_SETTER;
                }
                if (c.isArray() && c.getComponentType().equals(Byte.TYPE)) {
                    return MethodType.RAW_GETTER;
                }
            }
            throw new IllegalArgumentException("@RiakIndex getter must return a single or Set<> of String, Long, or byte[]: " + m);
        }
        throw new IllegalArgumentException("Method can not be null.");
    }

    public static enum MethodType {
        LONG_SETTER,
        LONG_GETTER,
        SET_LONG_GETTER,
        SET_LONG_SETTER,
        STRING_GETTER,
        STRING_SETTER,
        SET_STRING_GETTER,
        SET_STRING_SETTER,
        RAW_SETTER,
        RAW_GETTER,
        SET_RAW_SETTER,
        SET_RAW_GETTER,
        BIG_INT_SETTER,
        BIG_INT_GETTER,
        SET_BIG_INT_GETTER,
        SET_BIG_INT_SETTER;

    }
}

