/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert.reflection;

import com.basho.riak.client.api.annotations.RiakBucketName;
import com.basho.riak.client.api.annotations.RiakBucketType;
import com.basho.riak.client.api.annotations.RiakContentType;
import com.basho.riak.client.api.annotations.RiakIndex;
import com.basho.riak.client.api.annotations.RiakKey;
import com.basho.riak.client.api.annotations.RiakLastModified;
import com.basho.riak.client.api.annotations.RiakLinks;
import com.basho.riak.client.api.annotations.RiakTombstone;
import com.basho.riak.client.api.annotations.RiakUsermeta;
import com.basho.riak.client.api.annotations.RiakVClock;
import com.basho.riak.client.api.annotations.RiakVTag;
import com.basho.riak.client.api.convert.reflection.AnnotationInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.concurrent.Callable;

public class AnnotationScanner
implements Callable<AnnotationInfo> {
    private final Class classToScan;

    public AnnotationScanner(Class clazz) {
        this.classToScan = clazz;
    }

    @Override
    public AnnotationInfo call() throws Exception {
        AnnotationInfo.Builder builder = new AnnotationInfo.Builder();
        LinkedList classList = new LinkedList();
        for (Class currentClass = this.classToScan; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            classList.addFirst(currentClass);
        }
        for (Class clazz : classList) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(RiakKey.class)) {
                    builder.withRiakKeyField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakVClock.class)) {
                    builder.withRiakVClockField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakTombstone.class)) {
                    builder.withRiakTombstoneField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakUsermeta.class)) {
                    builder.addRiakUsermetaField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakIndex.class)) {
                    builder.addRiakIndexField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakLinks.class)) {
                    builder.withRiakLinksField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakContentType.class)) {
                    builder.withRiakContentTypeField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakLastModified.class)) {
                    builder.withRiakLastModifiedField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakVTag.class)) {
                    builder.withRiakVTagField(field);
                    continue;
                }
                if (field.isAnnotationPresent(RiakBucketName.class)) {
                    builder.withRiakBucketNameField(field);
                    continue;
                }
                if (!field.isAnnotationPresent(RiakBucketType.class)) continue;
                builder.withRiakBucketTypeField(field);
            }
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(RiakKey.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakKeySetter(method);
                        continue;
                    }
                    builder.withRiakKeyGetter(method);
                    continue;
                }
                if (method.isAnnotationPresent(RiakBucketName.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakBucketNameSetter(method);
                        continue;
                    }
                    builder.withRiakBucketNameGetter(method);
                    continue;
                }
                if (method.isAnnotationPresent(RiakBucketType.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakBucketTypeSetter(method);
                        continue;
                    }
                    builder.withRiakBucketTypeGetter(method);
                    continue;
                }
                if (method.isAnnotationPresent(RiakLinks.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakLinksSetter(method);
                        continue;
                    }
                    builder.withRiakLinksGetter(method);
                    continue;
                }
                if (method.isAnnotationPresent(RiakVClock.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakVClockSetter(method);
                        continue;
                    }
                    builder.withRiakVClockGetter(method);
                    continue;
                }
                if (method.isAnnotationPresent(RiakTombstone.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakTombstoneSetter(method);
                        continue;
                    }
                    builder.withRiakTombstoneGetter(method);
                    continue;
                }
                if (method.isAnnotationPresent(RiakContentType.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakContentTypeSetter(method);
                        continue;
                    }
                    builder.withRiakContentTypeGetter(method);
                    continue;
                }
                if (method.isAnnotationPresent(RiakVTag.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakVTagSetter(method);
                        continue;
                    }
                    throw new IllegalArgumentException("@RiakVTag annotated getter not supported");
                }
                if (method.isAnnotationPresent(RiakLastModified.class)) {
                    if (this.isSetter(method)) {
                        builder.withRiakLastModifiedSetter(method);
                        continue;
                    }
                    throw new IllegalArgumentException("@RiakLastModified annotated getter not supported");
                }
                if (method.isAnnotationPresent(RiakIndex.class)) {
                    builder.addRiakIndexMethod(method);
                    continue;
                }
                if (!method.isAnnotationPresent(RiakUsermeta.class)) continue;
                builder.addRiakUsermetaMethod(method);
            }
        }
        return builder.build();
    }

    private boolean isSetter(Method m) {
        return m.getReturnType().equals(Void.TYPE);
    }
}

