/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.timeseries;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.ts.ListKeysOperation;
import com.basho.riak.client.core.query.timeseries.QueryResult;

public class ListKeys
extends RiakCommand<QueryResult, String> {
    private final String tableName;
    private final int timeout;

    private ListKeys(Builder builder) {
        this.tableName = builder.tableName;
        this.timeout = builder.timeout;
    }

    @Override
    protected RiakFuture<QueryResult, String> executeAsync(RiakCluster cluster) {
        RiakFuture<QueryResult, String> coreFuture = cluster.execute(this.buildCoreOperation());
        CoreFutureAdapter<QueryResult, String, QueryResult, String> future = new CoreFutureAdapter<QueryResult, String, QueryResult, String>(coreFuture){

            @Override
            protected QueryResult convertResponse(QueryResult coreResponse) {
                return coreResponse;
            }

            @Override
            protected String convertQueryInfo(String coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<QueryResult, String>)future);
        return future;
    }

    private ListKeysOperation buildCoreOperation() {
        ListKeysOperation.Builder builder = new ListKeysOperation.Builder(this.tableName);
        if (this.timeout > 0) {
            builder.withTimeout(this.timeout);
        }
        return builder.build();
    }

    public static class Builder {
        private final String tableName;
        private int timeout;

        public Builder(String tableName) {
            this.tableName = tableName;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ListKeys build() {
            return new ListKeys(this);
        }
    }
}

