/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.search;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.RiakOption;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.SearchOperation;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Search
extends RiakCommand<SearchOperation.Response, BinaryValue> {
    private final String index;
    private final String query;
    private final int start;
    private final int rows;
    private final Presort presort;
    private final String filterQuery;
    private final String sortField;
    private final List<String> returnFields;
    private final Map<Option<?>, Object> options = new HashMap();

    public Search(Builder builder) {
        this.index = builder.index;
        this.query = builder.query;
        this.start = builder.start;
        this.rows = builder.rows;
        this.presort = builder.presort;
        this.filterQuery = builder.filterQuery;
        this.sortField = builder.sortField;
        this.returnFields = builder.returnFields;
        this.options.putAll(builder.options);
    }

    @Override
    protected RiakFuture<SearchOperation.Response, BinaryValue> executeAsync(RiakCluster cluster) {
        RiakFuture<SearchOperation.Response, BinaryValue> coreFuture = cluster.execute(this.buildCoreOperation());
        CoreFutureAdapter<SearchOperation.Response, BinaryValue, SearchOperation.Response, BinaryValue> future = new CoreFutureAdapter<SearchOperation.Response, BinaryValue, SearchOperation.Response, BinaryValue>(coreFuture){

            @Override
            protected SearchOperation.Response convertResponse(SearchOperation.Response coreResponse) {
                return coreResponse;
            }

            @Override
            protected BinaryValue convertQueryInfo(BinaryValue coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<SearchOperation.Response, BinaryValue>)future);
        return future;
    }

    private SearchOperation buildCoreOperation() {
        SearchOperation.Builder builder = new SearchOperation.Builder(BinaryValue.create(this.index), this.query);
        for (Map.Entry<Option<?>, Object> option : this.options.entrySet()) {
            if (option.getKey() == Option.DEFAULT_FIELD) {
                builder.withDefaultField((String)option.getValue());
                continue;
            }
            if (option.getKey() != Option.DEFAULT_OPERATION) continue;
            Option.Operation op = (Option.Operation)((Object)option.getValue());
            builder.withDefaultOperation(op.opStr);
        }
        if (this.start >= 0) {
            builder.withStart(this.start);
        }
        if (this.rows >= 0) {
            builder.withNumRows(this.rows);
        }
        if (this.presort != null) {
            builder.withPresort(this.presort.sortStr);
        }
        if (this.filterQuery != null) {
            builder.withFilterQuery(this.filterQuery);
        }
        if (this.sortField != null) {
            builder.withSortField(this.sortField);
        }
        if (this.returnFields != null) {
            builder.withReturnFields(this.returnFields);
        }
        return builder.build();
    }

    public static class Builder {
        private final String index;
        private final String query;
        private int start = -1;
        private int rows = -1;
        private Presort presort;
        private String filterQuery;
        private String sortField;
        private List<String> returnFields;
        private Map<Option<?>, Object> options = new HashMap();

        public Builder(String index, String query) {
            this.index = index;
            this.query = query;
        }

        public Builder withPresort(Presort presort) {
            this.presort = presort;
            return this;
        }

        public Builder withStart(int start) {
            this.start = start;
            return this;
        }

        public Builder withRows(int rows) {
            this.rows = rows;
            return this;
        }

        public <T> Builder withOption(Option<T> option, T value) {
            this.options.put(option, value);
            return this;
        }

        public Builder filter(String query) {
            this.filterQuery = query;
            return this;
        }

        public Builder sort(String field) {
            this.sortField = field;
            return this;
        }

        public Builder returnFields(Iterable<String> fields) {
            this.returnFields = new ArrayList<String>();
            for (String field : fields) {
                this.returnFields.add(field);
            }
            return this;
        }

        public Builder returnFields(String ... fields) {
            this.returnFields(Arrays.asList(fields));
            return this;
        }

        public Search build() {
            return new Search(this);
        }
    }

    public static final class Option<T>
    extends RiakOption<T> {
        public static Option<Operation> DEFAULT_OPERATION = new Option("DEFAULT_OPERATION");
        public static Option<String> DEFAULT_FIELD = new Option("DEFAULT_FIELD");

        private Option(String name) {
            super(name);
        }

        public static enum Operation {
            AND("and"),
            OR("or");

            final String opStr;

            private Operation(String opStr) {
                this.opStr = opStr;
            }
        }
    }

    public static enum Presort {
        KEY("key"),
        SCORE("score");

        final String sortStr;

        private Presort(String sortStr) {
            this.sortStr = sortStr;
        }
    }
}

