/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.cap.ConflictResolver;
import com.basho.riak.client.api.cap.ConflictResolverFactory;
import com.basho.riak.client.api.cap.UnresolvedConflictException;
import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.api.convert.Converter;
import com.basho.riak.client.api.convert.ConverterFactory;
import com.basho.riak.client.api.convert.reflection.AnnotationUtil;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.RiakObject;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;

abstract class KvResponseBase {
    private final Location location;
    private final List<RiakObject> values;

    protected KvResponseBase(Init<?> builder) {
        this.location = ((Init)builder).location;
        this.values = ((Init)builder).values;
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public int getNumberOfValues() {
        return this.values.size();
    }

    public List<RiakObject> getValues() {
        return this.values;
    }

    public VClock getVectorClock() {
        if (this.hasValues()) {
            return this.values.get(0).getVClock();
        }
        return null;
    }

    public <T> List<T> getValues(Class<T> clazz) {
        Converter converter = ConverterFactory.getInstance().getConverter(clazz);
        return this.convertValues(converter);
    }

    public <T> List<T> getValues(Converter<T> converter) {
        return this.convertValues(converter);
    }

    public <T> T getValue(Converter<T> converter, ConflictResolver<T> resolver) throws UnresolvedConflictException {
        List<T> convertedValues = this.convertValues(converter);
        T resolved = resolver.resolve(convertedValues);
        if (this.hasValues() && resolved != null) {
            VClock vclock = this.values.get(0).getVClock();
            AnnotationUtil.setVClock(resolved, vclock);
        }
        return resolved;
    }

    public <T> T getValue(Class<T> clazz) throws UnresolvedConflictException {
        Converter converter = ConverterFactory.getInstance().getConverter(clazz);
        List convertedValues = this.convertValues(converter);
        ConflictResolver resolver = ConflictResolverFactory.getInstance().getConflictResolver(clazz);
        T resolved = resolver.resolve(convertedValues);
        if (this.hasValues() && resolved != null) {
            VClock vclock = this.values.get(0).getVClock();
            AnnotationUtil.setVClock(resolved, vclock);
        }
        return resolved;
    }

    public <T> T getValue(TypeReference<T> typeReference) throws UnresolvedConflictException {
        Converter<T> converter = ConverterFactory.getInstance().getConverter(typeReference);
        List<T> convertedValues = this.convertValues(converter);
        ConflictResolver<T> resolver = ConflictResolverFactory.getInstance().getConflictResolver(typeReference);
        T resolved = resolver.resolve(convertedValues);
        if (this.hasValues() && resolved != null) {
            VClock vclock = this.values.get(0).getVClock();
            AnnotationUtil.setVClock(resolved, vclock);
        }
        return resolved;
    }

    public <T> List<T> getValues(TypeReference<T> typeReference) {
        Converter<T> converter = ConverterFactory.getInstance().getConverter(typeReference);
        return this.convertValues(converter);
    }

    private <T> List<T> convertValues(Converter<T> converter) {
        ArrayList<T> convertedValues = new ArrayList<T>(this.values.size());
        for (RiakObject ro : this.values) {
            convertedValues.add(converter.toDomain(ro, this.location));
        }
        return convertedValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KvResponseBase)) {
            return false;
        }
        KvResponseBase other = (KvResponseBase)obj;
        if (!(this.location == other.location || this.location != null && this.location.equals(other.location))) {
            return false;
        }
        return this.values == other.values || this.values != null && this.values.equals(other.values);
    }

    public String toString() {
        return String.format("{location: %s, values: %s}", this.location, this.values);
    }

    protected static abstract class Init<T extends Init<T>> {
        private Location location;
        private List<RiakObject> values = new ArrayList<RiakObject>();

        protected Init() {
        }

        protected abstract T self();

        abstract KvResponseBase build();

        T withLocation(Location location) {
            this.location = location;
            return this.self();
        }

        T withValues(List<RiakObject> values) {
            this.values.addAll(values);
            return this.self();
        }
    }
}

