/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.indexes.SecondaryIndexQuery;
import com.basho.riak.client.api.commands.kv.FetchValue;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.FetchOperation;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.List;
import shaded.com.google.protobuf.ByteString;

public class FullBucketRead
extends SecondaryIndexQuery<BinaryValue, Response, FullBucketRead> {
    private final SecondaryIndexQuery.IndexConverter<BinaryValue> converter = new SecondaryIndexQuery.IndexConverter<BinaryValue>(){

        @Override
        public BinaryValue convert(BinaryValue input) {
            return input;
        }
    };

    protected FullBucketRead(Builder builder) {
        super(builder.get2iBuilder());
    }

    @Override
    protected SecondaryIndexQuery.IndexConverter<BinaryValue> getConverter() {
        return this.converter;
    }

    @Override
    protected RiakFuture<Response, FullBucketRead> executeAsync(RiakCluster cluster) {
        RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture = this.executeCoreAsync(cluster);
        RawQueryFuture future = new RawQueryFuture(coreFuture);
        coreFuture.addListener(future);
        return future;
    }

    public static class Response
    extends SecondaryIndexQuery.Response<BinaryValue> {
        private transient List<Entry> convertedList = null;

        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, SecondaryIndexQuery.IndexConverter<BinaryValue> converter) {
            super(queryLocation, coreResponse, converter);
        }

        @Override
        public List<Entry> getEntries() {
            if (this.convertedList != null) {
                return this.convertedList;
            }
            this.convertedList = new ArrayList<Entry>(this.coreResponse.getEntryList().size());
            for (SecondaryIndexQueryOperation.Response.Entry e : this.coreResponse.getEntryList()) {
                FetchValue.Response fr;
                Location loc = this.getLocationFromCoreEntry(e);
                if (e.hasBody()) {
                    FetchOperation.Response resp = e.getBody();
                    fr = ((FetchValue.Response.Builder)((FetchValue.Response.Builder)((FetchValue.Response.Builder)((FetchValue.Response.Builder)new FetchValue.Response.Builder().withNotFound(resp.isNotFound())).withUnchanged(resp.isUnchanged())).withValues(resp.getObjectList())).withLocation(loc)).build();
                } else {
                    fr = null;
                }
                Entry ce = new Entry(loc, fr);
                this.convertedList.add(ce);
            }
            return this.convertedList;
        }

        public static class Entry {
            private final FetchValue.Response fetchedValue;
            private final Location location;

            public Entry(Location location) {
                this(location, null);
            }

            public Entry(Location location, FetchValue.Response fetchedResponse) {
                this.fetchedValue = fetchedResponse;
                this.location = location;
            }

            public boolean hasFetchedValue() {
                return this.fetchedValue != null;
            }

            public FetchValue.Response getFetchedValue() {
                return this.fetchedValue;
            }

            public Location getLocation() {
                return this.location;
            }

            public String toString() {
                return "FullBucketRead.Response.Entry{location=" + this.location + ", hasFetchedValue=" + this.hasFetchedValue() + '}';
            }
        }
    }

    public static class Builder {
        private final BuilderFullBucketRead2i builder2i;

        public Builder(Namespace namespace) {
            this.builder2i = new BuilderFullBucketRead2i(namespace);
        }

        public Builder(Namespace namespace, byte[] coverageContext) {
            this.builder2i = new BuilderFullBucketRead2i(namespace, coverageContext);
        }

        private BuilderFullBucketRead2i get2iBuilder() {
            return this.builder2i;
        }

        public Builder withReturnBody(boolean returnBody) {
            this.builder2i.withReturnBody(returnBody);
            return this.self();
        }

        public Builder withContinuation(BinaryValue continuation) {
            this.builder2i.withContinuation(continuation);
            return this.self();
        }

        public Builder withMaxResults(Integer maxResults) {
            this.builder2i.withMaxResults(maxResults);
            return this.self();
        }

        public Builder withPaginationSort(boolean orderByKey) {
            this.builder2i.withPaginationSort(orderByKey);
            return this.self();
        }

        protected Builder self() {
            return this;
        }

        public FullBucketRead build() {
            return new FullBucketRead(this);
        }

        private static class BuilderFullBucketRead2i
        extends SecondaryIndexQuery.Init<BinaryValue, BuilderFullBucketRead2i> {
            public BuilderFullBucketRead2i(Namespace namespace) {
                super(namespace, "$bucket", BinaryValue.create(ByteString.EMPTY.toByteArray()));
            }

            public BuilderFullBucketRead2i(Namespace namespace, byte[] coverageContext) {
                super(namespace, "$bucket", coverageContext);
            }

            @Override
            protected BuilderFullBucketRead2i self() {
                return this;
            }

            @Override
            public BuilderFullBucketRead2i withReturnBody(boolean returnBody) {
                return (BuilderFullBucketRead2i)super.withReturnBody(returnBody);
            }
        }
    }

    protected final class RawQueryFuture
    extends CoreFutureAdapter<Response, FullBucketRead, SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> {
        public RawQueryFuture(RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            super(coreFuture);
        }

        @Override
        protected Response convertResponse(SecondaryIndexQueryOperation.Response coreResponse) {
            return new Response(FullBucketRead.this.namespace, coreResponse, FullBucketRead.this.converter);
        }

        @Override
        protected FullBucketRead convertQueryInfo(SecondaryIndexQueryOperation.Query coreQueryInfo) {
            return FullBucketRead.this;
        }
    }
}

