/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.indexes.SecondaryIndexQuery;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.DefaultCharset;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class BinIndexQuery
extends SecondaryIndexQuery<String, Response, BinIndexQuery> {
    private final Charset charset;
    private final SecondaryIndexQuery.IndexConverter<String> converter;

    protected BinIndexQuery(Init<String, ?> builder) {
        super(builder);
        this.charset = ((Init)builder).charset;
        this.converter = new SecondaryIndexQuery.IndexConverter<String>(){

            @Override
            public String convert(BinaryValue input) {
                return input.toString(BinIndexQuery.this.charset);
            }

            @Override
            public BinaryValue convert(String input) {
                if (input == null) {
                    return null;
                }
                return BinaryValue.create(input, BinIndexQuery.this.charset);
            }
        };
    }

    @Override
    protected SecondaryIndexQuery.IndexConverter<String> getConverter() {
        return this.converter;
    }

    @Override
    protected RiakFuture<Response, BinIndexQuery> executeAsync(RiakCluster cluster) {
        RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture = this.executeCoreAsync(cluster);
        BinQueryFuture future = new BinQueryFuture(coreFuture);
        coreFuture.addListener(future);
        return future;
    }

    public static class Response
    extends SecondaryIndexQuery.Response<String> {
        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, SecondaryIndexQuery.IndexConverter<String> converter) {
            super(queryLocation, coreResponse, converter);
        }

        @Override
        public List<Entry> getEntries() {
            ArrayList<Entry> convertedList = new ArrayList<Entry>();
            for (SecondaryIndexQueryOperation.Response.Entry e : this.coreResponse.getEntryList()) {
                Location loc = this.getLocationFromCoreEntry(e);
                Entry ce = new Entry(loc, e.getIndexKey(), this.converter);
                convertedList.add(ce);
            }
            return convertedList;
        }

        public class Entry
        extends SecondaryIndexQuery.Response.Entry<String> {
            protected Entry(Location riakObjectLocation, BinaryValue indexKey, SecondaryIndexQuery.IndexConverter<String> converter) {
                super(riakObjectLocation, indexKey, converter);
            }
        }
    }

    public static class Builder
    extends Init<String, Builder> {
        public Builder(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName, coverContext);
        }

        public Builder(Namespace namespace, String indexName, String start, String end) {
            super(namespace, indexName, start, end);
        }

        public Builder(Namespace namespace, String indexName, String match) {
            super(namespace, indexName, match);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public BinIndexQuery build() {
            return new BinIndexQuery(this);
        }
    }

    protected static abstract class Init<S, T extends Init<S, T>>
    extends SecondaryIndexQuery.Init<S, T> {
        private Charset charset = DefaultCharset.get();

        public Init(Namespace namespace, String indexName, S start, S end) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._BIN), start, end);
        }

        public Init(Namespace namespace, String indexName, S match) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._BIN), match);
        }

        public Init(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._BIN), coverContext);
        }

        T withCharacterSet(Charset charset) {
            this.charset = charset;
            return (T)((Init)this.self());
        }
    }

    protected final class BinQueryFuture
    extends CoreFutureAdapter<Response, BinIndexQuery, SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> {
        public BinQueryFuture(RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            super(coreFuture);
        }

        @Override
        protected Response convertResponse(SecondaryIndexQueryOperation.Response coreResponse) {
            return new Response(BinIndexQuery.this.namespace, coreResponse, BinIndexQuery.this.converter);
        }

        @Override
        protected BinIndexQuery convertQueryInfo(SecondaryIndexQueryOperation.Query coreQueryInfo) {
            return BinIndexQuery.this;
        }
    }
}

