/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.indexes.SecondaryIndexQuery;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BigIntIndexQuery
extends SecondaryIndexQuery<BigInteger, Response, BigIntIndexQuery> {
    private final SecondaryIndexQuery.IndexConverter<BigInteger> converter = new SecondaryIndexQuery.IndexConverter<BigInteger>(){

        @Override
        public BigInteger convert(BinaryValue input) {
            return new BigInteger(input.toStringUtf8());
        }

        @Override
        public BinaryValue convert(BigInteger input) {
            if (input == null) {
                return null;
            }
            return BinaryValue.createFromUtf8(input.toString());
        }
    };

    @Override
    protected SecondaryIndexQuery.IndexConverter<BigInteger> getConverter() {
        return this.converter;
    }

    protected BigIntIndexQuery(Init<BigInteger, ?> builder) {
        super(builder);
    }

    @Override
    protected RiakFuture<Response, BigIntIndexQuery> executeAsync(RiakCluster cluster) {
        RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture = this.executeCoreAsync(cluster);
        BigIntQueryFuture future = new BigIntQueryFuture(coreFuture);
        coreFuture.addListener(future);
        return future;
    }

    public static class Response
    extends SecondaryIndexQuery.Response<BigInteger> {
        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, SecondaryIndexQuery.IndexConverter<BigInteger> converter) {
            super(queryLocation, coreResponse, converter);
        }

        @Override
        public List<Entry> getEntries() {
            ArrayList<Entry> convertedList = new ArrayList<Entry>();
            for (SecondaryIndexQueryOperation.Response.Entry e : this.coreResponse.getEntryList()) {
                Location loc = this.getLocationFromCoreEntry(e);
                Entry ce = new Entry(loc, e.getIndexKey(), this.converter);
                convertedList.add(ce);
            }
            return convertedList;
        }

        public class Entry
        extends SecondaryIndexQuery.Response.Entry<BigInteger> {
            protected Entry(Location riakObjectLocation, BinaryValue indexKey, SecondaryIndexQuery.IndexConverter<BigInteger> converter) {
                super(riakObjectLocation, indexKey, converter);
            }
        }
    }

    public static class Builder
    extends Init<BigInteger, Builder> {
        public Builder(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName, coverContext);
        }

        public Builder(Namespace namespace, String indexName, BigInteger start, BigInteger end) {
            super(namespace, indexName, start, end);
        }

        public Builder(Namespace namespace, String indexName, BigInteger match) {
            super(namespace, indexName, match);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public BigIntIndexQuery build() {
            return new BigIntIndexQuery(this);
        }
    }

    protected static abstract class Init<S, T extends Init<S, T>>
    extends SecondaryIndexQuery.Init<S, T> {
        public Init(Namespace namespace, String indexName, S start, S end) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), start, end);
        }

        public Init(Namespace namespace, String indexName, S match) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), match);
        }

        public Init(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), coverContext);
        }

        @Override
        public T withRegexTermFilter(String filter) {
            throw new IllegalArgumentException("Cannot use term filter with _int query");
        }
    }

    protected final class BigIntQueryFuture
    extends CoreFutureAdapter<Response, BigIntIndexQuery, SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> {
        public BigIntQueryFuture(RiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            super(coreFuture);
        }

        @Override
        protected Response convertResponse(SecondaryIndexQueryOperation.Response coreResponse) {
            return new Response(BigIntIndexQuery.this.namespace, coreResponse, BigIntIndexQuery.this.converter);
        }

        @Override
        protected BigIntIndexQuery convertQueryInfo(SecondaryIndexQueryOperation.Query coreQueryInfo) {
            return BigIntIndexQuery.this;
        }
    }
}

