/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.datatypes;

import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.api.commands.datatypes.Context;
import com.basho.riak.client.api.commands.datatypes.SetUpdate;
import com.basho.riak.client.api.commands.datatypes.UpdateDatatype;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.DtUpdateOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.crdt.types.RiakDatatype;
import com.basho.riak.client.core.query.crdt.types.RiakSet;
import com.basho.riak.client.core.util.BinaryValue;

public class UpdateSet
extends UpdateDatatype<RiakSet, Response, Location> {
    private final SetUpdate update;

    private UpdateSet(Builder builder) {
        super(builder);
        this.update = builder.update;
    }

    @Override
    protected RiakFuture<Response, Location> executeAsync(RiakCluster cluster) {
        RiakFuture<DtUpdateOperation.Response, Location> coreFuture = cluster.execute(this.buildCoreOperation(this.update));
        CoreFutureAdapter<Response, Location, DtUpdateOperation.Response, Location> future = new CoreFutureAdapter<Response, Location, DtUpdateOperation.Response, Location>(coreFuture){

            @Override
            protected Response convertResponse(DtUpdateOperation.Response coreResponse) {
                RiakSet set = null;
                if (coreResponse.hasCrdtElement()) {
                    RiakDatatype element = coreResponse.getCrdtElement();
                    set = element.getAsSet();
                }
                BinaryValue returnedKey = coreResponse.hasGeneratedKey() ? coreResponse.getGeneratedKey() : null;
                Context returnedCtx = null;
                if (coreResponse.hasContext()) {
                    returnedCtx = new Context(coreResponse.getContext());
                }
                return new Response(returnedCtx, set, returnedKey);
            }

            @Override
            protected Location convertQueryInfo(Location coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<DtUpdateOperation.Response, Location>)future);
        return future;
    }

    public static class Response
    extends UpdateDatatype.Response<RiakSet> {
        private Response(Context context, RiakSet datatype, BinaryValue generatedKey) {
            super(context, datatype, generatedKey);
        }
    }

    public static class Builder
    extends UpdateDatatype.Builder<Builder> {
        private final SetUpdate update;

        public Builder(Location location, SetUpdate update) {
            super(location);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
            this.update = update;
        }

        public Builder(Namespace namespace, SetUpdate update) {
            super(namespace);
            if (update == null) {
                throw new IllegalArgumentException("Update cannot be null");
            }
            this.update = update;
        }

        @Override
        public UpdateSet build() {
            return new UpdateSet(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

