/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.buckets;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.ListBucketsOperation;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Iterator;
import java.util.List;

public final class ListBuckets
extends RiakCommand<Response, BinaryValue> {
    private final int timeout;
    private final BinaryValue type;

    ListBuckets(Builder builder) {
        this.timeout = builder.timeout;
        this.type = builder.type;
    }

    @Override
    protected RiakFuture<Response, BinaryValue> executeAsync(RiakCluster cluster) {
        RiakFuture<ListBucketsOperation.Response, BinaryValue> coreFuture = cluster.execute(this.buildCoreOperation());
        CoreFutureAdapter<Response, BinaryValue, ListBucketsOperation.Response, BinaryValue> future = new CoreFutureAdapter<Response, BinaryValue, ListBucketsOperation.Response, BinaryValue>(coreFuture){

            @Override
            protected Response convertResponse(ListBucketsOperation.Response coreResponse) {
                return new Response(ListBuckets.this.type, coreResponse.getBuckets());
            }

            @Override
            protected BinaryValue convertQueryInfo(BinaryValue coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<ListBucketsOperation.Response, BinaryValue>)future);
        return future;
    }

    private ListBucketsOperation buildCoreOperation() {
        ListBucketsOperation.Builder builder = new ListBucketsOperation.Builder();
        if (this.timeout > 0) {
            builder.withTimeout(this.timeout);
        }
        if (this.type != null) {
            builder.withBucketType(this.type);
        }
        return builder.build();
    }

    public static class Builder {
        private int timeout;
        private final BinaryValue type;

        public Builder(String type) {
            this.type = BinaryValue.create(type);
        }

        public Builder(BinaryValue type) {
            this.type = type;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ListBuckets build() {
            return new ListBuckets(this);
        }
    }

    private static class Itr
    implements Iterator<Namespace> {
        private final Iterator<BinaryValue> iterator;
        private final BinaryValue type;

        private Itr(Iterator<BinaryValue> iterator, BinaryValue type) {
            this.iterator = iterator;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Namespace next() {
            BinaryValue bucket = this.iterator.next();
            return new Namespace(this.type, bucket);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    public static class Response
    implements Iterable<Namespace> {
        private final BinaryValue type;
        private final List<BinaryValue> buckets;

        public Response(BinaryValue type, List<BinaryValue> buckets) {
            this.type = type;
            this.buckets = buckets;
        }

        @Override
        public Iterator<Namespace> iterator() {
            return new Itr(this.buckets.iterator(), this.type);
        }
    }
}

