/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands;

import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ListenableFuture<T, S>
implements RiakFuture<T, S> {
    private final Set<RiakFutureListener<T, S>> listeners = new HashSet<RiakFutureListener<T, S>>();
    private final ReentrantLock listenersLock = new ReentrantLock();

    @Override
    public void addListener(RiakFutureListener<T, S> listener) {
        this.listenersLock.lock();
        try {
            if (this.isDone()) {
                listener.handle(this);
            } else {
                this.listeners.add(listener);
            }
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    @Override
    public void removeListener(RiakFutureListener<T, S> listener) {
        this.listenersLock.lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    protected void notifyListeners() {
        this.listenersLock.lock();
        try {
            for (RiakFutureListener<T, S> listener : this.listeners) {
                listener.handle(this);
            }
        }
        finally {
            this.listenersLock.unlock();
        }
    }
}

