/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands;

import com.basho.riak.client.api.commands.ListenableFuture;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class CoreFutureAdapter<T2, S2, T, S>
extends ListenableFuture<T2, S2>
implements RiakFutureListener<T, S> {
    private final RiakFuture<T, S> coreFuture;

    public CoreFutureAdapter(RiakFuture<T, S> coreFuture) {
        this.coreFuture = coreFuture;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.coreFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public T2 get() throws InterruptedException, ExecutionException {
        return this.convertResponse(this.coreFuture.get());
    }

    @Override
    public T2 get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        T response = this.coreFuture.get(timeout, unit);
        return this.convertResponse(response);
    }

    @Override
    public T2 getNow() {
        if (this.coreFuture.isDone()) {
            return this.convertResponse(this.coreFuture.getNow());
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.coreFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.coreFuture.isDone();
    }

    @Override
    public void await() throws InterruptedException {
        this.coreFuture.await();
    }

    @Override
    public void await(long timeout, TimeUnit unit) throws InterruptedException {
        this.coreFuture.await(timeout, unit);
    }

    @Override
    public boolean isSuccess() {
        return this.coreFuture.isSuccess();
    }

    @Override
    public Throwable cause() {
        return this.coreFuture.cause();
    }

    @Override
    public S2 getQueryInfo() {
        return this.convertQueryInfo(this.coreFuture.getQueryInfo());
    }

    @Override
    public void handle(RiakFuture<T, S> f) {
        this.notifyListeners();
    }

    protected abstract T2 convertResponse(T var1);

    protected abstract S2 convertQueryInfo(S var1);
}

