/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.acu.pie.util;

import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeParser {
    private static final Logger log = LoggerFactory.getLogger(DateTimeParser.class);

    public static String toUTCString(DateTime dateTime) {
        return dateTime.toString("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public static LocalTime parseLocalTime(String time) {
        String toBeParsed = time.matches("\\d{2}:\\d{2}\\.\\d") ? "00:" + time + "00" : (time.matches("\\d{2}:\\d{2}\\.\\d{2}") ? "00:" + time + "0" : (time.matches("\\d{2}:\\d{2}\\.\\d{3}") ? "00:" + time : (time.matches("\\d{2}:\\d{2}:\\d{2}\\.\\d") ? time + "00" : (time.matches("\\d{2}:\\d{2}:\\d{2}\\.\\d{2}") ? time + "0" : time))));
        DateTimeFormatter asrRecognitionResultTimeFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS");
        LocalTime ret = LocalTime.MIDNIGHT;
        try {
            ret = LocalTime.parse((String)toBeParsed, (DateTimeFormatter)asrRecognitionResultTimeFormatter);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            log.warn("parse time failed, the time string from asr sdk is : {}, exception: ", (Object)time, (Object)e);
        }
        return ret;
    }
}

