/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.acu.pie.model;

import com.baidu.acu.pie.AudioStreaming;
import com.baidu.acu.pie.client.Consumer;
import com.baidu.acu.pie.exception.AsrException;
import com.baidu.acu.pie.model.FinishLatch;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;

public class StreamContext
implements FinishLatch {
    private FinishLatch finishLatch;
    private StreamObserver<AudioStreaming.AudioFragmentRequest> sender;
    private int fragmentSize;

    public void send(byte[] data) {
        int i = 0;
        while (i * this.fragmentSize < data.length) {
            this.sender.onNext((Object)AudioStreaming.AudioFragmentRequest.newBuilder().setAudioData(ByteString.copyFrom((byte[])data, (int)(i * this.fragmentSize), (int)Math.min(this.fragmentSize, data.length - i * this.fragmentSize))).build());
            ++i;
        }
    }

    public void complete() {
        this.sender.onCompleted();
    }

    StreamContext(FinishLatch finishLatch, StreamObserver<AudioStreaming.AudioFragmentRequest> sender, int fragmentSize) {
        this.finishLatch = finishLatch;
        this.sender = sender;
        this.fragmentSize = fragmentSize;
    }

    public static StreamContextBuilder builder() {
        return new StreamContextBuilder();
    }

    public FinishLatch getFinishLatch() {
        return this.finishLatch;
    }

    public StreamObserver<AudioStreaming.AudioFragmentRequest> getSender() {
        return this.sender;
    }

    public int getFragmentSize() {
        return this.fragmentSize;
    }

    @Override
    public boolean await() throws AsrException, InterruptedException {
        return this.getFinishLatch().await();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws AsrException, InterruptedException {
        return this.getFinishLatch().await(timeout, unit);
    }

    @Override
    public boolean finished() throws AsrException {
        return this.getFinishLatch().finished();
    }

    @Override
    public void enableCallback(Consumer<AsrException> callback) {
        this.getFinishLatch().enableCallback(callback);
    }

    public static class StreamContextBuilder {
        private FinishLatch finishLatch;
        private StreamObserver<AudioStreaming.AudioFragmentRequest> sender;
        private int fragmentSize;

        StreamContextBuilder() {
        }

        public StreamContextBuilder finishLatch(FinishLatch finishLatch) {
            this.finishLatch = finishLatch;
            return this;
        }

        public StreamContextBuilder sender(StreamObserver<AudioStreaming.AudioFragmentRequest> sender) {
            this.sender = sender;
            return this;
        }

        public StreamContextBuilder fragmentSize(int fragmentSize) {
            this.fragmentSize = fragmentSize;
            return this;
        }

        public StreamContext build() {
            return new StreamContext(this.finishLatch, this.sender, this.fragmentSize);
        }

        public String toString() {
            return "StreamContext.StreamContextBuilder(finishLatch=" + this.finishLatch + ", sender=" + this.sender + ", fragmentSize=" + this.fragmentSize + ")";
        }
    }
}

