/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.acu.pie.model;

import com.baidu.acu.pie.exception.AsrClientException;

public class RequestMetaData {
    public static final RequestMetaData requestMetaDataForShortRecognize = new RequestMetaData();
    private boolean enableFlushData = true;
    private double sendPerSeconds = 0.02;
    private double sendPackageRatio = 1.0;
    private double sleepRatio = 1.0;
    private int timeoutMinutes = 10;
    private String extraInfo = "";

    public void setTimeoutMinutes(int timeoutMinutes) {
        if (timeoutMinutes > 120) {
            throw new AsrClientException("timeoutMinutes should not exceed 120");
        }
        this.timeoutMinutes = timeoutMinutes;
    }

    @Deprecated
    public RequestMetaData enableFlushData(boolean enableFlushData) {
        this.enableFlushData = enableFlushData;
        return this;
    }

    @Deprecated
    public RequestMetaData sendPerSeconds(double sendPerSeconds) {
        this.sendPerSeconds = sendPerSeconds;
        return this;
    }

    @Deprecated
    public RequestMetaData sendPackageRatio(double sendPackageRatio) {
        this.sendPackageRatio = sendPackageRatio;
        return this;
    }

    @Deprecated
    public RequestMetaData sleepRatio(double sleepRatio) {
        this.sleepRatio = sleepRatio;
        return this;
    }

    @Deprecated
    public RequestMetaData timeoutMinutes(int timeoutMinutes) {
        if (timeoutMinutes > 120) {
            throw new AsrClientException("timeoutMinutes should not exceed 120");
        }
        this.timeoutMinutes = timeoutMinutes;
        return this;
    }

    public boolean isEnableFlushData() {
        return this.enableFlushData;
    }

    public double getSendPerSeconds() {
        return this.sendPerSeconds;
    }

    public double getSendPackageRatio() {
        return this.sendPackageRatio;
    }

    public double getSleepRatio() {
        return this.sleepRatio;
    }

    public int getTimeoutMinutes() {
        return this.timeoutMinutes;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setEnableFlushData(boolean enableFlushData) {
        this.enableFlushData = enableFlushData;
    }

    public void setSendPerSeconds(double sendPerSeconds) {
        this.sendPerSeconds = sendPerSeconds;
    }

    public void setSendPackageRatio(double sendPackageRatio) {
        this.sendPackageRatio = sendPackageRatio;
    }

    public void setSleepRatio(double sleepRatio) {
        this.sleepRatio = sleepRatio;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestMetaData)) {
            return false;
        }
        RequestMetaData other = (RequestMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableFlushData() != other.isEnableFlushData()) {
            return false;
        }
        if (Double.compare(this.getSendPerSeconds(), other.getSendPerSeconds()) != 0) {
            return false;
        }
        if (Double.compare(this.getSendPackageRatio(), other.getSendPackageRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getSleepRatio(), other.getSleepRatio()) != 0) {
            return false;
        }
        if (this.getTimeoutMinutes() != other.getTimeoutMinutes()) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableFlushData() ? 79 : 97);
        long $sendPerSeconds = Double.doubleToLongBits(this.getSendPerSeconds());
        result = result * 59 + (int)($sendPerSeconds >>> 32 ^ $sendPerSeconds);
        long $sendPackageRatio = Double.doubleToLongBits(this.getSendPackageRatio());
        result = result * 59 + (int)($sendPackageRatio >>> 32 ^ $sendPackageRatio);
        long $sleepRatio = Double.doubleToLongBits(this.getSleepRatio());
        result = result * 59 + (int)($sleepRatio >>> 32 ^ $sleepRatio);
        result = result * 59 + this.getTimeoutMinutes();
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    public String toString() {
        return "RequestMetaData(enableFlushData=" + this.isEnableFlushData() + ", sendPerSeconds=" + this.getSendPerSeconds() + ", sendPackageRatio=" + this.getSendPackageRatio() + ", sleepRatio=" + this.getSleepRatio() + ", timeoutMinutes=" + this.getTimeoutMinutes() + ", extraInfo=" + this.getExtraInfo() + ")";
    }

    public RequestMetaData() {
    }

    public RequestMetaData(boolean enableFlushData, double sendPerSeconds, double sendPackageRatio, double sleepRatio, int timeoutMinutes, String extraInfo) {
        this.enableFlushData = enableFlushData;
        this.sendPerSeconds = sendPerSeconds;
        this.sendPackageRatio = sendPackageRatio;
        this.sleepRatio = sleepRatio;
        this.timeoutMinutes = timeoutMinutes;
        this.extraInfo = extraInfo;
    }

    static {
        requestMetaDataForShortRecognize.setSendPackageRatio(1.0);
        requestMetaDataForShortRecognize.setSleepRatio(0.0);
        requestMetaDataForShortRecognize.setTimeoutMinutes(2);
        requestMetaDataForShortRecognize.setEnableFlushData(false);
    }
}

