/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.acu.pie.model;

import com.baidu.acu.pie.client.Consumer;
import com.baidu.acu.pie.exception.AsrException;
import com.baidu.acu.pie.model.FinishLatch;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinishLatchImpl
implements FinishLatch {
    private static final Logger log = LoggerFactory.getLogger(FinishLatchImpl.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private transient AsrException throwable;
    private Consumer<AsrException> callback;

    @Override
    public boolean await() throws AsrException, InterruptedException {
        return this.await(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws AsrException, InterruptedException {
        boolean result = this.latch.await(timeout, unit);
        if (this.throwable != null) {
            throw this.throwable;
        }
        return result;
    }

    @Override
    public boolean finished() throws AsrException {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.latch.getCount() == 0L;
    }

    @Override
    public void enableCallback(Consumer<AsrException> callback) {
        this.callback = callback;
    }

    public void finish() {
        this.latch.countDown();
        if (this.callback != null) {
            this.callback.accept(this.throwable);
        }
    }

    public void fail(AsrException throwable) {
        this.throwable = throwable;
        this.finish();
        log.error("Failed and finish");
    }
}

