/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.b2c;

import com.azure.spring.aad.AADAuthorizationGrantType;
import com.azure.spring.autoconfigure.b2c.AADB2CClientRegistrationRepository;
import com.azure.spring.autoconfigure.b2c.AADB2CConditions;
import com.azure.spring.autoconfigure.b2c.AADB2CProperties;
import com.azure.spring.autoconfigure.b2c.AADB2CURL;
import com.azure.spring.autoconfigure.b2c.AuthorizationClientProperties;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

@Configuration
@ConditionalOnResource(resources={"classpath:aadb2c.enable.config"})
@Conditional(value={AADB2CConditions.CommonCondition.class, AADB2CConditions.ClientRegistrationCondition.class})
@EnableConfigurationProperties(value={AADB2CProperties.class})
@ConditionalOnClass(value={OAuth2LoginAuthenticationFilter.class})
public class AADB2COAuth2ClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADB2COAuth2ClientConfiguration.class);
    private final AADB2CProperties properties;

    public AADB2COAuth2ClientConfiguration(@NonNull AADB2CProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientRegistrationRepository clientRegistrationRepository() {
        ArrayList<ClientRegistration> clientRegistrations = new ArrayList<ClientRegistration>();
        clientRegistrations.addAll(this.properties.getUserFlows().entrySet().stream().map(this::buildUserFlowClientRegistration).collect(Collectors.toList()));
        clientRegistrations.addAll(this.properties.getAuthorizationClients().entrySet().stream().map(this::buildClientRegistration).collect(Collectors.toList()));
        return new AADB2CClientRegistrationRepository(this.properties.getLoginFlow(), clientRegistrations);
    }

    private ClientRegistration buildUserFlowClientRegistration(Map.Entry<String, String> client) {
        return ClientRegistration.withRegistrationId((String)client.getValue()).clientName(client.getKey()).clientId(this.properties.getClientId()).clientSecret(this.properties.getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.properties.getReplyUrl()).scope(new String[]{this.properties.getClientId(), "openid", "offline_access"}).authorizationUri(AADB2CURL.getAuthorizationUrl(this.properties.getBaseUri())).tokenUri(AADB2CURL.getTokenUrl(this.properties.getBaseUri(), client.getValue())).jwkSetUri(AADB2CURL.getJwkSetUrl(this.properties.getBaseUri(), client.getValue())).userNameAttributeName(this.properties.getUserNameAttributeName()).build();
    }

    private ClientRegistration buildClientRegistration(Map.Entry<String, AuthorizationClientProperties> client) {
        AuthorizationGrantType authGrantType = Optional.ofNullable(client.getValue().getAuthorizationGrantType()).map(AADAuthorizationGrantType::getValue).map(AuthorizationGrantType::new).orElse(null);
        if (!AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)authGrantType)) {
            LOGGER.warn("The authorization type of the {} client registration is not supported.", (Object)client.getKey());
        }
        return ClientRegistration.withRegistrationId((String)client.getKey()).clientName(client.getKey()).clientId(this.properties.getClientId()).clientSecret(this.properties.getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.POST).authorizationGrantType(authGrantType).scope(client.getValue().getScopes()).tokenUri(AADB2CURL.getAADTokenUrl(this.properties.getTenantId())).jwkSetUri(AADB2CURL.getAADJwkSetUrl(this.properties.getTenantId())).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clients, OAuth2AuthorizedClientRepository authorizedClients) {
        return new DefaultOAuth2AuthorizedClientManager(clients, authorizedClients);
    }
}

