/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.resourcemanager.loganalytics.fluent.models.ClusterPatchProperties;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.ClusterSku;
import com.azure.resourcemanager.loganalytics.models.Identity;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ClusterPatch {
    @JsonProperty(value="properties")
    private ClusterPatchProperties innerProperties;
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="sku")
    private ClusterSku sku;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    private ClusterPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Identity identity() {
        return this.identity;
    }

    public ClusterPatch withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public ClusterSku sku() {
        return this.sku;
    }

    public ClusterPatch withSku(ClusterSku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ClusterPatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultProperties();
    }

    public ClusterPatch withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    public BillingType billingType() {
        return this.innerProperties() == null ? null : this.innerProperties().billingType();
    }

    public ClusterPatch withBillingType(BillingType billingType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterPatchProperties();
        }
        this.innerProperties().withBillingType(billingType);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

