// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** Represents a single block in a block blob. It describes the block's ID and size. */
@JacksonXmlRootElement(localName = "Block")
@Fluent
public final class Block {
    /*
     * The base64 encoded block ID.
     */
    @JsonProperty(value = "Name", required = true)
    private String name;

    /*
     * The block size in bytes.
     */
    @JsonProperty(value = "Size", required = true)
    private long sizeLong;

    /*
     * The SizeInt property.
     */
    @JsonProperty(value = "SizeInt", required = true)
    private int sizeInt;

    /**
     * Get the name property: The base64 encoded block ID.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The base64 encoded block ID.
     *
     * @param name the name value to set.
     * @return the Block object itself.
     */
    public Block setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the sizeLong property: The block size in bytes.
     *
     * @return the sizeLong value.
     */
    public long getSizeLong() {
        return this.sizeLong;
    }

    /**
     * Set the sizeLong property: The block size in bytes.
     *
     * @param sizeLong the sizeLong value to set.
     * @return the Block object itself.
     */
    public Block setSizeLong(long sizeLong) {
        this.sizeLong = sizeLong;
        return this;
    }

    /**
     * Get the sizeInt property: The SizeInt property.
     *
     * @return the sizeInt value.
     * @deprecated Use {@link #getSizeLong()}
     */
    @Deprecated
    public int getSize() {
        int returnValue = this.sizeInt;
        return (int) this.sizeLong; // return returnValue;
    }

    /**
     * Set the sizeInt property: The SizeInt property.
     *
     * @param sizeInt the sizeInt value to set.
     * @return the Block object itself.
     * @deprecated Use {@link #setSizeLong(long)}
     */
    @Deprecated
    public Block setSize(int sizeInt) {
        this.sizeInt = sizeInt;
        Block returnValue = this;
        return returnValue.setSizeLong((long) sizeInt);
    }
}
