/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableServiceAsyncClient;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.data.tables.TableServiceVersion;
import com.azure.data.tables.implementation.TableUtils;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.models.ListTablesOptions;
import com.azure.data.tables.models.TableItem;
import com.azure.data.tables.models.TableServiceException;
import com.azure.data.tables.models.TableServiceProperties;
import com.azure.data.tables.models.TableServiceStatistics;
import com.azure.data.tables.sas.TableAccountSasSignatureValues;
import java.time.Duration;
import reactor.core.publisher.Mono;

@ServiceClient(builder=TableServiceClientBuilder.class)
public final class TableServiceClient {
    private final TableServiceAsyncClient client;

    TableServiceClient(TableServiceAsyncClient client) {
        this.client = client;
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public String getServiceEndpoint() {
        return this.client.getServiceEndpoint();
    }

    public TableServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public String generateAccountSas(TableAccountSasSignatureValues tableAccountSasSignatureValues) {
        return this.client.generateAccountSas(tableAccountSasSignatureValues);
    }

    public TableClient getTableClient(String tableName) {
        return new TableClient(this.client.getTableClient(tableName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableClient createTable(String tableName) {
        return (TableClient)this.createTableWithResponse(tableName, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableClient> createTableWithResponse(String tableName, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.createTableWithResponse(tableName, context), timeout);
    }

    Mono<Response<TableClient>> createTableWithResponse(String tableName, Context context) {
        context = context == null ? Context.NONE : context;
        TableProperties properties = new TableProperties().setTableName(tableName);
        try {
            return this.client.getImplementation().getTables().createWithResponseAsync(properties, null, ResponseFormat.RETURN_NO_CONTENT, null, context).onErrorMap(TableUtils::mapThrowableToTableServiceException).map(response -> new SimpleResponse((Response)response, (Object)this.getTableClient(tableName)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.client.getLogger(), (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableClient createTableIfNotExists(String tableName) {
        return (TableClient)this.createTableIfNotExistsWithResponse(tableName, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableClient> createTableIfNotExistsWithResponse(String tableName, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.createTableIfNotExistsWithResponse(tableName, context), timeout);
    }

    Mono<Response<TableClient>> createTableIfNotExistsWithResponse(String tableName, Context context) {
        return this.createTableWithResponse(tableName, context).onErrorResume(e -> e instanceof TableServiceException && ((TableServiceException)((Object)((Object)e))).getResponse() != null && ((TableServiceException)((Object)((Object)e))).getResponse().getStatusCode() == 409, e -> {
            HttpResponse response = ((TableServiceException)((Object)((Object)e))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTable(String tableName) {
        this.client.deleteTable(tableName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTableWithResponse(String tableName, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.deleteTableWithResponse(tableName, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TableItem> listTables() {
        return new PagedIterable(this.client.listTables());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TableItem> listTables(ListTablesOptions options, Duration timeout, Context context) {
        return new PagedIterable(TableUtils.applyOptionalTimeout(this.client.listTables(options, context), timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableServiceProperties getProperties() {
        return (TableServiceProperties)this.client.getProperties().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.getPropertiesWithResponse(context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(TableServiceProperties tableServiceProperties) {
        this.client.setProperties(tableServiceProperties).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesWithResponse(TableServiceProperties tableServiceProperties, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.setPropertiesWithResponse(tableServiceProperties, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableServiceStatistics getStatistics() {
        return (TableServiceStatistics)this.client.getStatistics().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableServiceStatistics> getStatisticsWithResponse(Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.getStatisticsWithResponse(context), timeout);
    }
}

