/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.MetaDataStorable;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.reporter.HttpMediaManagerImplKlov;
import com.aventstack.extentreports.reporter.KlovMedia;
import com.aventstack.extentreports.reporter.MediaStorage;
import com.aventstack.extentreports.reporter.MongoUtil;
import java.io.IOException;
import org.bson.Document;
import org.bson.types.ObjectId;

public class KlovMediaStorageHandler {
    private MediaStorage mediaStorage;
    private KlovMedia klovMedia;

    public KlovMediaStorageHandler(String url, KlovMedia klovMedia) throws IOException {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("Invalid URL or resource not found");
        }
        this.klovMedia = klovMedia;
        this.mediaStorage = new HttpMediaManagerImplKlov();
        this.mediaStorage.init(url);
    }

    public void saveScreenCapture(MetaDataStorable el, ScreenCapture media) throws IOException {
        Document doc = new Document("project", (Object)this.klovMedia.getProjectId()).append("report", (Object)this.klovMedia.getReportId()).append("test", media.getInfoMap().get("KLOV_TEST_ID"));
        if (el.getClass() != Test.class) {
            doc.append("log", media.getInfoMap().get("KLOV_LOG_ID"));
        } else {
            doc.append("testName", (Object)((Test)el).getName());
        }
        if (media.getBase64() != null) {
            doc.append("base64String", (Object)media.getBase64());
        }
        this.klovMedia.getMediaCollection().insertOne((Object)doc);
        ObjectId mediaId = MongoUtil.getId(doc);
        media.getInfoMap().put("KLOV_ID", mediaId);
        media.getInfoMap().put("KLOV_REPORT_ID", this.klovMedia.getReportId());
        if (media.getBase64() != null) {
            return;
        }
        this.mediaStorage.storeMedia((Media)media);
    }
}

