/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.markuputils;

import com.aventstack.extentreports.markuputils.CodeBlock;
import com.aventstack.extentreports.markuputils.CodeLanguage;
import com.aventstack.extentreports.markuputils.ExtentColor;
import com.aventstack.extentreports.markuputils.Label;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.markuputils.OrderedList;
import com.aventstack.extentreports.markuputils.Table;
import com.aventstack.extentreports.markuputils.UnorderedList;

public class MarkupHelper {
    public static Markup createLabel(String text, ExtentColor color) {
        return Label.builder().text(text).color(color).build();
    }

    public static Markup createCodeBlock(String code) {
        String[] stringArray;
        if (code == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = code;
        }
        String[] a = stringArray;
        return CodeBlock.builder().codeArray(a).build();
    }

    public static Markup createCodeBlock(String code1, String code2) {
        return CodeBlock.builder().codeArray(new String[]{code1, code2}).build();
    }

    public static Markup createCodeBlock(String code1, String code2, String code3) {
        return CodeBlock.builder().codeArray(new String[]{code1, code2, code3}).build();
    }

    public static Markup createCodeBlock(String code1, String code2, String code3, String code4) {
        return CodeBlock.builder().codeArray(new String[]{code1, code2, code3, code4}).build();
    }

    public static Markup createCodeBlock(String code, CodeLanguage lang) {
        return CodeBlock.builder().codeArray(new String[]{code}).lang(lang).build();
    }

    public static Markup createCodeBlocks(String[] code) {
        return CodeBlock.builder().codeArray(code).build();
    }

    public static Markup createJsonCodeBlock(Object o) {
        return CodeBlock.builder().jsonObject(o).lang(CodeLanguage.JSON).build();
    }

    public static Markup createOrderedList(Object o) {
        return OrderedList.builder().object(o).build();
    }

    public static Markup createUnorderedList(Object o) {
        return UnorderedList.builder().object(o).build();
    }

    public static Markup createTable(String[][] data, String[] cssClass) {
        return Table.builder().data(data).cssClasses(cssClass).build();
    }

    public static Markup createTable(String[][] data, String cssClass) {
        return Table.builder().data(data).cssClass(cssClass).build();
    }

    public static Markup createTable(String[][] data) {
        return Table.builder().data(data).build();
    }

    public static Markup toTable(Object o, String[] cssClass) {
        return Table.builder().object(o).cssClasses(cssClass).build();
    }

    public static Markup toTable(Object o, String cssClass) {
        return Table.builder().object(o).cssClass(cssClass).build();
    }

    public static Markup toTable(Object o) {
        return Table.builder().object(o).build();
    }
}

