/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.gson;

import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BddTypeAdapter
extends TypeAdapter<Class<? extends IGherkinFormatterModel>> {
    private static final Logger LOG = Logger.getLogger(BddTypeAdapter.class.getName());

    public Class<? extends IGherkinFormatterModel> read(JsonReader reader) throws IOException {
        while (reader.hasNext()) {
            String s;
            JsonToken token = reader.peek();
            if (!"string".equalsIgnoreCase(token.name()) || (s = reader.nextString()) == null || s.isEmpty()) continue;
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.SEVERE, "Failed to convert Gherkin type", e);
            }
        }
        return null;
    }

    public void write(JsonWriter out, Class<? extends IGherkinFormatterModel> value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(value.getName());
    }
}

