/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model.context;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.service.TestService;
import com.aventstack.extentreports.util.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class NamedAttributeContext<T extends NamedAttribute>
implements Serializable {
    private static final long serialVersionUID = -2671203343283101908L;
    private final List<Test> testList = Collections.synchronizedList(new ArrayList());
    private T attr;
    private Map<Status, Integer> statusDist = new HashMap<Status, Integer>();
    private int size;

    public NamedAttributeContext(T attribute, Test test) {
        this.attr = attribute;
        this.addTest(test);
    }

    public void addTest(Test test) {
        Assert.notNull(test, "Test must not be null");
        this.testList.add(test);
        this.refresh(test);
    }

    public void removeTest(Test test) {
        Assert.notNull(test, "Test must not be null");
        TestService.deleteTest(this.testList, test);
        this.refresh();
    }

    private synchronized void refresh(Test test) {
        this.statusDist.merge(test.getStatus(), 1, Integer::sum);
    }

    public void refresh() {
        this.statusDist.clear();
        this.testList.forEach(this::refresh);
        this.size = this.statusDist.values().stream().reduce(0, Integer::sum);
    }

    public Integer size() {
        return this.size;
    }

    public Integer getPassed() {
        return this.get(Status.PASS);
    }

    private Integer get(Status s) {
        return this.statusDist.get((Object)s) == null ? 0 : this.statusDist.get((Object)s);
    }

    public Integer getFailed() {
        return this.get(Status.FAIL);
    }

    public Integer getSkipped() {
        return this.get(Status.SKIP);
    }

    public Integer getOthers() {
        return this.get(Status.WARNING);
    }

    @Generated
    public List<Test> getTestList() {
        return this.testList;
    }

    @Generated
    public T getAttr() {
        return this.attr;
    }

    @Generated
    public Map<Status, Integer> getStatusDist() {
        return this.statusDist;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public String toString() {
        return "NamedAttributeContext(testList=" + this.getTestList() + ", attr=" + this.getAttr() + ", statusDist=" + this.getStatusDist() + ", size=" + this.getSize() + ")";
    }
}

