/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.filter;

import com.aventstack.extentreports.Status;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ContextFilter {
    private static final Builder BUILDER = new Builder();
    private Set<Status> status;
    private Set<String> author;
    private Set<String> category;
    private Set<String> device;

    public ContextFilter(Set<Status> status, Set<String> author, Set<String> category, Set<String> device) {
        this.status = status;
        this.author = author;
        this.category = category;
        this.device = device;
    }

    public static Builder builder() {
        return BUILDER;
    }

    @Generated
    public Set<Status> getStatus() {
        return this.status;
    }

    @Generated
    public Set<String> getAuthor() {
        return this.author;
    }

    @Generated
    public Set<String> getCategory() {
        return this.category;
    }

    @Generated
    public Set<String> getDevice() {
        return this.device;
    }

    public static class Builder {
        private Set<Status> statusSet;
        private Set<String> authorSet;
        private Set<String> categorySet;
        private Set<String> deviceSet;

        public Builder status(Set<Status> status) {
            this.statusSet = status;
            return this;
        }

        public Builder status(Status[] status) {
            return this.status(Arrays.stream(status).collect(Collectors.toSet()));
        }

        public Builder status(Status status) {
            return this.status(Stream.of(status).collect(Collectors.toSet()));
        }

        public Builder author(Set<String> author) {
            this.authorSet = author;
            return this;
        }

        public Builder author(String[] author) {
            return this.author(Arrays.stream(author).collect(Collectors.toSet()));
        }

        public Builder author(String author) {
            return this.author(Stream.of(author).collect(Collectors.toSet()));
        }

        public Builder category(Set<String> category) {
            this.categorySet = category;
            return this;
        }

        public Builder category(String[] category) {
            return this.category(Arrays.stream(category).collect(Collectors.toSet()));
        }

        public Builder category(String category) {
            return this.category(Stream.of(category).collect(Collectors.toSet()));
        }

        public Builder device(Set<String> device) {
            this.deviceSet = device;
            return this;
        }

        public Builder device(String[] device) {
            return this.author(Arrays.stream(device).collect(Collectors.toSet()));
        }

        public Builder device(String device) {
            return this.author(Stream.of(device).collect(Collectors.toSet()));
        }

        public ContextFilter build() {
            return new ContextFilter(this.statusSet, this.authorSet, this.categorySet, this.deviceSet);
        }
    }
}

