/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.Scenario;
import com.aventstack.extentreports.gherkin.model.ScenarioOutline;
import com.aventstack.extentreports.model.RunResult;
import com.aventstack.extentreports.model.Test;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;

public class ReportStats
implements Serializable {
    private static final long serialVersionUID = 5424613250832948474L;
    private AnalysisStrategy analysisStrategy = AnalysisStrategy.TEST;
    private final Map<Status, Long> parent = new ConcurrentHashMap<Status, Long>();
    private final Map<Status, Long> child = new ConcurrentHashMap<Status, Long>();
    private final Map<Status, Long> grandchild = new ConcurrentHashMap<Status, Long>();
    private final Map<Status, Long> log = new ConcurrentHashMap<Status, Long>();
    private final Map<Status, Float> parentPercentage = new ConcurrentHashMap<Status, Float>();
    private final Map<Status, Float> childPercentage = new ConcurrentHashMap<Status, Float>();
    private final Map<Status, Float> grandchildPercentage = new ConcurrentHashMap<Status, Float>();
    private final Map<Status, Float> logPercentage = new ConcurrentHashMap<Status, Float>();

    public final void update(List<Test> testList) {
        this.reset();
        if (testList == null || testList.isEmpty()) {
            return;
        }
        this.update(testList, this.parent, this.parentPercentage);
        List children = testList.stream().flatMap(x -> x.getChildren().stream()).filter(x -> x.getBddType() != ScenarioOutline.class).collect(Collectors.toList());
        List scenarios = testList.stream().flatMap(x -> x.getChildren().stream()).flatMap(x -> x.getChildren().stream()).filter(x -> x.getBddType() == Scenario.class).collect(Collectors.toList());
        children.addAll(scenarios);
        this.update(children, this.child, this.childPercentage);
        List grandChildren = children.stream().flatMap(x -> x.getChildren().stream()).filter(x -> x.getBddType() != Scenario.class).collect(Collectors.toList());
        this.update(grandChildren, this.grandchild, this.grandchildPercentage);
        List logs = testList.stream().flatMap(x -> x.getLogs().stream()).collect(Collectors.toList());
        logs.addAll(children.stream().flatMap(x -> x.getLogs().stream()).collect(Collectors.toList()));
        logs.addAll(grandChildren.stream().flatMap(x -> x.getLogs().stream()).collect(Collectors.toList()));
        this.update(logs, this.log, this.logPercentage);
    }

    private final void update(List<? extends RunResult> list, Map<Status, Long> countMap, Map<Status, Float> percentageMap) {
        if (list == null) {
            return;
        }
        Map<Status, Long> map = list.stream().collect(Collectors.groupingBy(RunResult::getStatus, Collectors.counting()));
        Arrays.asList(Status.values()).forEach(x -> {
            Long l = map.putIfAbsent((Status)((Object)x), 0L);
        });
        countMap.putAll(map);
        if (list.isEmpty()) {
            percentageMap.putAll(map.entrySet().stream().collect(Collectors.toMap(e -> (Status)((Object)((Object)e.getKey())), e -> Float.valueOf(((Long)e.getValue()).longValue()))));
            return;
        }
        Map<Status, Float> pctMap = map.entrySet().stream().collect(Collectors.toMap(e -> (Status)((Object)((Object)e.getKey())), e -> Float.valueOf((Long)e.getValue() * 100L / (long)list.size())));
        percentageMap.putAll(pctMap);
    }

    public final void reset() {
        ArrayList list = new ArrayList();
        this.update(list, this.parent, this.parentPercentage);
        this.update(list, this.child, this.childPercentage);
        this.update(list, this.grandchild, this.grandchildPercentage);
        this.update(list, this.log, this.logPercentage);
    }

    public final long sumStat(Map<Status, Long> stat) {
        return stat.values().stream().mapToLong(Long::longValue).sum();
    }

    @Generated
    public AnalysisStrategy getAnalysisStrategy() {
        return this.analysisStrategy;
    }

    @Generated
    public Map<Status, Long> getParent() {
        return this.parent;
    }

    @Generated
    public Map<Status, Long> getChild() {
        return this.child;
    }

    @Generated
    public Map<Status, Long> getGrandchild() {
        return this.grandchild;
    }

    @Generated
    public Map<Status, Long> getLog() {
        return this.log;
    }

    @Generated
    public Map<Status, Float> getParentPercentage() {
        return this.parentPercentage;
    }

    @Generated
    public Map<Status, Float> getChildPercentage() {
        return this.childPercentage;
    }

    @Generated
    public Map<Status, Float> getGrandchildPercentage() {
        return this.grandchildPercentage;
    }

    @Generated
    public Map<Status, Float> getLogPercentage() {
        return this.logPercentage;
    }

    @Generated
    public void setAnalysisStrategy(AnalysisStrategy analysisStrategy) {
        this.analysisStrategy = analysisStrategy;
    }

    @Generated
    public String toString() {
        return "ReportStats(analysisStrategy=" + (Object)((Object)this.getAnalysisStrategy()) + ", parent=" + this.getParent() + ", child=" + this.getChild() + ", grandchild=" + this.getGrandchild() + ", log=" + this.getLog() + ", parentPercentage=" + this.getParentPercentage() + ", childPercentage=" + this.getChildPercentage() + ", grandchildPercentage=" + this.getGrandchildPercentage() + ", logPercentage=" + this.getLogPercentage() + ")";
    }
}

