/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ReactiveSubject;
import com.aventstack.extentreports.append.RawEntityConverter;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.SystemEnvInfo;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.service.MediaService;
import com.aventstack.extentreports.model.service.TestService;
import java.io.File;
import java.io.IOException;
import lombok.Generated;

public abstract class AbstractProcessor
extends ReactiveSubject {
    private String[] mediaResolverPath;
    private boolean usingNaturalConf = true;

    @Override
    protected void onTestCreated(Test test) {
        this.getReport().getTestList().add(test);
        super.onTestCreated(test);
    }

    @Override
    protected void onTestRemoved(Test test) {
        TestService.deleteTest(this.getReport().getTestList(), test);
        super.onTestRemoved(test);
    }

    protected void onNodeCreated(Test node) {
        super.onTestCreated(node);
    }

    @Override
    protected void onLogCreated(Log log, Test test) {
        super.onLogCreated(log, test);
        if (log.hasException()) {
            this.getReport().getExceptionInfoCtx().addContext(log.getException(), test);
        }
    }

    @Override
    protected void onMediaAdded(Media m, Test test) {
        this.tryResolvePath(m);
        super.onMediaAdded(m, test);
    }

    @Override
    protected void onMediaAdded(Media m, Log log) {
        this.tryResolvePath(m);
        super.onMediaAdded(m, log);
    }

    private void tryResolvePath(Media m) {
        MediaService.tryResolveMediaPath(m, this.mediaResolverPath);
    }

    protected void onAuthorAdded(Author x, Test test) {
        this.getReport().getAuthorCtx().addContext(x, test);
        super.onAuthorAssigned(x, test);
    }

    protected void onCategoryAdded(Category x, Test test) {
        this.getReport().getCategoryCtx().addContext(x, test);
        super.onCategoryAssigned(x, test);
    }

    protected void onDeviceAdded(Device x, Test test) {
        this.getReport().getDeviceCtx().addContext(x, test);
        super.onDeviceAssigned(x, test);
    }

    @Override
    protected void onFlush() {
        this.getReport().refresh();
        if (!this.usingNaturalConf) {
            this.getReport().applyOverrideConf();
        }
        super.onFlush();
    }

    protected void onReportLogAdded(String log) {
        this.getReport().getLogs().add(log);
    }

    protected void onSystemInfoAdded(SystemEnvInfo env) {
        this.getReport().getSystemEnvInfo().add(env);
    }

    protected void convertRawEntities(ExtentReports extent, File f) throws IOException {
        RawEntityConverter converter = new RawEntityConverter(extent);
        converter.convertAndApply(f);
    }

    @Generated
    public String[] getMediaResolverPath() {
        return this.mediaResolverPath;
    }

    @Generated
    public boolean isUsingNaturalConf() {
        return this.usingNaturalConf;
    }

    @Generated
    public void setMediaResolverPath(String[] mediaResolverPath) {
        this.mediaResolverPath = mediaResolverPath;
    }

    @Generated
    public void setUsingNaturalConf(boolean usingNaturalConf) {
        this.usingNaturalConf = usingNaturalConf;
    }
}

