/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.configuration;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.configuration.ConfigurationStore;
import com.aventstack.extentreports.reporter.AbstractReporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class BasicConfiguration {
    private ConfigurationStore store = new ConfigurationStore();
    private AbstractReporter reporter;
    private List<Status> levels;

    protected BasicConfiguration(AbstractReporter reporter) {
        this.reporter = reporter;
    }

    protected AbstractReporter getReporter() {
        return this.reporter;
    }

    public ConfigurationStore getConfigurationStore() {
        return this.store;
    }

    public void setLevel(Status ... level) {
        if (this.levels == null) {
            this.levels = new ArrayList<Status>();
        }
        Arrays.stream(level).forEach(this.levels::add);
    }

    public List<Status> getLevel() {
        return this.levels;
    }

    public String getReportName() {
        return Optional.ofNullable(this.getConfigurationStore().getConfig("reportName")).orElse(null);
    }

    public void setReportName(String reportName) {
        this.store.storeConfig("reportName", reportName);
    }
}

