/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class AbstractStructure<T>
implements Serializable {
    private static final long serialVersionUID = -2630417398255980331L;
    private List<T> list = Collections.synchronizedList(new ArrayList());

    public void add(T t) {
        this.list.add(t);
    }

    public T get(int x) {
        return this.list.get(x);
    }

    public T getFirst() {
        return this.list.isEmpty() ? null : (T)this.list.get(0);
    }

    public T getLast() {
        return this.list.isEmpty() ? null : (T)this.list.get(this.list.size() - 1);
    }

    public List<T> getAll() {
        return this.list;
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public TIterator getIterator() {
        return new TIterator();
    }

    private class TIterator
    implements Iterator<T> {
        private int index = 0;

        TIterator() {
        }

        @Override
        public boolean hasNext() {
            return AbstractStructure.this.list != null && AbstractStructure.this.list.size() >= this.index + 1;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return AbstractStructure.this.list.get(this.index++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            AbstractStructure.this.list.remove(this.index);
        }
    }
}

